/*
 * Decompiled with CFR 0.152.
 */
package com.mrsuffix.singleplayersleep.managers;

import com.mrsuffix.singleplayersleep.SinglePlayerSleep;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AFKManager {
    private final SinglePlayerSleep plugin;
    private final Map<UUID, Long> lastActivity = new HashMap<UUID, Long>();
    private final Map<UUID, Location> lastLocation = new HashMap<UUID, Location>();

    public AFKManager(SinglePlayerSleep plugin) {
        this.plugin = plugin;
        this.startAFKChecker();
    }

    private void startAFKChecker() {
        new BukkitRunnable(){

            public void run() {
                if (!AFKManager.this.plugin.getConfigManager().isAFKDetectionEnabled()) {
                    return;
                }
                for (Player player : AFKManager.this.plugin.getServer().getOnlinePlayers()) {
                    AFKManager.this.checkPlayerMovement(player);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    private void checkPlayerMovement(Player player) {
        UUID uuid = player.getUniqueId();
        Location currentLocation = player.getLocation();
        Location lastLoc = this.lastLocation.get(uuid);
        if (lastLoc != null) {
            if (this.hasMoved(lastLoc, currentLocation)) {
                this.updateActivity(player);
            }
        } else {
            this.updateActivity(player);
        }
        this.lastLocation.put(uuid, currentLocation.clone());
    }

    private boolean hasMoved(Location from, Location to) {
        if (!from.getWorld().equals((Object)to.getWorld())) {
            return true;
        }
        double distance = from.distanceSquared(to);
        return distance > 0.1;
    }

    public void updateActivity(Player player) {
        this.lastActivity.put(player.getUniqueId(), System.currentTimeMillis());
        this.plugin.debugLog("Updated activity for " + player.getName());
    }

    public boolean isAFK(Player player) {
        if (!this.plugin.getConfigManager().isAFKDetectionEnabled()) {
            return false;
        }
        Long lastActive = this.lastActivity.get(player.getUniqueId());
        if (lastActive == null) {
            return false;
        }
        long afkTimeout = this.plugin.getConfigManager().getAFKTimeout() * 1000L;
        long timeSinceActive = System.currentTimeMillis() - lastActive;
        return timeSinceActive >= afkTimeout;
    }

    public int getActivePlayerCount(String worldName) {
        return (int)this.plugin.getServer().getWorld(worldName).getPlayers().stream().filter(player -> !this.isAFK((Player)player)).count();
    }

    public void removePlayer(Player player) {
        UUID uuid = player.getUniqueId();
        this.lastActivity.remove(uuid);
        this.lastLocation.remove(uuid);
        this.plugin.debugLog("Removed " + player.getName() + " from AFK tracking");
    }

    public long getTimeSinceActive(Player player) {
        Long lastActive = this.lastActivity.get(player.getUniqueId());
        if (lastActive == null) {
            return 0L;
        }
        return (System.currentTimeMillis() - lastActive) / 1000L;
    }
}

