/*
 * Decompiled with CFR 0.152.
 */
package com.mrsuffix.singleplayersleep.listeners;

import com.mrsuffix.singleplayersleep.SinglePlayerSleep;
import com.mrsuffix.singleplayersleep.utils.EffectUtil;
import com.mrsuffix.singleplayersleep.utils.MessageUtil;
import com.mrsuffix.singleplayersleep.utils.TimeUtil;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SleepListener
implements Listener {
    private final SinglePlayerSleep plugin;
    private final Set<String> processingSleep = new HashSet<String>();

    public SleepListener(SinglePlayerSleep plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerSleep(PlayerBedEnterEvent event) {
        final Player player = event.getPlayer();
        final World world = player.getWorld();
        this.plugin.debugLog("Player " + player.getName() + " attempted to sleep in world " + world.getName());
        if (event.isCancelled()) {
            this.plugin.debugLog("Sleep event was cancelled for " + player.getName());
            return;
        }
        if (!this.plugin.getConfigManager().isWorldEnabled(world.getName())) {
            this.plugin.debugLog("Sleep functionality disabled for world: " + world.getName());
            return;
        }
        if (!TimeUtil.isNight(world)) {
            this.plugin.debugLog("Not night time in world " + world.getName() + " (time: " + world.getTime() + ")");
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE || player.getGameMode() == GameMode.SPECTATOR) {
            this.plugin.debugLog("Player " + player.getName() + " is in " + String.valueOf(player.getGameMode()) + " mode, ignoring sleep");
            return;
        }
        if (this.plugin.getCooldownManager().isOnCooldown(world.getName())) {
            long remainingTime = this.plugin.getCooldownManager().getRemainingCooldown(world.getName());
            MessageUtil.sendMessage(player, this.plugin.getConfigManager().getMessage("cooldown-active").replace("{time}", String.valueOf(remainingTime / 1000L)));
            this.plugin.debugLog("World " + world.getName() + " is on cooldown for " + remainingTime + "ms");
            return;
        }
        final String worldKey = world.getName();
        if (this.processingSleep.contains(worldKey)) {
            this.plugin.debugLog("Sleep already being processed for world " + world.getName());
            return;
        }
        if (this.plugin.getConfigManager().isPercentageMode()) {
            this.handlePercentageMode(player, world);
            return;
        }
        this.processingSleep.add(worldKey);
        this.plugin.debugLog("Starting sleep process for " + player.getName() + " in world " + world.getName());
        EffectUtil.playSleepEffects(player);
        String sleepMessage = this.plugin.getConfigManager().getMessage("player-sleeping").replace("{player}", player.getName());
        MessageUtil.broadcastMessage(sleepMessage);
        this.plugin.getStatisticsManager().incrementSleepCount();
        this.plugin.getStatisticsManager().addPlayerSleep(player.getName());
        new BukkitRunnable(){

            public void run() {
                try {
                    SleepListener.this.skipNight(world, player);
                }
                finally {
                    SleepListener.this.processingSleep.remove(worldKey);
                }
            }
        }.runTaskLater((Plugin)this.plugin, this.plugin.getConfigManager().getSleepDelay());
    }

    private void skipNight(World world, Player sleeper) {
        this.plugin.debugLog("Skipping night in world " + world.getName());
        world.setTime(1000L);
        if (this.plugin.getConfigManager().shouldClearWeather()) {
            world.setStorm(false);
            world.setThundering(false);
            this.plugin.debugLog("Cleared weather in world " + world.getName());
        }
        for (Player player : world.getPlayers()) {
            EffectUtil.playMorningEffects(player);
        }
        String morningMessage = this.plugin.getConfigManager().getMessage("good-morning");
        MessageUtil.broadcastMessage(morningMessage);
        this.plugin.getCooldownManager().setCooldown(world.getName());
        new BukkitRunnable(){

            public void run() {
                SleepListener.this.performAutoSave();
            }
        }.runTaskLater((Plugin)this.plugin, this.plugin.getConfigManager().getAutoSaveDelay());
        this.plugin.debugLog("Night skipped successfully in world " + world.getName());
    }

    private void handlePercentageMode(final Player player, final World world) {
        long totalPlayers = world.getPlayers().stream().filter(p -> p.getGameMode() != GameMode.CREATIVE && p.getGameMode() != GameMode.SPECTATOR).filter(p -> !this.plugin.getConfigManager().shouldIgnoreAFKPlayers() || !this.plugin.getAFKManager().isAFK((Player)p)).count();
        long sleepingPlayers = world.getPlayers().stream().filter(LivingEntity::isSleeping).filter(p -> p.getGameMode() != GameMode.CREATIVE && p.getGameMode() != GameMode.SPECTATOR).filter(p -> !this.plugin.getConfigManager().shouldIgnoreAFKPlayers() || !this.plugin.getAFKManager().isAFK((Player)p)).count();
        int requiredPercentage = this.plugin.getConfigManager().getSleepPercentage();
        int requiredPlayers = (int)Math.ceil((double)(totalPlayers * (long)requiredPercentage) / 100.0);
        this.plugin.debugLog("Percentage mode: " + sleepingPlayers + "/" + requiredPlayers + " players sleeping (" + sleepingPlayers * 100L / Math.max(1L, totalPlayers) + "%)");
        if (sleepingPlayers >= (long)requiredPlayers) {
            final String worldKey = world.getName();
            if (this.processingSleep.contains(worldKey)) {
                return;
            }
            this.processingSleep.add(worldKey);
            this.plugin.debugLog("Percentage threshold reached, skipping night");
            world.getPlayers().stream().filter(LivingEntity::isSleeping).forEach(EffectUtil::playSleepEffects);
            String sleepMessage = this.plugin.getConfigManager().getMessage("player-sleeping").replace("{player}", sleepingPlayers + " players");
            MessageUtil.broadcastMessage(sleepMessage);
            this.plugin.getStatisticsManager().incrementSleepCount();
            world.getPlayers().stream().filter(LivingEntity::isSleeping).forEach(p -> this.plugin.getStatisticsManager().addPlayerSleep(p.getName()));
            new BukkitRunnable(){

                public void run() {
                    try {
                        SleepListener.this.skipNight(world, player);
                    }
                    finally {
                        SleepListener.this.processingSleep.remove(worldKey);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, this.plugin.getConfigManager().getSleepDelay());
        } else {
            int currentPercentage = (int)(sleepingPlayers * 100L / Math.max(1L, totalPlayers));
            String message = this.plugin.getConfigManager().getMessage("not-enough-sleepers").replace("{sleeping}", String.valueOf(sleepingPlayers)).replace("{required}", String.valueOf(requiredPlayers)).replace("{percentage}", String.valueOf(currentPercentage));
            world.getPlayers().forEach(p -> MessageUtil.sendMessage(p, message));
        }
    }

    private void performAutoSave() {
        if (!this.plugin.getConfigManager().isAutoSaveEnabled()) {
            return;
        }
        this.plugin.debugLog("Performing auto-save");
        String saveMessage = this.plugin.getConfigManager().getMessage("auto-save");
        MessageUtil.broadcastMessage(saveMessage);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)"save-all");
            this.plugin.debugLog("Auto-save completed");
        });
    }
}

