/*
 * Decompiled with CFR 0.152.
 */
package com.mrsuffix.singleplayersleep.commands;

import com.mrsuffix.singleplayersleep.SinglePlayerSleep;
import com.mrsuffix.singleplayersleep.utils.MessageUtil;
import com.mrsuffix.singleplayersleep.utils.TimeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class SleepCommand
implements CommandExecutor,
TabCompleter {
    private final SinglePlayerSleep plugin;

    public SleepCommand(SinglePlayerSleep plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.showHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "skip": {
                return this.handleSkip(sender, args);
            }
            case "stats": {
                return this.handleStats(sender);
            }
            case "reload": {
                return this.handleReload(sender);
            }
            case "debug": {
                return this.handleDebug(sender, args);
            }
            case "cooldown": {
                return this.handleCooldown(sender, args);
            }
        }
        this.showHelp(sender);
        return true;
    }

    private boolean handleSkip(CommandSender sender, String[] args) {
        World world;
        if (!sender.hasPermission("singleplayersleep.skip")) {
            MessageUtil.sendMessage(sender, this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (args.length > 1) {
            world = Bukkit.getWorld((String)args[1]);
            if (world == null) {
                MessageUtil.sendMessage(sender, "&cWorld '" + args[1] + "' not found!");
                return true;
            }
        } else if (sender instanceof Player) {
            world = ((Player)sender).getWorld();
        } else {
            MessageUtil.sendMessage(sender, "&cYou must specify a world name when using from console!");
            return true;
        }
        if (!TimeUtil.isNight(world)) {
            MessageUtil.sendMessage(sender, "&cIt's not night time in world " + world.getName() + "!");
            return true;
        }
        world.setTime(1000L);
        if (this.plugin.getConfigManager().shouldClearWeather()) {
            world.setStorm(false);
            world.setThundering(false);
        }
        MessageUtil.broadcastMessage("&6" + sender.getName() + " manually skipped the night!");
        this.plugin.getStatisticsManager().incrementManualSkips();
        return true;
    }

    private boolean handleStats(CommandSender sender) {
        if (!sender.hasPermission("singleplayersleep.stats")) {
            MessageUtil.sendMessage(sender, this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        MessageUtil.sendMessage(sender, "&6=== Sleep Statistics ===");
        MessageUtil.sendMessage(sender, "&eSleep Events: &f" + this.plugin.getStatisticsManager().getTotalSleepCount());
        MessageUtil.sendMessage(sender, "&eManual Skips: &f" + this.plugin.getStatisticsManager().getManualSkips());
        MessageUtil.sendMessage(sender, "&eTop Sleepers:");
        this.plugin.getStatisticsManager().getTopSleepers(5).forEach((player, count) -> MessageUtil.sendMessage(sender, "&7- &f" + player + "&7: &e" + count + " times"));
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("singleplayersleep.reload")) {
            MessageUtil.sendMessage(sender, this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        this.plugin.getConfigManager().loadConfig();
        MessageUtil.sendMessage(sender, "&aConfiguration reloaded successfully!");
        return true;
    }

    private boolean handleDebug(CommandSender sender, String[] args) {
        if (!sender.hasPermission("singleplayersleep.debug")) {
            MessageUtil.sendMessage(sender, this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        boolean newState = !this.plugin.isDebugMode();
        this.plugin.getConfigManager().setDebugMode(newState);
        MessageUtil.sendMessage(sender, "&aDebug mode " + (newState ? "enabled" : "disabled") + "!");
        return true;
    }

    private boolean handleCooldown(CommandSender sender, String[] args) {
        String worldName;
        if (!sender.hasPermission("singleplayersleep.cooldown")) {
            MessageUtil.sendMessage(sender, this.plugin.getConfigManager().getMessage("no-permission"));
            return true;
        }
        if (args.length < 2) {
            MessageUtil.sendMessage(sender, "&cUsage: /sleep cooldown <clear|check> [world]");
            return true;
        }
        String action = args[1].toLowerCase();
        String string = args.length > 2 ? args[2] : (worldName = sender instanceof Player ? ((Player)sender).getWorld().getName() : null);
        if (worldName == null) {
            MessageUtil.sendMessage(sender, "&cYou must specify a world name when using from console!");
            return true;
        }
        switch (action) {
            case "clear": {
                this.plugin.getCooldownManager().clearCooldown(worldName);
                MessageUtil.sendMessage(sender, "&aCooldown cleared for world " + worldName + "!");
                break;
            }
            case "check": {
                if (this.plugin.getCooldownManager().isOnCooldown(worldName)) {
                    long remaining = this.plugin.getCooldownManager().getRemainingCooldown(worldName);
                    MessageUtil.sendMessage(sender, "&eWorld " + worldName + " is on cooldown for " + remaining / 1000L + " more seconds.");
                    break;
                }
                MessageUtil.sendMessage(sender, "&aWorld " + worldName + " is not on cooldown.");
                break;
            }
            default: {
                MessageUtil.sendMessage(sender, "&cInvalid action. Use 'clear' or 'check'.");
            }
        }
        return true;
    }

    private void showHelp(CommandSender sender) {
        MessageUtil.sendMessage(sender, "&6=== SinglePlayerSleep Commands ===");
        MessageUtil.sendMessage(sender, "&e/sleep skip [world] &7- Manually skip night");
        MessageUtil.sendMessage(sender, "&e/sleep stats &7- View sleep statistics");
        MessageUtil.sendMessage(sender, "&e/sleep reload &7- Reload configuration");
        MessageUtil.sendMessage(sender, "&e/sleep debug &7- Toggle debug mode");
        MessageUtil.sendMessage(sender, "&e/sleep cooldown <clear|check> [world] &7- Manage cooldowns");
        MessageUtil.sendMessage(sender, "&e/sleep help &7- Show this help");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subcommands = Arrays.asList("skip", "stats", "reload", "debug", "cooldown", "help");
            for (String sub : subcommands) {
                if (!sub.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                completions.add(sub);
            }
        } else if (args.length == 2) {
            if (args[0].equalsIgnoreCase("skip")) {
                Bukkit.getWorlds().forEach(world -> completions.add(world.getName()));
            } else if (args[0].equalsIgnoreCase("cooldown")) {
                completions.addAll(Arrays.asList("clear", "check"));
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("cooldown")) {
            Bukkit.getWorlds().forEach(world -> completions.add(world.getName()));
        }
        return completions;
    }
}

