/*
 * Decompiled with CFR 0.152.
 */
package com.mrsuffix.singleplayersleep;

import com.mrsuffix.singleplayersleep.commands.SleepCommand;
import com.mrsuffix.singleplayersleep.listeners.AFKListener;
import com.mrsuffix.singleplayersleep.listeners.SleepListener;
import com.mrsuffix.singleplayersleep.managers.AFKManager;
import com.mrsuffix.singleplayersleep.managers.ConfigManager;
import com.mrsuffix.singleplayersleep.managers.CooldownManager;
import com.mrsuffix.singleplayersleep.managers.StatisticsManager;
import com.mrsuffix.singleplayersleep.managers.UpdateChecker;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class SinglePlayerSleep
extends JavaPlugin {
    private static SinglePlayerSleep instance;
    private ConfigManager configManager;
    private StatisticsManager statisticsManager;
    private CooldownManager cooldownManager;
    private AFKManager afkManager;
    private UpdateChecker updateChecker;
    private boolean debugMode;

    public void onEnable() {
        instance = this;
        this.configManager = new ConfigManager(this);
        this.statisticsManager = new StatisticsManager(this);
        this.cooldownManager = new CooldownManager(this);
        this.afkManager = new AFKManager(this);
        this.updateChecker = new UpdateChecker(this);
        this.configManager.loadConfig();
        this.statisticsManager.loadStatistics();
        this.debugMode = this.configManager.isDebugMode();
        this.getServer().getPluginManager().registerEvents((Listener)new SleepListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new AFKListener(this), (Plugin)this);
        this.getCommand("sleep").setExecutor((CommandExecutor)new SleepCommand(this));
        this.updateChecker.checkForUpdates();
        this.getLogger().info("SinglePlayerSleep v" + this.getDescription().getVersion() + " has been enabled!");
        if (this.debugMode) {
            this.getLogger().info("Debug mode is enabled.");
        }
    }

    public void onDisable() {
        if (this.statisticsManager != null) {
            this.statisticsManager.saveStatistics();
        }
        this.getLogger().info("SinglePlayerSleep has been disabled!");
    }

    public static SinglePlayerSleep getInstance() {
        return instance;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public StatisticsManager getStatisticsManager() {
        return this.statisticsManager;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public AFKManager getAFKManager() {
        return this.afkManager;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void debugLog(String message) {
        if (this.debugMode) {
            this.getLogger().log(Level.INFO, "[DEBUG] " + message);
        }
    }
}

