/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.util;

public enum ChatColor {
    BLACK('0', "\u00a70", "black"),
    DARK_BLUE('1', "\u00a71", "dark_blue"),
    DARK_GREEN('2', "\u00a72", "dark_green"),
    DARK_AQUA('3', "\u00a73", "dark_aqua"),
    DARK_RED('4', "\u00a74", "dark_red"),
    DARK_PURPLE('5', "\u00a75", "dark_purple"),
    GOLD('6', "\u00a76", "gold"),
    GRAY('7', "\u00a77", "gray"),
    DARK_GRAY('8', "\u00a78", "dark_gray"),
    BLUE('9', "\u00a79", "blue"),
    GREEN('a', "\u00a7a", "green"),
    AQUA('b', "\u00a7b", "aqua"),
    RED('c', "\u00a7c", "red"),
    LIGHT_PURPLE('d', "\u00a7d", "light_purple"),
    YELLOW('e', "\u00a7e", "yellow"),
    WHITE('f', "\u00a7f", "white"),
    ORANGE('g', "\u00a76", "orange"),
    PINK('h', "\u00a7d", "pink"),
    CYAN('i', "\u00a7b", "cyan"),
    LIME('j', "\u00a7a", "lime"),
    OBFUSCATED('k', "\u00a7k", "obfuscated"),
    BOLD('l', "\u00a7l", "bold"),
    ITALIC('m', "\u00a7o", "italic"),
    UNDERLINE('n', "\u00a7n", "underline"),
    STRIKETHROUGH('o', "\u00a7m", "strikethrough"),
    RESET('r', "\u00a7r", "reset");

    private final char code;
    private final String mcCode;
    private final String name;

    private ChatColor(char code, String mcCode, String name) {
        this.code = code;
        this.mcCode = mcCode;
        this.name = name;
    }

    public String toString() {
        return this.mcCode;
    }

    public String getName() {
        return this.name;
    }

    public static String translateAlternateColorCodes(char altColorChar, String textToTranslate) {
        StringBuilder sb = new StringBuilder();
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length; ++i) {
            ChatColor color;
            if (b[i] == altColorChar && i + 1 < b.length && (color = ChatColor.getByChar(b[i + 1])) != null) {
                sb.append(color.mcCode);
                ++i;
                continue;
            }
            sb.append(b[i]);
        }
        return sb.toString();
    }

    public static ChatColor getByChar(char code) {
        for (ChatColor color : ChatColor.values()) {
            if (color.code != code) continue;
            return color;
        }
        return null;
    }

    public static int[] hexToRgb(String hex) {
        return new int[]{Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16)};
    }

    public static String rgbToHex(int red, int green, int blue) {
        return String.format("%02x%02x%02x", red, green, blue);
    }

    public static String of(String hexColor) {
        return "\u00a7x\u00a7" + hexColor.charAt(0) + "\u00a7" + hexColor.charAt(1) + "\u00a7" + hexColor.charAt(2) + "\u00a7" + hexColor.charAt(3) + "\u00a7" + hexColor.charAt(4) + "\u00a7" + hexColor.charAt(5);
    }
}

