/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.listeners;

import fand.fandtpa.Main;
import fand.fandtpa.util.ChatColor;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class PlayerChatListener
implements Listener {
    private final Main plugin;
    private final Random random = new Random();

    public PlayerChatListener(Main plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        Object title = this.plugin.getTitlesConfig().getString(player.getUniqueId().toString());
        if (title != null && !((String)title).startsWith("[") && !((String)title).endsWith("]")) {
            title = "[" + (String)title + "]";
        }
        String message = event.getMessage();
        message = ChatColor.translateAlternateColorCodes('&', message);
        message = this.handleGradientColors(message);
        message = this.handleMagicCode(message);
        if (title != null) {
            String coloredTitle = ChatColor.translateAlternateColorCodes('&', (String)title);
            event.setFormat(coloredTitle + " " + player.getName() + ": " + message);
        } else {
            event.setFormat(player.getName() + ": " + message);
        }
    }

    private String handleGradientColors(String message) {
        Pattern gradientPattern = Pattern.compile("<([a-zA-Z0-9]+):([a-zA-Z0-9]+)>");
        Matcher matcher = gradientPattern.matcher(message);
        if (matcher.find()) {
            String gradientText;
            String startColor = matcher.group(1);
            String endColor = matcher.group(2);
            String textToColor = message.substring(matcher.end());
            message = matcher.replaceFirst("");
            message = gradientText = this.applyGradient(startColor, endColor, textToColor);
        }
        return message;
    }

    private String applyGradient(String startColor, String endColor, String text) {
        StringBuilder coloredText = new StringBuilder();
        int length = text.length();
        int[] startRGB = ChatColor.hexToRgb(startColor);
        int[] endRGB = ChatColor.hexToRgb(endColor);
        for (int i = 0; i < length; ++i) {
            double ratio = (double)i / (double)(length - 1);
            int red = (int)((double)startRGB[0] + ratio * (double)(endRGB[0] - startRGB[0]));
            int green = (int)((double)startRGB[1] + ratio * (double)(endRGB[1] - startRGB[1]));
            int blue = (int)((double)startRGB[2] + ratio * (double)(endRGB[2] - startRGB[2]));
            String hexColor = ChatColor.rgbToHex(red, green, blue);
            coloredText.append(ChatColor.of(hexColor)).append(text.charAt(i));
        }
        return coloredText.toString();
    }

    private String handleMagicCode(String message) {
        if (message.contains("&k")) {
            String[] parts = message.split("&k", 2);
            String beforeK = parts[0];
            String afterK = parts[1];
            StringBuilder obfuscatedText = new StringBuilder();
            for (char c : afterK.toCharArray()) {
                if (Character.isWhitespace(c)) {
                    obfuscatedText.append(c);
                    continue;
                }
                obfuscatedText.append(this.generateObfuscatedChar());
            }
            return beforeK + obfuscatedText.toString();
        }
        return message;
    }

    private char generateObfuscatedChar() {
        String obfuscatedChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()-=_+[]{}|;:',.<>/?`~";
        return obfuscatedChars.charAt(this.random.nextInt(obfuscatedChars.length()));
    }
}

