/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.util.ChatColor;
import fand.fandtpa.util.ConfigManager;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InvseeCommand
implements CommandExecutor {
    private final ConfigManager configManager;
    private final Map<Material, String> materialNames;
    private final boolean isHeadless;

    public InvseeCommand(ConfigManager configManager) {
        this.configManager = configManager;
        this.materialNames = this.loadMaterialNames();
        this.isHeadless = GraphicsEnvironment.isHeadless();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length == 0 || args.length > 2) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("invsee_usage")));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("invsee_player_not_found")));
            return true;
        }
        if (this.isHeadless || !(sender instanceof Player)) {
            if (args.length == 1) {
                this.displayInventory(sender, target);
            } else if (args.length == 2) {
                this.modifyInventory(sender, target, args[1]);
            }
        } else {
            this.openCustomInventoryViewForConsole(target);
        }
        return true;
    }

    private void displayInventory(CommandSender sender, Player target) {
        ItemStack[] inventoryContents = target.getInventory().getContents();
        StringBuilder inventoryDisplay = new StringBuilder("\u73a9\u5bb6 " + target.getName() + " \u7684\u80cc\u5305\u5185\u5bb9:\n");
        for (int i = 0; i < inventoryContents.length; ++i) {
            ItemStack item = inventoryContents[i];
            if (item != null && item.getType() != Material.AIR) {
                String itemName = this.materialNames.getOrDefault(item.getType(), item.getType().toString());
                inventoryDisplay.append("\u69fd\u4f4d ").append(i).append(": ").append(itemName).append(" x").append(item.getAmount()).append("\n");
                continue;
            }
            inventoryDisplay.append("\u69fd\u4f4d ").append(i).append(": \u7a7a\n");
        }
        sender.sendMessage(inventoryDisplay.toString());
    }

    private void modifyInventory(CommandSender sender, Player target, String slotArg) {
        try {
            int slot = Integer.parseInt(slotArg);
            if (slot < 0 || slot >= target.getInventory().getSize()) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "\u65e0\u6548\u7684\u69fd\u4f4d\u53f7\u3002");
                return;
            }
            target.getInventory().setItem(slot, null);
            sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "\u6210\u529f\u6e05\u9664\u73a9\u5bb6 " + target.getName() + " \u7684\u7b2c " + slot + " \u4e2a\u69fd\u4f4d\u7684\u7269\u54c1\u3002");
            target.updateInventory();
        }
        catch (NumberFormatException e) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "\u69fd\u4f4d\u53f7\u5fc5\u987b\u662f\u4e00\u4e2a\u6570\u5b57\u3002");
        }
    }

    private void openCustomInventoryViewForConsole(Player target) {
        JFrame frame = new JFrame("\u67e5\u770b\u73a9\u5bb6\u80cc\u5305: " + target.getName());
        frame.setLayout(new GridLayout(6, 9));
        frame.setSize(800, 600);
        frame.setDefaultCloseOperation(2);
        ItemStack[] inventoryContents = target.getInventory().getContents();
        for (int i = 0; i < inventoryContents.length; ++i) {
            JButton button = this.createInventoryButton(target, i, inventoryContents[i]);
            frame.add(button);
        }
        ItemStack offHandItem = target.getInventory().getItemInOffHand();
        JButton offHandButton = this.createInventoryButton(target, 40, offHandItem);
        frame.add(offHandButton);
        ItemStack[] armorContents = target.getInventory().getArmorContents();
        for (int i = 0; i < armorContents.length; ++i) {
            JButton button = this.createInventoryButton(target, 36 + i, armorContents[i]);
            frame.add(button);
        }
        frame.setVisible(true);
    }

    private JButton createInventoryButton(final Player target, final int slot, ItemStack item) {
        String itemName = "\u7a7a";
        if (item != null && item.getType() != Material.AIR) {
            itemName = this.materialNames.getOrDefault(item.getType(), item.getType().toString());
        }
        final JButton button = new JButton(itemName);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String itemType;
                if (SwingUtilities.isLeftMouseButton(e)) {
                    target.getInventory().setItem(slot, null);
                    InvseeCommand.this.updateInventoryForPlayer(target);
                    button.setText("\u7a7a");
                } else if (SwingUtilities.isRightMouseButton(e) && (itemType = JOptionPane.showInputDialog("\u8f93\u5165\u7269\u54c1\u7c7b\u578b\uff08\u82f1\u6587\uff09:")) != null && !itemType.trim().isEmpty()) {
                    try {
                        ItemStack newItem = new ItemStack(Material.valueOf((String)itemType.toUpperCase()));
                        target.getInventory().setItem(slot, newItem);
                        InvseeCommand.this.updateInventoryForPlayer(target);
                        button.setText(InvseeCommand.this.materialNames.getOrDefault(newItem.getType(), newItem.getType().toString()));
                    }
                    catch (IllegalArgumentException ex) {
                        JOptionPane.showMessageDialog(null, "\u65e0\u6548\u7684\u7269\u54c1\u7c7b\u578b\uff01");
                    }
                }
            }
        });
        return button;
    }

    private void updateInventoryForPlayer(Player player) {
        player.updateInventory();
    }

    private Map<Material, String> loadMaterialNames() {
        HashMap<Material, String> names = new HashMap<Material, String>();
        names.put(Material.AIR, "\u7a7a\u6c14");
        names.put(Material.STONE, "\u77f3\u5934");
        names.put(Material.GRANITE, "\u82b1\u5c97\u5ca9");
        names.put(Material.POLISHED_GRANITE, "\u78e8\u5236\u82b1\u5c97\u5ca9");
        names.put(Material.DIORITE, "\u95ea\u957f\u5ca9");
        names.put(Material.POLISHED_DIORITE, "\u78e8\u5236\u95ea\u957f\u5ca9");
        names.put(Material.ANDESITE, "\u5b89\u5c71\u5ca9");
        names.put(Material.POLISHED_ANDESITE, "\u78e8\u5236\u5b89\u5c71\u5ca9");
        names.put(Material.COBBLED_DEEPSLATE, "\u6df1\u677f\u5ca9");
        names.put(Material.POLISHED_DEEPSLATE, "\u78e8\u5236\u6df1\u677f\u5ca9");
        names.put(Material.CALCITE, "\u65b9\u89e3\u77f3");
        names.put(Material.TUFF, "\u51dd\u7070\u5ca9");
        names.put(Material.GRASS_BLOCK, "\u8349\u65b9\u5757");
        names.put(Material.DIRT, "\u6ce5\u571f");
        names.put(Material.COARSE_DIRT, "\u7802\u571f");
        names.put(Material.PODZOL, "\u7070\u5316\u571f");
        names.put(Material.ROOTED_DIRT, "\u6839\u7cfb\u6ce5\u571f");
        names.put(Material.MUD, "\u6ce5");
        names.put(Material.CRIMSON_NYLIUM, "\u7eef\u7ea2\u83cc\u5ca9");
        names.put(Material.WARPED_NYLIUM, "\u8be1\u5f02\u83cc\u5ca9");
        names.put(Material.COBBLESTONE, "\u5706\u77f3");
        names.put(Material.OAK_PLANKS, "\u6a61\u6728\u677f");
        names.put(Material.SPRUCE_PLANKS, "\u4e91\u6749\u6728\u677f");
        names.put(Material.BIRCH_PLANKS, "\u767d\u6866\u6728\u677f");
        names.put(Material.JUNGLE_PLANKS, "\u4e1b\u6797\u6728\u677f");
        names.put(Material.ACACIA_PLANKS, "\u91d1\u5408\u6b22\u6728\u677f");
        names.put(Material.CHERRY_PLANKS, "\u6a31\u6843\u6728\u677f");
        names.put(Material.DARK_OAK_PLANKS, "\u9ed1\u6a61\u6728\u677f");
        names.put(Material.MANGROVE_PLANKS, "\u7ea2\u6811\u6728\u677f");
        names.put(Material.BAMBOO_PLANKS, "\u7af9\u6728\u677f");
        names.put(Material.CRIMSON_PLANKS, "\u7eef\u7ea2\u6728\u677f");
        names.put(Material.WARPED_PLANKS, "\u8be1\u5f02\u6728\u677f");
        names.put(Material.SAND, "\u6c99\u5b50");
        names.put(Material.RED_SAND, "\u7ea2\u6c99");
        names.put(Material.GRAVEL, "\u6c99\u783e");
        names.put(Material.COAL_ORE, "\u7164\u77ff\u77f3");
        names.put(Material.IRON_ORE, "\u94c1\u77ff\u77f3");
        names.put(Material.COPPER_ORE, "\u94dc\u77ff\u77f3");
        names.put(Material.GOLD_ORE, "\u91d1\u77ff\u77f3");
        names.put(Material.DIAMOND_ORE, "\u94bb\u77f3\u77ff\u77f3");
        names.put(Material.NETHER_GOLD_ORE, "\u4e0b\u754c\u91d1\u77ff\u77f3");
        names.put(Material.NETHER_QUARTZ_ORE, "\u4e0b\u754c\u77f3\u82f1\u77ff\u77f3");
        names.put(Material.ANCIENT_DEBRIS, "\u8fdc\u53e4\u6b8b\u9ab8");
        names.put(Material.COAL_BLOCK, "\u7164\u70ad\u5757");
        names.put(Material.IRON_BLOCK, "\u94c1\u5757");
        names.put(Material.GOLD_BLOCK, "\u91d1\u5757");
        names.put(Material.DIAMOND_BLOCK, "\u94bb\u77f3\u5757");
        names.put(Material.NETHERITE_BLOCK, "\u4e0b\u754c\u5408\u91d1\u5757");
        names.put(Material.AMETHYST_BLOCK, "\u7d2b\u6c34\u6676\u5757");
        names.put(Material.LAPIS_BLOCK, "\u9752\u91d1\u77f3\u5757");
        names.put(Material.COPPER_BLOCK, "\u94dc\u5757");
        names.put(Material.REDSTONE_ORE, "\u7ea2\u77f3\u77ff\u77f3");
        names.put(Material.DEEPSLATE_REDSTONE_ORE, "\u6df1\u677f\u5ca9\u7ea2\u77f3\u77ff\u77f3");
        names.put(Material.EMERALD_ORE, "\u7eff\u5b9d\u77f3\u77ff\u77f3");
        names.put(Material.DEEPSLATE_EMERALD_ORE, "\u6df1\u677f\u5ca9\u7eff\u5b9d\u77f3\u77ff\u77f3");
        names.put(Material.IRON_INGOT, "\u94c1\u952d");
        names.put(Material.GOLD_INGOT, "\u91d1\u952d");
        names.put(Material.COPPER_INGOT, "\u94dc\u952d");
        names.put(Material.DIAMOND, "\u94bb\u77f3");
        names.put(Material.EMERALD, "\u7eff\u5b9d\u77f3");
        return names;
    }
}

