/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.Main;
import fand.fandtpa.util.ChatColor;
import fand.fandtpa.util.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class FandTpaCommand
implements CommandExecutor,
TabCompleter {
    private final Main plugin;
    private final ConfigManager configManager;

    public FandTpaCommand(Main plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("fandtpa.reload")) {
                    sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("no_permission")));
                    return true;
                }
                this.plugin.reloadConfig();
                this.configManager.reloadMessages();
                sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("fandtpa_reload_success")));
                break;
            }
            case "help": {
                this.sendHelpMessage(sender);
                break;
            }
            default: {
                sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("unknown_subcommand").replace("{command}", args[0])));
                this.sendHelpMessage(sender);
            }
        }
        return true;
    }

    private void sendHelpMessage(CommandSender sender) {
        StringBuilder availableCommands = new StringBuilder(ChatColor.translateAlternateColorCodes('&', "&e\u53ef\u7528\u547d\u4ee4\u5217\u8868:\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/tpa &7- \u8bf7\u6c42\u4f20\u9001\u5230\u67d0\u4e2a\u73a9\u5bb6 &e\u7528\u6cd5: /tpa <\u73a9\u5bb6\u540d>\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/tpaccept &7- \u63a5\u53d7\u4f20\u9001\u8bf7\u6c42 &e\u7528\u6cd5: /tpaccept\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/tpdeny &7- \u62d2\u7edd\u4f20\u9001\u8bf7\u6c42 &e\u7528\u6cd5: /tpdeny\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/tpahere &7- \u8bf7\u6c42\u5176\u4ed6\u73a9\u5bb6\u4f20\u9001\u5230\u4f60\u8fd9\u91cc &e\u7528\u6cd5: /tpahere <\u73a9\u5bb6\u540d>\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/home &7- \u5bb6\u7684\u7ba1\u7406\u547d\u4ee4 &e\u7528\u6cd5: /home <set/tp/del/list> <\u5bb6\u540d>\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/back &7- \u4f20\u9001\u5230\u4e0a\u4e00\u6b21\u6b7b\u4ea1\u5730\u70b9 &e\u7528\u6cd5: /back\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/settitle &7- \u4e3a\u73a9\u5bb6\u8bbe\u7f6e\u79f0\u53f7 &e\u7528\u6cd5: /settitle <\u73a9\u5bb6> <\u79f0\u53f7>\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/suicide &7- \u81ea\u6740\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/invsee &7- \u67e5\u770b\u5176\u4ed6\u73a9\u5bb6\u7684\u80cc\u5305 &e\u7528\u6cd5: /invsee <\u73a9\u5bb6\u540d>\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/hat &7- \u5c06\u624b\u4e2d\u7684\u7269\u54c1\u6234\u5728\u5934\u4e0a &e\u7528\u6cd5: /hat\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/rtp &7- \u968f\u673a\u4f20\u9001 &e\u7528\u6cd5: /rtp\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/fly &7- \u5207\u6362\u98de\u884c\u6a21\u5f0f &e\u7528\u6cd5: /fly\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/gm &7- \u5feb\u901f\u5207\u6362\u6e38\u620f\u6a21\u5f0f &e\u7528\u6cd5: /gm <\u6a21\u5f0f>\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/tab reload &7- \u91cd\u65b0\u52a0\u8f7dTAB\u914d\u7f6e &e\u7528\u6cd5: /tab reload\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/speed &7- \u8bbe\u7f6e\u73a9\u5bb6\u7684\u901f\u5ea6 &e\u7528\u6cd5: /speed <fly|walk> <speed>\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/eco &7- \u7ba1\u7406\u73a9\u5bb6\u7ecf\u6d4e &e\u7528\u6cd5: /eco <set|add|take> <\u73a9\u5bb6> <\u91d1\u989d>\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/money &7- \u83b7\u53d6\u73a9\u5bb6\u5f53\u524d\u7684\u91d1\u94b1 &e\u7528\u6cd5: /money\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/otp &7- \u5c06\u73a9\u5bb6\u4f20\u9001\u5230\u4e0a\u4e00\u6b21\u9000\u51fa\u7684\u4f4d\u7f6e &e\u7528\u6cd5: /otp\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/fandtpa &7- FandTPA\u63d2\u4ef6\u7684\u4e3b\u547d\u4ee4 &e\u7528\u6cd5: /fandtpa <reload|help>\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/v &7- \u9690\u8eab &e\u7528\u6cd5: /v\n"));
        availableCommands.append(ChatColor.translateAlternateColorCodes('&', "&6/hd reload &7- \u91cd\u8f7d\u5168\u606f\u5b57 &e\u7528\u6cd5: /hd reload\n"));
        sender.sendMessage(availableCommands.toString());
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if ("reload".startsWith(args[0].toLowerCase())) {
                completions.add("reload");
            }
            if ("help".startsWith(args[0].toLowerCase())) {
                completions.add("help");
            }
        }
        return completions;
    }
}

