/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa;

import fand.fandtpa.PortalData;
import fand.fandtpa.commands.BackCommand;
import fand.fandtpa.commands.EcoCommand;
import fand.fandtpa.commands.EcoTabCompleter;
import fand.fandtpa.commands.FServerCommand;
import fand.fandtpa.commands.FTInfoCommand;
import fand.fandtpa.commands.FandTpaCommand;
import fand.fandtpa.commands.FlyCommand;
import fand.fandtpa.commands.GmCommand;
import fand.fandtpa.commands.GmTabCompleter;
import fand.fandtpa.commands.HatCommand;
import fand.fandtpa.commands.HologramCommand;
import fand.fandtpa.commands.HomeCommand;
import fand.fandtpa.commands.HomeTabCompleter;
import fand.fandtpa.commands.InvseeCommand;
import fand.fandtpa.commands.MoneyCommand;
import fand.fandtpa.commands.OtpCommand;
import fand.fandtpa.commands.SetTitleCommand;
import fand.fandtpa.commands.SpeedCommand;
import fand.fandtpa.commands.SuicideCommand;
import fand.fandtpa.commands.TabReloadCommand;
import fand.fandtpa.commands.TpaCommand;
import fand.fandtpa.commands.TpacceptCommand;
import fand.fandtpa.commands.TpahereCommand;
import fand.fandtpa.commands.TpdenyCommand;
import fand.fandtpa.commands.TprandomCommand;
import fand.fandtpa.commands.VanishCommand;
import fand.fandtpa.economy.EcoManager;
import fand.fandtpa.listeners.OtpManager;
import fand.fandtpa.listeners.PlayerChatListener;
import fand.fandtpa.listeners.PlayerQuitListener;
import fand.fandtpa.listeners.PortalListener;
import fand.fandtpa.tab.TabListUpdater;
import fand.fandtpa.util.ChatColor;
import fand.fandtpa.util.ConfigManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class Main
extends JavaPlugin
implements Listener {
    public FileConfiguration tabConfig;
    private String language;
    private File homesFile;
    private FileConfiguration homesConfig;
    private File titlesFile;
    private FileConfiguration titlesConfig;
    private ConfigManager configManager;
    private boolean tabFunctionEnabled = true;
    private EcoManager ecoManager;
    private OtpManager otpManager;
    private File hologramsFile;
    private FileConfiguration hologramsConfig;
    private File portalsFile;
    private FileConfiguration portalsConfig;
    private Map<Location, PortalData> portalMap = new HashMap<Location, PortalData>();

    public void onEnable() {
        this.tabConfig = this.getConfig();
        this.otpManager = new OtpManager();
        this.checkForTabPlugin();
        this.configManager = new ConfigManager(this);
        try {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                this.getLogger().info("\u68c0\u6d4b\u5230PlaceholderAPI\uff0c\u5df2\u542f\u7528PlaceholderAPI\u652f\u6301\u3002");
            } else {
                this.getLogger().info("\u672a\u627e\u5230PlaceholderAPI\uff0c\u5c06\u5728\u6ca1\u6709PlaceholderAPI\u652f\u6301\u7684\u60c5\u51b5\u4e0b\u8fd0\u884c\u3002");
            }
            if (this.setupEconomy()) {
                this.getLogger().info("\u68c0\u6d4b\u5230 Vault \u63d2\u4ef6\uff0c\u5df2\u542f\u7528\u7ecf\u6d4e\u652f\u6301\u3002");
            } else {
                this.getLogger().warning("\u672a\u68c0\u6d4b\u5230 Vault \u63d2\u4ef6\uff0c\u7ecf\u6d4e\u529f\u80fd\u5c06\u65e0\u6cd5\u4f7f\u7528\u3002");
            }
            if (this.tabFunctionEnabled) {
                int time = 20;
                new TabListUpdater(this).runTaskTimer((Plugin)this, 0L, time);
            }
            String dbPath = this.getDataFolder().getAbsolutePath() + "/economy.db";
            this.ecoManager = new EcoManager(dbPath);
            this.loadHolograms();
            this.loadTabConfig();
            this.createDataFolders();
            this.loadPortals();
            this.startParticleEffects();
            this.language = this.getConfig().getString("language", "zh_CN");
            this.getLogger().info("\u5f53\u524d\u8bed\u8a00\u8bbe\u7f6e: " + this.language);
            this.loadLanguageFiles();
            this.configManager.reloadMessages();
            this.loadConfigurationFiles();
            this.registerCommands();
            this.registerListeners();
            this.logToConsole(this.configManager.getMessage("plugin_success"));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, this.configManager.getMessage("error_message").replace("{error}", e.getMessage()), e);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.otpManager.saveLogoutLocation(event.getPlayer());
    }

    public EcoManager getEcoManager() {
        return this.ecoManager;
    }

    private void loadHolograms() {
        this.hologramsFile = new File(this.getDataFolder(), "holograms.yml");
        if (!this.hologramsFile.exists()) {
            this.saveDefaultHologramsConfig();
        }
        this.hologramsConfig = YamlConfiguration.loadConfiguration((File)this.hologramsFile);
        @NotNull List hologramsList = this.hologramsConfig.getMapList("holograms");
        if (hologramsList.isEmpty()) {
            this.getLogger().warning("Holograms section not found in holograms.yml! Creating a default section.");
            this.saveDefaultHologramsConfig();
            return;
        }
        for (Map hologramData : hologramsList) {
            String text;
            String worldName = (String)hologramData.get("world");
            double x = (Double)hologramData.get("x");
            double y = (Double)hologramData.get("y");
            double z = (Double)hologramData.get("z");
            Object textObject = hologramData.get("text");
            if (textObject == null) {
                this.getLogger().warning("Hologram text is null, skipping...");
                continue;
            }
            if (textObject instanceof String) {
                text = (String)textObject;
            } else if (textObject instanceof List) {
                List textList = (List)textObject;
                text = String.join((CharSequence)"\n", textList);
            } else {
                this.getLogger().warning("Hologram text format is invalid, skipping...");
                continue;
            }
            if (text.isEmpty()) {
                this.getLogger().warning("Hologram text is empty, skipping...");
                continue;
            }
            World world = Bukkit.getWorld((String)worldName);
            if (world != null) {
                Location location = new Location(world, x, y, z);
                this.spawnHologram(location, text);
                continue;
            }
            this.getLogger().warning("World '" + worldName + "' not found for hologram at " + x + ", " + y + ", " + z);
        }
    }

    private void saveDefaultHologramsConfig() {
        this.hologramsConfig = YamlConfiguration.loadConfiguration((File)this.hologramsFile);
        ArrayList defaultHolograms = new ArrayList();
        HashMap<String, Object> exampleHologram = new HashMap<String, Object>();
        exampleHologram.put("world", "world");
        exampleHologram.put("x", 100.5);
        exampleHologram.put("y", 65.0);
        exampleHologram.put("z", 200.5);
        exampleHologram.put("text", "\u6b22\u8fce\u6765\u5230\u670d\u52a1\u5668\uff01");
        defaultHolograms.add(exampleHologram);
        this.hologramsConfig.set("holograms", defaultHolograms);
        try {
            this.hologramsConfig.save(this.hologramsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reloadHolograms() {
        Bukkit.getWorlds().forEach(world -> world.getEntitiesByClass(ArmorStand.class).stream().filter(armorStand -> armorStand.isMarker() && armorStand.getCustomName() != null).forEach(Entity::remove));
        this.loadHolograms();
    }

    private void spawnHologram(Location location, String text) {
        String[] lines = text.split("\n");
        double lineSpacing = 0.25;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            ArmorStand armorStand = (ArmorStand)location.getWorld().spawn(location.clone().add(0.0, (double)(-i) * lineSpacing, 0.0), ArmorStand.class);
            armorStand.setGravity(false);
            armorStand.setVisible(false);
            armorStand.setCustomName(ChatColor.translateAlternateColorCodes('&', line));
            armorStand.setCustomNameVisible(true);
            armorStand.setMarker(true);
        }
    }

    private boolean setupEconomy() {
        try {
            if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
                return false;
            }
            Class<?> rspClass = Class.forName("org.bukkit.plugin.RegisteredServiceProvider");
            Method getServicesManagerMethod = this.getServer().getClass().getMethod("getServicesManager", new Class[0]);
            Object servicesManager = getServicesManagerMethod.invoke((Object)this.getServer(), new Object[0]);
            Method getRegistrationMethod = servicesManager.getClass().getMethod("getRegistration", Class.class);
            Object rsp = getRegistrationMethod.invoke(servicesManager, Class.forName("net.milkbowl.vault.economy.Economy"));
            if (rsp != null) {
                Method getProviderMethod = rspClass.getMethod("getProvider", new Class[0]);
                Object economy = getProviderMethod.invoke(rsp, new Object[0]);
                return economy != null;
            }
            return false;
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Vault \u672a\u627e\u5230\uff0c\u7ecf\u6d4e\u529f\u80fd\u7981\u7528: " + e.getMessage());
            return false;
        }
    }

    private void checkForTabPlugin() {
        Plugin tabPlugin = Bukkit.getPluginManager().getPlugin("TAB");
        if (tabPlugin != null && tabPlugin.isEnabled()) {
            this.tabFunctionEnabled = false;
        }
    }

    public void onDisable() {
        this.logToConsole(this.configManager.getMessage("plugin_disabled"));
        this.saveConfigurationFiles();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    private void loadLanguageFiles() {
        File languageFile;
        String[] supportedLanguages;
        File langFolder = new File(this.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        for (String langFileName : supportedLanguages = new String[]{"zh_CN.yml", "en_us.yml"}) {
            File langFile = new File(langFolder, langFileName);
            if (langFile.exists()) continue;
            this.saveResource("lang/" + langFileName, false);
            this.getLogger().info("\u91ca\u653e\u8bed\u8a00\u6587\u4ef6: " + langFileName);
        }
        if (this.language == null) {
            this.getLogger().severe("\u8bed\u8a00\u672a\u8bbe\u7f6e\uff0c\u52a0\u8f7d\u9ed8\u8ba4\u8bed\u8a00\u6587\u4ef6: zh_CN.yml");
            this.language = "zh_CN";
        }
        if ((languageFile = new File(langFolder, this.language + ".yml")).exists()) {
            this.getLogger().info("\u52a0\u8f7d\u8bed\u8a00\u6587\u4ef6: " + languageFile.getAbsolutePath());
        } else {
            this.getLogger().severe("\u8bed\u8a00\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25: " + languageFile.getAbsolutePath());
        }
    }

    public void loadTabConfig() {
        File tabFile = new File(this.getDataFolder(), "tab.yml");
        if (!tabFile.exists()) {
            this.saveResource("tab.yml", false);
        }
        this.tabConfig = YamlConfiguration.loadConfiguration((File)tabFile);
    }

    private void createDataFolders() {
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdirs()) {
            this.getLogger().severe("\u63d2\u4ef6\u4e3b\u6570\u636e\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25: " + this.getDataFolder().getPath());
            return;
        }
        this.homesFile = this.createFile("homes.yml");
        this.titlesFile = this.createFile("titles.yml");
    }

    private File createFile(String fileName) {
        File file = new File(this.getDataFolder(), fileName);
        if (!file.exists()) {
            try {
                if (file.createNewFile()) {
                    this.getLogger().info(fileName + " \u6587\u4ef6\u521b\u5efa\u6210\u529f: " + file.getPath());
                } else {
                    this.getLogger().severe(fileName + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25: " + file.getPath());
                }
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "\u521b\u5efa " + fileName + " \u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage(), e);
            }
        }
        return file;
    }

    private void loadConfigurationFiles() {
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
        this.titlesConfig = YamlConfiguration.loadConfiguration((File)this.titlesFile);
    }

    private void saveConfigurationFiles() {
        this.saveConfigFile(this.homesConfig, this.homesFile);
        this.saveConfigFile(this.titlesConfig, this.titlesFile);
    }

    private void saveConfigFile(FileConfiguration config, File file) {
        try {
            if (config != null && file != null) {
                config.save(file);
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, this.configManager.getMessage("error_message").replace("{error}", e.getMessage()), e);
        }
    }

    public FileConfiguration getHomesConfig() {
        return this.homesConfig;
    }

    public void saveHomesConfig() {
        this.saveConfigFile(this.homesConfig, this.homesFile);
    }

    public FileConfiguration getTitlesConfig() {
        return this.titlesConfig;
    }

    public void saveTitlesConfig() {
        this.saveConfigFile(this.titlesConfig, this.titlesFile);
    }

    public void toggleVanish(Player player) {
        if (player.hasMetadata("vanished")) {
            player.removeMetadata("vanished", (Plugin)this);
            Bukkit.getOnlinePlayers().forEach(p -> p.showPlayer((Plugin)this, player));
            player.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "\u4f60\u73b0\u5728\u5df2\u53d6\u6d88\u9690\u8eab\uff01");
        } else {
            player.setMetadata("vanished", (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)true));
            Bukkit.getOnlinePlayers().forEach(p -> p.hidePlayer((Plugin)this, player));
            player.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "\u4f60\u73b0\u5728\u5df2\u9690\u8eab\uff01");
        }
    }

    private void registerCommands() {
        Objects.requireNonNull(this.getCommand("tpa")).setExecutor((CommandExecutor)new TpaCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("tpahere")).setExecutor((CommandExecutor)new TpahereCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("tpaccept")).setExecutor((CommandExecutor)new TpacceptCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("tpdeny")).setExecutor((CommandExecutor)new TpdenyCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("home")).setExecutor((CommandExecutor)new HomeCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("home")).setTabCompleter((TabCompleter)new HomeTabCompleter(this));
        Objects.requireNonNull(this.getCommand("back")).setExecutor((CommandExecutor)new BackCommand(this.getLogger(), this.configManager));
        Objects.requireNonNull(this.getCommand("settitle")).setExecutor((CommandExecutor)new SetTitleCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("suicide")).setExecutor((CommandExecutor)new SuicideCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("rtp")).setExecutor((CommandExecutor)new TprandomCommand(this));
        Objects.requireNonNull(this.getCommand("invsee")).setExecutor((CommandExecutor)new InvseeCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("hat")).setExecutor((CommandExecutor)new HatCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("fly")).setExecutor((CommandExecutor)new FlyCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("gm")).setExecutor((CommandExecutor)new GmCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("gm")).setTabCompleter((TabCompleter)new GmTabCompleter());
        Objects.requireNonNull(this.getCommand("tab")).setExecutor((CommandExecutor)new TabReloadCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("eco")).setExecutor((CommandExecutor)new EcoCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("eco")).setTabCompleter((TabCompleter)new EcoTabCompleter());
        Objects.requireNonNull(this.getCommand("speed")).setExecutor((CommandExecutor)new SpeedCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("money")).setExecutor((CommandExecutor)new MoneyCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("otp")).setExecutor((CommandExecutor)new OtpCommand(this.otpManager, this.configManager));
        Objects.requireNonNull(this.getCommand("fandtpa")).setExecutor((CommandExecutor)new FandTpaCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("fandtpa")).setTabCompleter((TabCompleter)new FandTpaCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("v")).setExecutor((CommandExecutor)new VanishCommand(this));
        Objects.requireNonNull(this.getCommand("hd")).setExecutor((CommandExecutor)new HologramCommand(this));
        Objects.requireNonNull(this.getCommand("fserver")).setExecutor((CommandExecutor)new FServerCommand());
        Objects.requireNonNull(this.getCommand("ftinfo")).setExecutor((CommandExecutor)new FTInfoCommand(this));
    }

    private void registerListeners() {
        BackCommand backCommand = new BackCommand(this.getLogger(), new ConfigManager(this));
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)backCommand, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(this.otpManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PortalListener(this), (Plugin)this);
    }

    private void logToConsole(String message) {
        this.getServer().getConsoleSender().sendMessage(message);
    }

    public void loadPortals() {
        this.portalsFile = new File(this.getDataFolder(), "portals.yml");
        if (!this.portalsFile.exists()) {
            this.saveResource("portals.yml", false);
        }
        this.portalsConfig = YamlConfiguration.loadConfiguration((File)this.portalsFile);
        this.portalMap.clear();
        ConfigurationSection worldsSection = this.portalsConfig.getConfigurationSection("portals");
        if (worldsSection != null) {
            for (String worldName : worldsSection.getKeys(false)) {
                ConfigurationSection worldSection;
                World world = Bukkit.getWorld((String)worldName);
                if (world == null || (worldSection = worldsSection.getConfigurationSection(worldName)) == null) continue;
                for (String portalKey : worldSection.getKeys(false)) {
                    ConfigurationSection portalSection = worldSection.getConfigurationSection(portalKey);
                    if (portalSection == null) continue;
                    double x1 = portalSection.getDouble("region.x1");
                    double y1 = portalSection.getDouble("region.y1");
                    double z1 = portalSection.getDouble("region.z1");
                    double x2 = portalSection.getDouble("region.x2");
                    double y2 = portalSection.getDouble("region.y2");
                    double z2 = portalSection.getDouble("region.z2");
                    String command = portalSection.getString("command");
                    String particleEffect = portalSection.getString("particles", "");
                    Location corner1 = new Location(world, x1, y1, z1);
                    Location corner2 = new Location(world, x2, y2, z2);
                    PortalData portalData = new PortalData(corner1, corner2, command, particleEffect);
                    this.portalMap.put(corner1, portalData);
                }
            }
        }
    }

    public void startParticleEffects() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            for (PortalData portal : this.portalMap.values()) {
                if (!portal.hasParticles()) continue;
                try {
                    Particle particle = Particle.valueOf((String)portal.getParticleEffect().toUpperCase());
                    this.generatePortalParticles(portal, particle);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid particle effect: " + portal.getParticleEffect() + ". Disabling particles.");
                    portal.disableParticles();
                }
            }
        }, 0L, 20L);
    }

    private void generatePortalParticles(PortalData portal, Particle particle) {
        World world = portal.getCorner1().getWorld();
        int minX = Math.min(portal.getCorner1().getBlockX(), portal.getCorner2().getBlockX());
        int maxX = Math.max(portal.getCorner1().getBlockX(), portal.getCorner2().getBlockX());
        int minY = Math.min(portal.getCorner1().getBlockY(), portal.getCorner2().getBlockY());
        int maxY = Math.max(portal.getCorner1().getBlockY(), portal.getCorner2().getBlockY());
        int minZ = Math.min(portal.getCorner1().getBlockZ(), portal.getCorner2().getBlockZ());
        int maxZ = Math.max(portal.getCorner1().getBlockZ(), portal.getCorner2().getBlockZ());
        for (int x = minX; x <= maxX; ++x) {
            this.spawnParticleAt(world, particle, x, minY, minZ);
            this.spawnParticleAt(world, particle, x, minY, maxZ);
            this.spawnParticleAt(world, particle, x, maxY, minZ);
            this.spawnParticleAt(world, particle, x, maxY, maxZ);
        }
        for (int y = minY; y <= maxY; ++y) {
            this.spawnParticleAt(world, particle, minX, y, minZ);
            this.spawnParticleAt(world, particle, minX, y, maxZ);
            this.spawnParticleAt(world, particle, maxX, y, minZ);
            this.spawnParticleAt(world, particle, maxX, y, maxZ);
        }
        for (int z = minZ; z <= maxZ; ++z) {
            this.spawnParticleAt(world, particle, minX, minY, z);
            this.spawnParticleAt(world, particle, minX, maxY, z);
            this.spawnParticleAt(world, particle, maxX, minY, z);
            this.spawnParticleAt(world, particle, maxX, maxY, z);
        }
    }

    private void spawnParticleAt(World world, Particle particle, int x, int y, int z) {
        Location loc = new Location(world, (double)x, (double)y, (double)z);
        world.spawnParticle(particle, loc, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public void executePortalCommand(Player player, PortalData portalData) {
        String command = portalData.getCommand().replace("{player}", player.getName());
        this.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), command);
        if (portalData.hasParticles()) {
            try {
                Particle particle = Particle.valueOf((String)portalData.getParticleEffect().toUpperCase());
                Location center = portalData.getCorner1().toVector().getMidpoint(portalData.getCorner2().toVector()).toLocation(portalData.getCorner1().getWorld());
                player.getWorld().spawnParticle(particle, center, 30);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Invalid particle effect: " + portalData.getParticleEffect() + ". Disabling particles.");
                portalData.disableParticles();
            }
        }
    }

    public Map<Location, PortalData> getPortalMap() {
        return this.portalMap;
    }
}

