/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.util.ChatColor;
import fand.fandtpa.util.ConfigManager;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InvseeCommand
implements CommandExecutor {
    private final ConfigManager configManager;
    private final Map<Material, String> materialNames;
    private final boolean isHeadless;

    public InvseeCommand(ConfigManager configManager) {
        this.configManager = configManager;
        this.materialNames = this.loadMaterialNames();
        this.isHeadless = GraphicsEnvironment.isHeadless();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (args.length == 0 || args.length > 2) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("invsee_usage")));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("invsee_player_not_found")));
            return true;
        }
        if (this.isHeadless || !(sender instanceof Player)) {
            if (args.length == 1) {
                this.displayInventory(sender, target);
            } else if (args.length == 2) {
                this.modifyInventory(sender, target, args[1]);
            }
        } else {
            this.openCustomInventoryViewForConsole(target);
        }
        return true;
    }

    private void displayInventory(CommandSender sender, Player target) {
        ItemStack[] inventoryContents = target.getInventory().getContents();
        StringBuilder inventoryDisplay = new StringBuilder("\u73a9\u5bb6 " + target.getName() + " \u7684\u80cc\u5305\u5185\u5bb9:\n");
        for (int i = 0; i < inventoryContents.length; ++i) {
            ItemStack item = inventoryContents[i];
            if (item != null && item.getType() != Material.AIR) {
                String itemName = this.materialNames.getOrDefault(item.getType(), item.getType().toString());
                inventoryDisplay.append("\u69fd\u4f4d ").append(i).append(": ").append(itemName).append(" x").append(item.getAmount()).append("\n");
                continue;
            }
            inventoryDisplay.append("\u69fd\u4f4d ").append(i).append(": \u7a7a\n");
        }
        sender.sendMessage(inventoryDisplay.toString());
    }

    private void modifyInventory(CommandSender sender, Player target, String slotArg) {
        try {
            int slot = Integer.parseInt(slotArg);
            if (slot < 0 || slot >= target.getInventory().getSize()) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "\u65e0\u6548\u7684\u69fd\u4f4d\u53f7\u3002");
                return;
            }
            target.getInventory().setItem(slot, null);
            sender.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "\u6210\u529f\u6e05\u9664\u73a9\u5bb6 " + target.getName() + " \u7684\u7b2c " + slot + " \u4e2a\u69fd\u4f4d\u7684\u7269\u54c1\u3002");
            target.updateInventory();
        }
        catch (NumberFormatException e) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "\u69fd\u4f4d\u53f7\u5fc5\u987b\u662f\u4e00\u4e2a\u6570\u5b57\u3002");
        }
    }

    private void openCustomInventoryViewForConsole(Player target) {
        JFrame frame = new JFrame("\u67e5\u770b\u73a9\u5bb6\u80cc\u5305: " + target.getName());
        frame.setLayout(new GridLayout(6, 9));
        frame.setSize(800, 600);
        frame.setDefaultCloseOperation(2);
        ItemStack[] inventoryContents = target.getInventory().getContents();
        for (int i = 0; i < inventoryContents.length; ++i) {
            JButton button = this.createInventoryButton(target, i, inventoryContents[i]);
            frame.add(button);
        }
        ItemStack offHandItem = target.getInventory().getItemInOffHand();
        JButton offHandButton = this.createInventoryButton(target, 40, offHandItem);
        frame.add(offHandButton);
        ItemStack[] armorContents = target.getInventory().getArmorContents();
        for (int i = 0; i < armorContents.length; ++i) {
            JButton button = this.createInventoryButton(target, 36 + i, armorContents[i]);
            frame.add(button);
        }
        frame.setVisible(true);
    }

    private JButton createInventoryButton(final Player target, final int slot, ItemStack item) {
        String itemName = "\u7a7a";
        if (item != null && item.getType() != Material.AIR) {
            itemName = this.materialNames.getOrDefault(item.getType(), item.getType().toString());
        }
        final JButton button = new JButton(itemName);
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String itemType;
                if (SwingUtilities.isLeftMouseButton(e)) {
                    target.getInventory().setItem(slot, null);
                    InvseeCommand.this.updateInventoryForPlayer(target);
                    button.setText("\u7a7a");
                } else if (SwingUtilities.isRightMouseButton(e) && (itemType = JOptionPane.showInputDialog("\u8f93\u5165\u7269\u54c1\u7c7b\u578b\uff08\u82f1\u6587\uff09:")) != null && !itemType.trim().isEmpty()) {
                    try {
                        ItemStack newItem = new ItemStack(Material.valueOf((String)itemType.toUpperCase()));
                        target.getInventory().setItem(slot, newItem);
                        InvseeCommand.this.updateInventoryForPlayer(target);
                        button.setText(InvseeCommand.this.materialNames.getOrDefault(newItem.getType(), newItem.getType().toString()));
                    }
                    catch (IllegalArgumentException ex) {
                        JOptionPane.showMessageDialog(null, "\u65e0\u6548\u7684\u7269\u54c1\u7c7b\u578b\uff01");
                    }
                }
            }
        });
        return button;
    }

    private void updateInventoryForPlayer(Player player) {
        player.updateInventory();
    }

    private Map<Material, String> loadMaterialNames() {
        HashMap<Material, String> names = new HashMap<Material, String>();
        names.put(Material.STONE, "\u77f3\u5934");
        names.put(Material.DIRT, "\u6ce5\u571f");
        return names;
    }
}

