/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.Main;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class HomeTabCompleter
implements TabCompleter {
    private final Main plugin;

    public HomeTabCompleter(Main plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return null;
        }
        Player player = (Player)sender;
        UUID playerUUID = player.getUniqueId();
        List<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions = this.getFirstArgCompletions(args[0]);
        } else if (args.length == 2 && (args[0].equalsIgnoreCase("tp") || args[0].equalsIgnoreCase("del"))) {
            completions = this.getHomeNameCompletions(playerUUID, args[1]);
        }
        return completions;
    }

    private List<String> getFirstArgCompletions(String input) {
        ArrayList<String> subCommands = new ArrayList<String>();
        subCommands.add("set");
        subCommands.add("tp");
        subCommands.add("del");
        subCommands.add("list");
        return (List)StringUtil.copyPartialMatches((String)input, subCommands, new ArrayList());
    }

    private List<String> getHomeNameCompletions(UUID playerUUID, String input) {
        List<String> completions = new ArrayList<String>();
        String path = "homes." + String.valueOf(playerUUID);
        if (this.plugin.getHomesConfig().contains(path)) {
            Map homes = Objects.requireNonNull(this.plugin.getHomesConfig().getConfigurationSection(path)).getValues(false);
            completions = (List)StringUtil.copyPartialMatches((String)input, new ArrayList(homes.keySet()), new ArrayList());
        }
        return completions;
    }
}

