/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.economy;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

public class EcoManager {
    private final String dbUrl;

    public EcoManager(String dbPath) {
        this.dbUrl = "jdbc:sqlite:" + dbPath;
        this.initializeDatabase();
    }

    private void initializeDatabase() {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("CREATE TABLE IF NOT EXISTS player_balance (uuid TEXT PRIMARY KEY,balance TEXT NOT NULL)");){
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public BigDecimal getBalance(UUID playerUUID) {
        return this.getBalance(playerUUID, BigDecimal.ZERO);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BigDecimal getBalance(UUID playerUUID, BigDecimal defaultValue) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("SELECT balance FROM player_balance WHERE uuid = ?");){
            stmt.setString(1, playerUUID.toString());
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.next()) return defaultValue;
                BigDecimal bigDecimal = new BigDecimal(rs.getString("balance"));
                return bigDecimal;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public void setBalance(UUID playerUUID, BigDecimal amount) {
        try (Connection conn = this.getConnection();
             PreparedStatement stmt = conn.prepareStatement("INSERT OR REPLACE INTO player_balance (uuid, balance) VALUES (?, ?)");){
            stmt.setString(1, playerUUID.toString());
            stmt.setString(2, amount.toString());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void addBalance(UUID playerUUID, BigDecimal amount) {
        BigDecimal newBalance = this.getBalance(playerUUID).add(amount);
        this.setBalance(playerUUID, newBalance);
    }

    private Connection getConnection() throws SQLException {
        int retryCount = 0;
        while (retryCount < 3) {
            try {
                return DriverManager.getConnection(this.dbUrl);
            }
            catch (SQLException e) {
                if (++retryCount == 3) {
                    throw e;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw new SQLException("\u65e0\u6cd5\u5efa\u7acb\u6570\u636e\u5e93\u8fde\u63a5");
    }

    public String getBalanceAsString(UUID playerUUID) {
        return this.getBalance(playerUUID).toPlainString();
    }
}

