/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.util.ChatColor;
import fand.fandtpa.util.ConfigManager;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TpahereCommand
implements CommandExecutor {
    private final HashMap<UUID, UUID> tpahereRequests = new HashMap();
    private final ConfigManager configManager;

    public TpahereCommand(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpahere_only_player")));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpahere_usage")));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpahere_player_not_found")));
            return true;
        }
        if (player.equals((Object)target)) {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpahere_self_request")));
            return true;
        }
        this.sendTpahereRequest(player, target);
        return true;
    }

    private void sendTpahereRequest(Player sender, Player target) {
        UUID senderUUID = sender.getUniqueId();
        UUID targetUUID = target.getUniqueId();
        this.tpahereRequests.put(targetUUID, senderUUID);
        target.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpahere_request_received").replace("{sender}", sender.getName())));
        sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpahere_request_sent").replace("{target}", target.getName())));
    }

    public UUID getTpahereRequest(UUID targetUUID) {
        return this.tpahereRequests.get(targetUUID);
    }

    public UUID removeTpahereRequest(UUID targetUUID) {
        return this.tpahereRequests.remove(targetUUID);
    }
}

