/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.Main;
import fand.fandtpa.commands.TpaCommand;
import fand.fandtpa.commands.TpahereCommand;
import fand.fandtpa.util.ChatColor;
import fand.fandtpa.util.ConfigManager;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class TpacceptCommand
implements CommandExecutor {
    private final TpaCommand tpaCommand;
    private final TpahereCommand tpahereCommand;
    private final ConfigManager configManager;

    public TpacceptCommand(Main plugin, ConfigManager configManager) {
        this.tpaCommand = (TpaCommand)Objects.requireNonNull(plugin.getCommand("tpa")).getExecutor();
        this.tpahereCommand = (TpahereCommand)Objects.requireNonNull(plugin.getCommand("tpahere")).getExecutor();
        this.configManager = configManager;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpaccept_only_player")));
            return true;
        }
        Player player = (Player)sender;
        UUID requesterUUID = this.tpaCommand.getTpaRequest(player.getUniqueId());
        if (requesterUUID == null) {
            requesterUUID = this.tpahereCommand.getTpahereRequest(player.getUniqueId());
        }
        if (requesterUUID != null) {
            Player requester = Bukkit.getPlayer((UUID)requesterUUID);
            if (requester != null && requester.isOnline()) {
                player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpaccept_request_accepted")));
                requester.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpaccept_request_accepted_by_target")));
                if (this.tpaCommand.getTpaRequest(player.getUniqueId()) != null) {
                    requester.teleport((Entity)player);
                } else {
                    player.teleport((Entity)requester);
                }
                this.tpaCommand.removeTpaRequest(player.getUniqueId());
                this.tpahereCommand.removeTpahereRequest(player.getUniqueId());
            } else {
                player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpaccept_player_not_found")));
            }
        } else {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpaccept_no_request")));
        }
        return true;
    }
}

