/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.util;

import fand.fandtpa.Main;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final Main plugin;
    private final Logger logger;
    private final Map<String, String> messages = new HashMap<String, String>();
    private String language;

    public void reloadMessages() {
        this.messages.clear();
        this.loadMessages();
        this.logger.info("Messages have been reloaded.");
    }

    public ConfigManager(Main plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.loadConfig();
        this.loadMessages();
    }

    private void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.language = this.plugin.getConfig().getString("language", "zh_CN");
    }

    private void loadMessages() {
        File langFile;
        File langFolder = new File(this.plugin.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        if (!(langFile = new File(langFolder, this.language + ".yml")).exists()) {
            this.logger.warning("Language file not found for " + this.language + ", using default.");
            langFile = new File(langFolder, "zh_CN.yml");
        }
        YamlConfiguration langConfig = YamlConfiguration.loadConfiguration((File)langFile);
        for (String key : langConfig.getKeys(false)) {
            this.messages.put(key, langConfig.getString(key));
        }
    }

    public String getMessage(String key) {
        return this.messages.getOrDefault(key, "\u00a7c[Missing language key: " + key + "]");
    }
}

