/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.Main;
import fand.fandtpa.util.ChatColor;
import fand.fandtpa.util.ConfigManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetTitleCommand
implements CommandExecutor {
    private final Main plugin;
    private final ConfigManager configManager;

    public SetTitleCommand(Main plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("titles.set")) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("settitle_no_permission")));
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("settitle_usage")));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("settitle_player_not_found")));
            return true;
        }
        StringBuilder titleBuilder = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            titleBuilder.append(args[i]).append(" ");
        }
        String title = titleBuilder.toString().trim();
        this.plugin.getTitlesConfig().set(target.getUniqueId().toString(), (Object)title);
        this.plugin.saveTitlesConfig();
        sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("settitle_success").replace("{title}", title).replace("{player}", target.getName())));
        target.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("settitle_received").replace("{title}", title)));
        target.displayName((Component)Component.text((String)ChatColor.translateAlternateColorCodes('&', title + " " + target.getName())));
        return true;
    }
}

