/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.util.ChatColor;
import fand.fandtpa.util.ConfigManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class InvseeCommand
implements CommandExecutor {
    private final ConfigManager configManager;

    public InvseeCommand(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("invsee_only_player")));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("invsee_usage")));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target != null && target.isOnline()) {
            this.openCustomInventoryView(player, target);
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("invsee_viewing").replace("{target}", target.getName())));
        } else {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("invsee_player_not_found")));
        }
        return true;
    }

    private void openCustomInventoryView(Player viewer, Player target) {
        Inventory customInventory = Bukkit.createInventory(null, (int)54, (String)(target.getName() + this.configManager.getMessage("invsee_inventory_suffix")));
        ItemStack[] inventoryContents = target.getInventory().getContents();
        System.arraycopy(inventoryContents, 0, customInventory.getContents(), 0, Math.min(inventoryContents.length, 36));
        customInventory.setItem(36, target.getInventory().getItemInOffHand());
        ItemStack[] armorContents = target.getInventory().getArmorContents();
        System.arraycopy(armorContents, 0, customInventory.getContents(), 45, armorContents.length);
        viewer.openInventory(customInventory);
    }
}

