/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.Main;
import fand.fandtpa.util.ChatColor;
import fand.fandtpa.util.ConfigManager;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class HomeCommand
implements CommandExecutor {
    private final Main plugin;
    private final ConfigManager configManager;

    public HomeCommand(Main plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("home_only_player")));
            return true;
        }
        Player player = (Player)sender;
        UUID playerUUID = player.getUniqueId();
        if (args.length == 0) {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("home_usage")));
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "set": {
                this.handleSetHome(player, args);
                break;
            }
            case "tp": {
                this.handleTeleportHome(player, args);
                break;
            }
            case "del": {
                this.handleDeleteHome(player, args);
                break;
            }
            case "list": {
                this.handleListHomes(player);
                break;
            }
            default: {
                player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("home_usage")));
            }
        }
        return true;
    }

    private void handleSetHome(Player player, String[] args) {
        if (args.length != 2) {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("home_set_usage")));
            return;
        }
        String homeName = args[1].toLowerCase();
        this.saveHome(player, homeName, player.getLocation());
        player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("home_set_success").replace("{home}", homeName)));
    }

    private void handleTeleportHome(Player player, String[] args) {
        if (args.length != 2) {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("home_tp_usage")));
            return;
        }
        String homeName = args[1].toLowerCase();
        Location homeLocation = this.getHome(player, homeName);
        if (homeLocation != null) {
            player.teleport(homeLocation);
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("home_tp_success").replace("{home}", homeName)));
        } else {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("home_not_exist").replace("{home}", homeName)));
        }
    }

    private void handleDeleteHome(Player player, String[] args) {
        if (args.length != 2) {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("home_del_usage")));
            return;
        }
        String homeName = args[1].toLowerCase();
        this.deleteHome(player, homeName);
        player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("home_del_success").replace("{home}", homeName)));
    }

    private void handleListHomes(Player player) {
        String path = "homes." + String.valueOf(player.getUniqueId());
        FileConfiguration homesConfig = this.plugin.getHomesConfig();
        if (homesConfig.contains(path)) {
            Map homes = homesConfig.getConfigurationSection(path).getValues(false);
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("home_list").replace("{homes}", String.join((CharSequence)", ", homes.keySet()))));
        } else {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("home_no_homes")));
        }
    }

    private void saveHome(Player player, String homeName, Location location) {
        String path = "homes." + String.valueOf(player.getUniqueId()) + "." + homeName;
        FileConfiguration homesConfig = this.plugin.getHomesConfig();
        homesConfig.set(path + ".world", (Object)location.getWorld().getName());
        homesConfig.set(path + ".x", (Object)location.getX());
        homesConfig.set(path + ".y", (Object)location.getY());
        homesConfig.set(path + ".z", (Object)location.getZ());
        homesConfig.set(path + ".yaw", (Object)Float.valueOf(location.getYaw()));
        homesConfig.set(path + ".pitch", (Object)Float.valueOf(location.getPitch()));
        this.plugin.saveHomesConfig();
    }

    private Location getHome(Player player, String homeName) {
        String path = "homes." + String.valueOf(player.getUniqueId()) + "." + homeName;
        FileConfiguration homesConfig = this.plugin.getHomesConfig();
        if (homesConfig.contains(path)) {
            String world = homesConfig.getString(path + ".world");
            double x = homesConfig.getDouble(path + ".x");
            double y = homesConfig.getDouble(path + ".y");
            double z = homesConfig.getDouble(path + ".z");
            float yaw = (float)homesConfig.getDouble(path + ".yaw");
            float pitch = (float)homesConfig.getDouble(path + ".pitch");
            return new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
        }
        return null;
    }

    private void deleteHome(Player player, String homeName) {
        String path = "homes." + String.valueOf(player.getUniqueId()) + "." + homeName;
        FileConfiguration homesConfig = this.plugin.getHomesConfig();
        homesConfig.set(path, null);
        this.plugin.saveHomesConfig();
    }
}

