/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.Main;
import fand.fandtpa.util.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class FandTpaCommand
implements CommandExecutor,
TabCompleter {
    private final Main plugin;
    private final ConfigManager configManager;

    public FandTpaCommand(Main plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(this.configManager.getMessage("fandtpa_usage"));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("fandtpa.reload")) {
                    sender.sendMessage(this.configManager.getMessage("no_permission"));
                    return true;
                }
                this.plugin.reloadConfig();
                this.configManager.reloadMessages();
                sender.sendMessage(this.configManager.getMessage("fandtpa_reload_success"));
                break;
            }
            case "help": {
                sender.sendMessage(this.configManager.getMessage("fandtpa_help"));
                break;
            }
            default: {
                sender.sendMessage(this.configManager.getMessage("unknown_subcommand").replace("{command}", args[0]));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if ("reload".startsWith(args[0].toLowerCase())) {
                completions.add("reload");
            }
            if ("help".startsWith(args[0].toLowerCase())) {
                completions.add("help");
            }
        }
        return completions;
    }
}

