/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa;

import fand.fandtpa.commands.BackCommand;
import fand.fandtpa.commands.EcoCommand;
import fand.fandtpa.commands.EcoTabCompleter;
import fand.fandtpa.commands.FandTpaCommand;
import fand.fandtpa.commands.FlyCommand;
import fand.fandtpa.commands.GmCommand;
import fand.fandtpa.commands.GmTabCompleter;
import fand.fandtpa.commands.HatCommand;
import fand.fandtpa.commands.HomeCommand;
import fand.fandtpa.commands.HomeTabCompleter;
import fand.fandtpa.commands.InvseeCommand;
import fand.fandtpa.commands.MoneyCommand;
import fand.fandtpa.commands.OtpCommand;
import fand.fandtpa.commands.SetTitleCommand;
import fand.fandtpa.commands.SpeedCommand;
import fand.fandtpa.commands.SuicideCommand;
import fand.fandtpa.commands.TabReloadCommand;
import fand.fandtpa.commands.TpaCommand;
import fand.fandtpa.commands.TpacceptCommand;
import fand.fandtpa.commands.TpahereCommand;
import fand.fandtpa.commands.TpdenyCommand;
import fand.fandtpa.commands.TprandomCommand;
import fand.fandtpa.economy.EcoManager;
import fand.fandtpa.listeners.OtpManager;
import fand.fandtpa.listeners.PlayerChatListener;
import fand.fandtpa.listeners.PlayerQuitListener;
import fand.fandtpa.tab.TabListUpdater;
import fand.fandtpa.util.ConfigManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public FileConfiguration tabConfig;
    private FileConfiguration languageConfig;
    private String language;
    private File homesFile;
    private FileConfiguration homesConfig;
    private File titlesFile;
    private FileConfiguration titlesConfig;
    private final HashMap<UUID, Location> deathLocations = new HashMap();
    private ConfigManager configManager;
    private boolean tabFunctionEnabled = true;
    private boolean papiEnabled = false;
    private Object economy = null;
    private EcoManager ecoManager;
    private OtpManager otpManager;

    public void onEnable() {
        this.otpManager = new OtpManager();
        this.checkForTabPlugin();
        this.configManager = new ConfigManager(this);
        try {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                this.papiEnabled = true;
                this.getLogger().info("\u68c0\u6d4b\u5230PlaceholderAPI\uff0c\u5df2\u542f\u7528PlaceholderAPI\u652f\u6301\u3002");
            } else {
                this.getLogger().info("\u672a\u627e\u5230PlaceholderAPI\uff0c\u5c06\u5728\u6ca1\u6709PlaceholderAPI\u652f\u6301\u7684\u60c5\u51b5\u4e0b\u8fd0\u884c\u3002");
            }
            if (this.setupEconomy()) {
                this.getLogger().info("\u68c0\u6d4b\u5230 Vault \u63d2\u4ef6\uff0c\u5df2\u542f\u7528\u7ecf\u6d4e\u652f\u6301\u3002");
            } else {
                this.getLogger().warning("\u672a\u68c0\u6d4b\u5230 Vault \u63d2\u4ef6\uff0c\u7ecf\u6d4e\u529f\u80fd\u5c06\u65e0\u6cd5\u4f7f\u7528\u3002");
            }
            if (this.tabFunctionEnabled) {
                int time = 20;
                new TabListUpdater(this).runTaskTimer((Plugin)this, 0L, time);
            }
            String dbPath = this.getDataFolder().getAbsolutePath() + "/economy.db";
            this.ecoManager = new EcoManager(dbPath);
            this.loadTabConfig();
            this.createDataFolders();
            this.language = this.getConfig().getString("language", "zh_CN");
            this.getLogger().info("\u5f53\u524d\u8bed\u8a00\u8bbe\u7f6e: " + this.language);
            this.loadLanguageFiles();
            this.configManager.reloadMessages();
            this.loadConfigurationFiles();
            this.registerCommands();
            this.registerListeners();
            this.logToConsole(this.configManager.getMessage("plugin_success"));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, this.configManager.getMessage("error_message").replace("{error}", e.getMessage()), e);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.otpManager.saveLogoutLocation(event.getPlayer());
    }

    public void reloadConfigAndMessages() {
        this.reloadConfig();
        this.configManager.reloadMessages();
        this.loadTabConfig();
        this.loadConfigurationFiles();
        this.logToConsole(this.configManager.getMessage("plugin_success"));
    }

    public EcoManager getEcoManager() {
        return this.ecoManager;
    }

    private boolean setupEconomy() {
        try {
            if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
                return false;
            }
            Class<?> rspClass = Class.forName("org.bukkit.plugin.RegisteredServiceProvider");
            Method getServicesManagerMethod = this.getServer().getClass().getMethod("getServicesManager", new Class[0]);
            Object servicesManager = getServicesManagerMethod.invoke((Object)this.getServer(), new Object[0]);
            Method getRegistrationMethod = servicesManager.getClass().getMethod("getRegistration", Class.class);
            Object rsp = getRegistrationMethod.invoke(servicesManager, Class.forName("net.milkbowl.vault.economy.Economy"));
            if (rsp != null) {
                Method getProviderMethod = rspClass.getMethod("getProvider", new Class[0]);
                this.economy = getProviderMethod.invoke(rsp, new Object[0]);
                return this.economy != null;
            }
            return false;
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Vault \u672a\u627e\u5230\uff0c\u7ecf\u6d4e\u529f\u80fd\u7981\u7528: " + e.getMessage());
            return false;
        }
    }

    public Object getEconomy() {
        return this.economy;
    }

    public String replacePlaceholders(Player player, String text) {
        if (this.papiEnabled) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }

    private void checkForTabPlugin() {
        Plugin tabPlugin = Bukkit.getPluginManager().getPlugin("TAB");
        if (tabPlugin != null && tabPlugin.isEnabled()) {
            this.tabFunctionEnabled = false;
        }
    }

    public void onDisable() {
        this.logToConsole(this.configManager.getMessage("plugin_disabled"));
        this.saveConfigurationFiles();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    private void loadLanguageFiles() {
        File languageFile;
        String[] supportedLanguages;
        File langFolder = new File(this.getDataFolder(), "lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        for (String langFileName : supportedLanguages = new String[]{"zh_CN.yml", "en_us.yml"}) {
            File langFile = new File(langFolder, langFileName);
            if (langFile.exists()) continue;
            this.saveResource("lang/" + langFileName, false);
            this.getLogger().info("\u91ca\u653e\u8bed\u8a00\u6587\u4ef6: " + langFileName);
        }
        if (this.language == null) {
            this.getLogger().severe("\u8bed\u8a00\u672a\u8bbe\u7f6e\uff0c\u52a0\u8f7d\u9ed8\u8ba4\u8bed\u8a00\u6587\u4ef6: zh_CN.yml");
            this.language = "zh_CN";
        }
        if ((languageFile = new File(langFolder, this.language + ".yml")).exists()) {
            this.languageConfig = YamlConfiguration.loadConfiguration((File)languageFile);
            this.getLogger().info("\u52a0\u8f7d\u8bed\u8a00\u6587\u4ef6: " + languageFile.getAbsolutePath());
        } else {
            this.getLogger().severe("\u8bed\u8a00\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25: " + languageFile.getAbsolutePath());
        }
    }

    public void loadTabConfig() {
        File tabFile = new File(this.getDataFolder(), "tab.yml");
        if (!tabFile.exists()) {
            this.saveResource("tab.yml", false);
        }
        this.tabConfig = YamlConfiguration.loadConfiguration((File)tabFile);
    }

    private void createDataFolders() {
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdirs()) {
            this.getLogger().severe("\u63d2\u4ef6\u4e3b\u6570\u636e\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25: " + this.getDataFolder().getPath());
            return;
        }
        this.homesFile = this.createFile("homes.yml");
        this.titlesFile = this.createFile("titles.yml");
    }

    private File createFile(String fileName) {
        File file = new File(this.getDataFolder(), fileName);
        if (!file.exists()) {
            try {
                if (file.createNewFile()) {
                    this.getLogger().info(fileName + " \u6587\u4ef6\u521b\u5efa\u6210\u529f: " + file.getPath());
                } else {
                    this.getLogger().severe(fileName + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25: " + file.getPath());
                }
            }
            catch (IOException e) {
                this.getLogger().log(Level.SEVERE, "\u521b\u5efa " + fileName + " \u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage(), e);
            }
        }
        return file;
    }

    private void loadConfigurationFiles() {
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
        this.titlesConfig = YamlConfiguration.loadConfiguration((File)this.titlesFile);
    }

    private void saveConfigurationFiles() {
        this.saveConfigFile(this.homesConfig, this.homesFile);
        this.saveConfigFile(this.titlesConfig, this.titlesFile);
    }

    private void saveConfigFile(FileConfiguration config, File file) {
        try {
            if (config != null && file != null) {
                config.save(file);
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, this.configManager.getMessage("error_message").replace("{error}", e.getMessage()), e);
        }
    }

    public FileConfiguration getHomesConfig() {
        return this.homesConfig;
    }

    public void saveHomesConfig() {
        this.saveConfigFile(this.homesConfig, this.homesFile);
    }

    public FileConfiguration getTitlesConfig() {
        return this.titlesConfig;
    }

    public void saveTitlesConfig() {
        this.saveConfigFile(this.titlesConfig, this.titlesFile);
    }

    private void registerCommands() {
        EcoCommand ecoCommand = new EcoCommand(this, this.configManager);
        Objects.requireNonNull(this.getCommand("tpa")).setExecutor((CommandExecutor)new TpaCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("tpahere")).setExecutor((CommandExecutor)new TpahereCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("tpaccept")).setExecutor((CommandExecutor)new TpacceptCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("tpdeny")).setExecutor((CommandExecutor)new TpdenyCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("home")).setExecutor((CommandExecutor)new HomeCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("home")).setTabCompleter((TabCompleter)new HomeTabCompleter(this));
        Objects.requireNonNull(this.getCommand("back")).setExecutor((CommandExecutor)new BackCommand(this.getLogger(), this.configManager));
        Objects.requireNonNull(this.getCommand("settitle")).setExecutor((CommandExecutor)new SetTitleCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("suicide")).setExecutor((CommandExecutor)new SuicideCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("rtp")).setExecutor((CommandExecutor)new TprandomCommand(this));
        Objects.requireNonNull(this.getCommand("invsee")).setExecutor((CommandExecutor)new InvseeCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("hat")).setExecutor((CommandExecutor)new HatCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("fly")).setExecutor((CommandExecutor)new FlyCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("gm")).setExecutor((CommandExecutor)new GmCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("gm")).setTabCompleter((TabCompleter)new GmTabCompleter());
        Objects.requireNonNull(this.getCommand("tab")).setExecutor((CommandExecutor)new TabReloadCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("eco")).setExecutor((CommandExecutor)new EcoCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("eco")).setTabCompleter((TabCompleter)new EcoTabCompleter());
        Objects.requireNonNull(this.getCommand("speed")).setExecutor((CommandExecutor)new SpeedCommand(this.configManager));
        Objects.requireNonNull(this.getCommand("money")).setExecutor((CommandExecutor)new MoneyCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("otp")).setExecutor((CommandExecutor)new OtpCommand(this.otpManager, this.configManager));
        Objects.requireNonNull(this.getCommand("fandtpa")).setExecutor((CommandExecutor)new FandTpaCommand(this, this.configManager));
        Objects.requireNonNull(this.getCommand("fandtpa")).setTabCompleter((TabCompleter)new FandTpaCommand(this, this.configManager));
    }

    private void registerListeners() {
        BackCommand backCommand = new BackCommand(this.getLogger(), new ConfigManager(this));
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)backCommand, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerQuitListener(this.otpManager), (Plugin)this);
    }

    private void logToConsole(String message) {
        this.getServer().getConsoleSender().sendMessage(message);
    }
}

