/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.Main;
import fand.fandtpa.util.ChatColor;
import fand.fandtpa.util.ConfigManager;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TpaCommand
implements CommandExecutor {
    private final Main plugin;
    private final HashMap<UUID, UUID> tpaRequests;
    private final ConfigManager configManager;

    public TpaCommand(Main plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.tpaRequests = new HashMap();
        this.configManager = configManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpa_only_player")));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpa_usage")));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpa_player_not_found")));
            return true;
        }
        if (player.equals((Object)target)) {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpa_self_request")));
            return true;
        }
        this.sendTpaRequest(player, target);
        return true;
    }

    private void sendTpaRequest(Player sender, Player target) {
        UUID senderUUID = sender.getUniqueId();
        UUID targetUUID = target.getUniqueId();
        this.tpaRequests.put(targetUUID, senderUUID);
        target.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpa_request_received").replace("{sender}", sender.getName())));
        sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("tpa_request_sent").replace("{target}", target.getName())));
    }

    public UUID getTpaRequest(UUID targetUUID) {
        return this.tpaRequests.get(targetUUID);
    }

    public UUID removeTpaRequest(UUID targetUUID) {
        return this.tpaRequests.remove(targetUUID);
    }
}

