/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.util;

import fand.fandtpa.Main;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class ConfigManager {
    private final Main plugin;
    private final Logger logger;
    private final Map<String, String> messages = new HashMap<String, String>();
    private String language;

    public ConfigManager(Main plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.loadConfig();
        this.loadMessages();
    }

    private void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.language = this.plugin.getConfig().getString("language", "zh_CN");
    }

    private void loadMessages() {
        if (this.language.equalsIgnoreCase("en_us")) {
            this.loadEnglishMessages();
        } else {
            this.loadChineseMessages();
        }
    }

    private void loadEnglishMessages() {
        this.messages.put("plugin_enabled", "Plugin enabled successfully!");
        this.messages.put("plugin_disabled", "Plugin has been disabled!");
        this.messages.put("error_message", "An error occurred: {error}");
        this.messages.put("plugin_success", "Plugin started successfully!");
        this.messages.put("command_only_player", "&cThis command can only be used by players!");
        this.messages.put("teleport_success", "&aYou have been teleported to your last death location.");
        this.messages.put("no_death_location", "&cNo death location found.");
        this.messages.put("log_teleport_success", "{player} has been teleported to their death location: {location}");
        this.messages.put("log_death_location_recorded", "Recorded death location for {player}: {location}");
        this.messages.put("no_permission", "&cYou do not have permission to use this command!");
        this.messages.put("fly_toggle", "&aFly mode is now {status}!");
        this.messages.put("fly_enabled", "enabled");
        this.messages.put("fly_disabled", "disabled");
        this.messages.put("gm_specify_mode", "Please specify a game mode: 0, 1, 2, 3, survival, creative, adventure, spectator");
        this.messages.put("gm_invalid_mode", "Invalid game mode!");
        this.messages.put("gm_console_no_self_target", "Console cannot target itself; please specify a player!");
        this.messages.put("gm_mode_changed", "Game mode changed to: {mode}");
        this.messages.put("gm_target_mode_changed", "{target}'s game mode changed to: {mode}");
        this.messages.put("gm_survival", "Survival Mode");
        this.messages.put("gm_creative", "Creative Mode");
        this.messages.put("gm_adventure", "Adventure Mode");
        this.messages.put("gm_spectator", "Spectator Mode");
        this.messages.put("hat_only_player", "&cOnly players can use this command!");
        this.messages.put("hat_no_item_in_hand", "&cYou don't have any item in your hand!");
        this.messages.put("hat_success", "&aYou are now wearing the item in your hand!");
        this.messages.put("home_only_player", "&cOnly players can use this command!");
        this.messages.put("home_usage", "&eUsage: /home <set/tp/del/list>");
        this.messages.put("home_set_usage", "&eUsage: /home set <home_name>");
        this.messages.put("home_tp_usage", "&eUsage: /home tp <home_name>");
        this.messages.put("home_del_usage", "&eUsage: /home del <home_name>");
        this.messages.put("home_set_success", "&aHome &b{home} &ahas been set!");
        this.messages.put("home_tp_success", "&aTeleported to home &b{home}!");
        this.messages.put("home_del_success", "&aHome &b{home} &ahas been deleted!");
        this.messages.put("home_not_exist", "&cHome &b{home} &cdoes not exist!");
        this.messages.put("home_list", "&aYour homes: &b{homes}");
        this.messages.put("home_no_homes", "&cYou have not set any homes.");
        this.messages.put("invsee_only_player", "&cOnly players can use this command!");
        this.messages.put("invsee_usage", "&eUsage: /invsee <player>");
        this.messages.put("invsee_viewing", "&aViewing inventory of &b{target}&a.");
        this.messages.put("invsee_player_not_found", "&cPlayer not found or not online!");
        this.messages.put("invsee_inventory_suffix", "'s Inventory");
        this.messages.put("settitle_no_permission", "&cYou do not have permission to use this command!");
        this.messages.put("settitle_usage", "&eUsage: /settitle <player> <title>");
        this.messages.put("settitle_player_not_found", "&cPlayer not found or not online!");
        this.messages.put("settitle_success", "&aTitle {title} has been added to {player}.");
        this.messages.put("settitle_received", "&aYou have received the title: {title}");
        this.messages.put("suicide_success", "&cYou have committed suicide!");
        this.messages.put("suicide_only_player", "&cOnly players can use this command!");
        this.messages.put("tab_reload_success", "&aTab configuration reloaded successfully.");
        this.messages.put("tab_reload_usage", "&cUsage: /tab reload");
        this.messages.put("tpaccept_only_player", "&cThis command can only be used by players!");
        this.messages.put("tpaccept_request_accepted", "&aTeleport request accepted.");
        this.messages.put("tpaccept_request_accepted_by_target", "&aYour teleport request has been accepted.");
        this.messages.put("tpaccept_player_not_found", "&cThe player who made the request is not online or does not exist.");
        this.messages.put("tpaccept_no_request", "&cYou have no pending teleport requests.");
        this.messages.put("tpa_only_player", "&cThis command can only be used by players!");
        this.messages.put("tpa_usage", "&cUsage: /tpa <player>");
        this.messages.put("tpa_player_not_found", "&cThe player is not online or does not exist.");
        this.messages.put("tpa_self_request", "&cYou cannot send a teleport request to yourself!");
        this.messages.put("tpa_request_received", "&a{sender} has requested to teleport to you. Use /tpaccept to accept, or /tpdeny to deny.");
        this.messages.put("tpa_request_sent", "&aRequest sent to {target}.");
        this.messages.put("tpahere_only_player", "&cThis command can only be used by players!");
        this.messages.put("tpahere_usage", "&cUsage: /tpahere <player>");
        this.messages.put("tpahere_player_not_found", "&cThe player is not online or does not exist.");
        this.messages.put("tpahere_self_request", "&cYou cannot request a player to teleport to yourself!");
        this.messages.put("tpahere_request_received", "&a{sender} has requested you to teleport to them. Use /tpaccept to accept, or /tpdeny to deny.");
        this.messages.put("tpahere_request_sent", "&aRequest sent to {target}.");
        this.messages.put("tpdeny_only_player", "&cThis command can only be used by players!");
        this.messages.put("tpdeny_request_denied", "&aTeleport request denied.");
        this.messages.put("tpdeny_requester_notified", "&cYour teleport request was denied by {player}.");
        this.messages.put("tpdeny_player_not_found", "&cThe player who sent the request is not online or does not exist.");
        this.messages.put("tpdeny_no_request", "&cYou do not have any pending teleport requests.");
    }

    private void loadChineseMessages() {
        this.messages.put("plugin_enabled", "\u63d2\u4ef6\u542f\u7528\u6210\u529f\uff01");
        this.messages.put("plugin_disabled", "\u63d2\u4ef6\u5df2\u7981\u7528");
        this.messages.put("error_message", "\u53d1\u751f\u9519\u8bef: {error}");
        this.messages.put("plugin_success", "\u63d2\u4ef6\u542f\u52a8\u6210\u529f\uff01");
        this.messages.put("command_only_player", "&c\u8be5\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\uff01");
        this.messages.put("teleport_success", "&a\u4f60\u5df2\u4f20\u9001\u5230\u4e0a\u4e00\u6b21\u6b7b\u4ea1\u5730\u70b9");
        this.messages.put("no_death_location", "&c\u6ca1\u6709\u627e\u5230\u6b7b\u4ea1\u5730\u70b9");
        this.messages.put("log_teleport_success", "{player} \u5df2\u4f20\u9001\u5230\u6b7b\u4ea1\u5730\u70b9: {location}");
        this.messages.put("log_death_location_recorded", "\u8bb0\u5f55 {player} \u7684\u6b7b\u4ea1\u5730\u70b9: {location}");
        this.messages.put("no_permission", "&c\u4f60\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u8fd9\u4e2a\u547d\u4ee4\uff01");
        this.messages.put("fly_toggle", "&a\u98de\u884c\u6a21\u5f0f\u5df2{status}\uff01");
        this.messages.put("fly_enabled", "\u5f00\u542f");
        this.messages.put("fly_disabled", "\u5173\u95ed");
        this.messages.put("gm_specify_mode", "\u8bf7\u6307\u5b9a\u6e38\u620f\u6a21\u5f0f\uff1a0, 1, 2, 3, survival, creative, adventure, spectator");
        this.messages.put("gm_invalid_mode", "\u65e0\u6548\u7684\u6e38\u620f\u6a21\u5f0f\uff01");
        this.messages.put("gm_console_no_self_target", "\u63a7\u5236\u53f0\u4e0d\u80fd\u6307\u5b9a\u81ea\u5df1\u4e3a\u76ee\u6807\uff0c\u8bf7\u6307\u5b9a\u4e00\u4e2a\u73a9\u5bb6\uff01");
        this.messages.put("gm_mode_changed", "\u6e38\u620f\u6a21\u5f0f\u5df2\u66f4\u6539\u4e3a: {mode}");
        this.messages.put("gm_target_mode_changed", "{target} \u7684\u6e38\u620f\u6a21\u5f0f\u5df2\u66f4\u6539\u4e3a: {mode}");
        this.messages.put("gm_survival", "\u751f\u5b58\u6a21\u5f0f");
        this.messages.put("gm_creative", "\u521b\u9020\u6a21\u5f0f");
        this.messages.put("gm_adventure", "\u5192\u9669\u6a21\u5f0f");
        this.messages.put("gm_spectator", "\u65c1\u89c2\u8005\u6a21\u5f0f");
        this.messages.put("hat_only_player", "&c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4\uff01");
        this.messages.put("hat_no_item_in_hand", "&c\u4f60\u624b\u4e2d\u6ca1\u6709\u7269\u54c1\uff01");
        this.messages.put("hat_success", "&a\u4f60\u5df2\u7ecf\u6234\u4e0a\u4e86\u624b\u4e2d\u7684\u7269\u54c1\uff01");
        this.messages.put("home_only_player", "&c\u8be5\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\uff01");
        this.messages.put("home_usage", "&e\u4f7f\u7528\u65b9\u6cd5: /home <set/tp/del/list>");
        this.messages.put("home_set_usage", "&e\u4f7f\u7528\u65b9\u6cd5: /home set <\u5bb6\u540d>");
        this.messages.put("home_tp_usage", "&e\u4f7f\u7528\u65b9\u6cd5: /home tp <\u5bb6\u540d>");
        this.messages.put("home_del_usage", "&e\u4f7f\u7528\u65b9\u6cd5: /home del <\u5bb6\u540d>");
        this.messages.put("home_set_success", "&a\u5bb6 &b{home} &a\u5df2\u8bbe\u7f6e");
        this.messages.put("home_tp_success", "&a\u5df2\u4f20\u9001\u5230\u5bb6 &b{home}!");
        this.messages.put("home_del_success", "&a\u5bb6 &b{home} &a\u5df2\u5220\u9664");
        this.messages.put("home_not_exist", "&c\u5bb6 &b{home} &c\u4e0d\u5b58\u5728\uff01");
        this.messages.put("home_list", "&a\u4f60\u7684\u5bb6: &b{homes}");
        this.messages.put("home_no_homes", "&c\u4f60\u6ca1\u6709\u8bbe\u7f6e\u4efb\u4f55\u5bb6\u3002");
        this.messages.put("invsee_only_player", "&c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u6b64\u547d\u4ee4\uff01");
        this.messages.put("invsee_usage", "&e\u7528\u6cd5: /invsee <\u73a9\u5bb6\u540d>");
        this.messages.put("invsee_viewing", "&a\u6b63\u5728\u67e5\u770b &b{target}&a \u7684\u80cc\u5305\u3002");
        this.messages.put("invsee_player_not_found", "&c\u73a9\u5bb6\u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728\uff01");
        this.messages.put("invsee_inventory_suffix", " \u7684\u80cc\u5305");
        this.messages.put("settitle_no_permission", "&c\u4f60\u6ca1\u6709\u6743\u9650\u4f7f\u7528\u6b64\u547d\u4ee4\uff01");
        this.messages.put("settitle_usage", "&e\u4f7f\u7528\u65b9\u6cd5: /settitle <\u73a9\u5bb6> <\u79f0\u53f7>");
        this.messages.put("settitle_player_not_found", "&c\u73a9\u5bb6\u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728\uff01");
        this.messages.put("settitle_success", "&a\u79f0\u53f7 {title} \u5df2\u6dfb\u52a0\u7ed9 {player}.");
        this.messages.put("settitle_received", "&a\u4f60\u5df2\u83b7\u5f97\u79f0\u53f7: {title}");
        this.messages.put("suicide_success", "&c\u4f60\u5df2\u7ecf\u81ea\u6740\u4e86\uff01");
        this.messages.put("suicide_only_player", "&c\u53ea\u6709\u73a9\u5bb6\u53ef\u4ee5\u4f7f\u7528\u8fd9\u4e2a\u547d\u4ee4\uff01");
        this.messages.put("tab_reload_success", "&aTab \u914d\u7f6e\u6587\u4ef6\u91cd\u65b0\u52a0\u8f7d\u6210\u529f\u3002");
        this.messages.put("tab_reload_usage", "&c\u7528\u6cd5: /tab reload");
        this.messages.put("tpaccept_only_player", "&c\u8be5\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\uff01");
        this.messages.put("tpaccept_request_accepted", "&a\u4f20\u9001\u8bf7\u6c42\u5df2\u63a5\u53d7\u3002");
        this.messages.put("tpaccept_request_accepted_by_target", "&a\u4f60\u7684\u4f20\u9001\u8bf7\u6c42\u5df2\u88ab\u63a5\u53d7\u3002");
        this.messages.put("tpaccept_player_not_found", "&c\u8bf7\u6c42\u7684\u73a9\u5bb6\u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728\u3002");
        this.messages.put("tpaccept_no_request", "&c\u4f60\u6ca1\u6709\u4efb\u4f55\u4f20\u9001\u8bf7\u6c42\u3002");
        this.messages.put("tpa_only_player", "&c\u8be5\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\uff01");
        this.messages.put("tpa_usage", "&c\u4f7f\u7528\u65b9\u6cd5: /tpa <\u73a9\u5bb6\u540d>");
        this.messages.put("tpa_player_not_found", "&c\u73a9\u5bb6\u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728\u3002");
        this.messages.put("tpa_self_request", "&c\u4f60\u4e0d\u80fd\u8bf7\u6c42\u4f20\u9001\u5230\u81ea\u5df1\uff01");
        this.messages.put("tpa_request_received", "&a{sender} \u8bf7\u6c42\u4f20\u9001\u5230\u4f60\u8fd9\u91cc\u3002\u4f7f\u7528 /tpaccept \u63a5\u53d7\uff0c/tpdeny \u62d2\u7edd\u3002");
        this.messages.put("tpa_request_sent", "&a\u8bf7\u6c42\u5df2\u53d1\u9001\u7ed9 {target}\u3002");
        this.messages.put("tpahere_only_player", "&c\u8be5\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\uff01");
        this.messages.put("tpahere_usage", "&c\u4f7f\u7528\u65b9\u6cd5: /tpahere <\u73a9\u5bb6\u540d>");
        this.messages.put("tpahere_player_not_found", "&c\u73a9\u5bb6\u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728\u3002");
        this.messages.put("tpahere_self_request", "&c\u4f60\u4e0d\u80fd\u8bf7\u6c42\u73a9\u5bb6\u4f20\u9001\u5230\u4f60\u81ea\u5df1\uff01");
        this.messages.put("tpahere_request_received", "&a{sender} \u8bf7\u6c42\u4f60\u4f20\u9001\u5230\u4ed6\u90a3\u91cc\u3002\u4f7f\u7528 /tpaccept \u63a5\u53d7\uff0c/tpdeny \u62d2\u7edd\u3002");
        this.messages.put("tpahere_request_sent", "&a\u8bf7\u6c42\u5df2\u53d1\u9001\u7ed9 {target}\u3002");
        this.messages.put("tpdeny_only_player", "&c\u8be5\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\uff01");
        this.messages.put("tpdeny_request_denied", "&a\u4f20\u9001\u8bf7\u6c42\u5df2\u62d2\u7edd\u3002");
        this.messages.put("tpdeny_requester_notified", "&c\u4f60\u7684\u4f20\u9001\u8bf7\u6c42\u88ab {player} \u62d2\u7edd\u3002");
        this.messages.put("tpdeny_player_not_found", "&c\u8bf7\u6c42\u7684\u73a9\u5bb6\u4e0d\u5728\u7ebf\u6216\u4e0d\u5b58\u5728\u3002");
        this.messages.put("tpdeny_no_request", "&c\u4f60\u6ca1\u6709\u4efb\u4f55\u4f20\u9001\u8bf7\u6c42\u3002");
    }

    public String getMessage(String key) {
        return this.messages.getOrDefault(key, "\u00a7c[Missing language key: " + key + "]");
    }
}

