/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.util.ChatColor;
import fand.fandtpa.util.ConfigManager;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class GmCommand
implements CommandExecutor {
    private final ConfigManager configManager;

    public GmCommand(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 1) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("gm_specify_mode")));
            return true;
        }
        String mode = args[0].toLowerCase();
        GameMode gameMode = null;
        String modeName = "";
        switch (mode) {
            case "0": 
            case "survival": {
                gameMode = GameMode.SURVIVAL;
                modeName = this.configManager.getMessage("gm_survival");
                break;
            }
            case "1": 
            case "creative": {
                gameMode = GameMode.CREATIVE;
                modeName = this.configManager.getMessage("gm_creative");
                break;
            }
            case "2": 
            case "adventure": {
                gameMode = GameMode.ADVENTURE;
                modeName = this.configManager.getMessage("gm_adventure");
                break;
            }
            case "3": 
            case "spectator": {
                gameMode = GameMode.SPECTATOR;
                modeName = this.configManager.getMessage("gm_spectator");
                break;
            }
            default: {
                sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("gm_invalid_mode")));
                return true;
            }
        }
        ArrayList<Player> targets = new ArrayList<Player>();
        if (args.length > 1) {
            for (Entity entity : Bukkit.selectEntities((CommandSender)sender, (String)args[1])) {
                if (!(entity instanceof Player)) continue;
                targets.add((Player)entity);
            }
        } else if (sender instanceof Player) {
            targets.add((Player)sender);
        } else {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("gm_console_no_self_target")));
            return true;
        }
        for (Player target : targets) {
            target.setGameMode(gameMode);
            target.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("gm_mode_changed").replace("{mode}", String.valueOf((Object)ChatColor.GOLD) + modeName + String.valueOf((Object)ChatColor.RESET))));
            if (target.equals((Object)sender)) continue;
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', this.configManager.getMessage("gm_target_mode_changed").replace("{target}", String.valueOf((Object)ChatColor.YELLOW) + target.getName() + String.valueOf((Object)ChatColor.RESET)).replace("{mode}", String.valueOf((Object)ChatColor.GOLD) + modeName + String.valueOf((Object)ChatColor.RESET))));
        }
        return true;
    }
}

