/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.tab;

import fand.fandtpa.Main;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class TabListUpdater
extends BukkitRunnable {
    private final Main plugin;

    public TabListUpdater(Main plugin) {
        this.plugin = plugin;
    }

    public void run() {
        if (!this.plugin.tabConfig.getBoolean("enabled", true)) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.updateTabList(player);
        }
    }

    private void updateTabList(Player player) {
        String header = this.plugin.tabConfig.getString("header", "");
        String footer = this.plugin.tabConfig.getString("footer", "");
        header = this.replacePlaceholders(player, header);
        footer = this.replacePlaceholders(player, footer);
        player.setPlayerListHeaderFooter(header, footer);
    }

    private String replacePlaceholders(Player player, String text) {
        return text.replace("&", "\u00a7").replace("%player%", player.getName()).replace("%online%", String.valueOf(Bukkit.getOnlinePlayers().size())).replace("%maxplayers%", String.valueOf(Bukkit.getMaxPlayers())).replace("%world%", player.getWorld().getName()).replace("%x%", String.valueOf(player.getLocation().getBlockX())).replace("%y%", String.valueOf(player.getLocation().getBlockY())).replace("%z%", String.valueOf(player.getLocation().getBlockZ()));
    }
}

