/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.Main;
import fand.fandtpa.util.ChatColor;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class HomeCommand
implements CommandExecutor {
    private final Main plugin;

    public HomeCommand(Main plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "\u8be5\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\uff01");
            return true;
        }
        Player player = (Player)sender;
        UUID playerUUID = player.getUniqueId();
        if (args.length == 0) {
            player.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "\u4f7f\u7528\u65b9\u6cd5: /home <set/tp/del/list>");
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "set": {
                this.handleSetHome(player, args);
                break;
            }
            case "tp": {
                this.handleTeleportHome(player, args);
                break;
            }
            case "del": {
                this.handleDeleteHome(player, args);
                break;
            }
            case "list": {
                this.handleListHomes(player);
                break;
            }
            default: {
                player.sendMessage(String.valueOf((Object)ChatColor.RED) + "\u672a\u77e5\u7684\u5b50\u547d\u4ee4");
            }
        }
        return true;
    }

    private void handleSetHome(Player player, String[] args) {
        if (args.length != 2) {
            player.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "\u4f7f\u7528\u65b9\u6cd5: /home set <\u5bb6\u540d>");
            return;
        }
        String homeName = args[1].toLowerCase();
        this.saveHome(player, homeName, player.getLocation());
        player.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "\u5bb6 " + String.valueOf((Object)ChatColor.AQUA) + homeName + String.valueOf((Object)ChatColor.GREEN) + " \u5df2\u8bbe\u7f6e");
    }

    private void handleTeleportHome(Player player, String[] args) {
        if (args.length != 2) {
            player.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "\u4f7f\u7528\u65b9\u6cd5: /home tp <\u5bb6\u540d>");
            return;
        }
        String homeName = args[1].toLowerCase();
        Location homeLocation = this.getHome(player, homeName);
        if (homeLocation != null) {
            player.teleport(homeLocation);
            player.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "\u5df2\u4f20\u9001\u5230\u5bb6 " + String.valueOf((Object)ChatColor.AQUA) + homeName);
        } else {
            player.sendMessage(String.valueOf((Object)ChatColor.RED) + "\u5bb6 " + String.valueOf((Object)ChatColor.AQUA) + homeName + String.valueOf((Object)ChatColor.RED) + " \u4e0d\u5b58\u5728");
        }
    }

    private void handleDeleteHome(Player player, String[] args) {
        if (args.length != 2) {
            player.sendMessage(String.valueOf((Object)ChatColor.YELLOW) + "\u4f7f\u7528\u65b9\u6cd5: /home del <\u5bb6\u540d>");
            return;
        }
        String homeName = args[1].toLowerCase();
        this.deleteHome(player, homeName);
        player.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "\u5bb6 " + String.valueOf((Object)ChatColor.AQUA) + homeName + String.valueOf((Object)ChatColor.GREEN) + " \u5df2\u5220\u9664");
    }

    private void handleListHomes(Player player) {
        String path = "homes." + String.valueOf(player.getUniqueId());
        FileConfiguration homesConfig = this.plugin.getHomesConfig();
        if (homesConfig.contains(path)) {
            Map homes = homesConfig.getConfigurationSection(path).getValues(false);
            player.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "\u4f60\u7684\u5bb6: " + String.valueOf((Object)ChatColor.AQUA) + String.join((CharSequence)", ", homes.keySet()));
        } else {
            player.sendMessage(String.valueOf((Object)ChatColor.RED) + "\u4f60\u6ca1\u6709\u8bbe\u7f6e\u4efb\u4f55\u5bb6");
        }
    }

    private void saveHome(Player player, String homeName, Location location) {
        String path = "homes." + String.valueOf(player.getUniqueId()) + "." + homeName;
        FileConfiguration homesConfig = this.plugin.getHomesConfig();
        homesConfig.set(path + ".world", (Object)location.getWorld().getName());
        homesConfig.set(path + ".x", (Object)location.getX());
        homesConfig.set(path + ".y", (Object)location.getY());
        homesConfig.set(path + ".z", (Object)location.getZ());
        homesConfig.set(path + ".yaw", (Object)Float.valueOf(location.getYaw()));
        homesConfig.set(path + ".pitch", (Object)Float.valueOf(location.getPitch()));
        this.plugin.saveHomesConfig();
    }

    private Location getHome(Player player, String homeName) {
        String path = "homes." + String.valueOf(player.getUniqueId()) + "." + homeName;
        FileConfiguration homesConfig = this.plugin.getHomesConfig();
        if (homesConfig.contains(path)) {
            String world = homesConfig.getString(path + ".world");
            double x = homesConfig.getDouble(path + ".x");
            double y = homesConfig.getDouble(path + ".y");
            double z = homesConfig.getDouble(path + ".z");
            float yaw = (float)homesConfig.getDouble(path + ".yaw");
            float pitch = (float)homesConfig.getDouble(path + ".pitch");
            return new Location(Bukkit.getWorld((String)world), x, y, z, yaw, pitch);
        }
        return null;
    }

    private void deleteHome(Player player, String homeName) {
        String path = "homes." + String.valueOf(player.getUniqueId()) + "." + homeName;
        FileConfiguration homesConfig = this.plugin.getHomesConfig();
        homesConfig.set(path, null);
        this.plugin.saveHomesConfig();
    }
}

