/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa.commands;

import fand.fandtpa.util.ChatColor;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;

public class BackCommand
implements CommandExecutor,
Listener {
    private final HashMap<UUID, Location> deathLocations = new HashMap();
    private final Logger logger;

    public BackCommand(Logger logger) {
        this.logger = logger;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c\u8be5\u547d\u4ee4\u53ea\u80fd\u7531\u73a9\u5bb6\u4f7f\u7528\uff01"));
            return true;
        }
        Player player = (Player)sender;
        UUID playerUUID = player.getUniqueId();
        Location deathLocation = this.deathLocations.get(playerUUID);
        if (deathLocation != null) {
            player.teleport(deathLocation);
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', "&a\u4f60\u5df2\u4f20\u9001\u5230\u4e0a\u4e00\u6b21\u6b7b\u4ea1\u5730\u70b9"));
            this.logger.info(player.getName() + " \u5df2\u4f20\u9001\u5230\u6b7b\u4ea1\u5730\u70b9: " + deathLocation.toString());
        } else {
            player.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c\u6ca1\u6709\u627e\u5230\u6b7b\u4ea1\u5730\u70b9"));
            this.logger.warning("\u672a\u627e\u5230 " + player.getName() + " \u7684\u6b7b\u4ea1\u5730\u70b9\u8bb0\u5f55");
        }
        return true;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        UUID playerUUID = player.getUniqueId();
        Location deathLocation = player.getLocation();
        this.deathLocations.put(playerUUID, deathLocation);
        this.logger.info("\u8bb0\u5f55 " + player.getName() + " \u7684\u6b7b\u4ea1\u5730\u70b9: " + deathLocation.toString());
    }
}

