/*
 * Decompiled with CFR 0.152.
 */
package fand.fandtpa;

import fand.fandtpa.commands.BackCommand;
import fand.fandtpa.commands.FlyCommand;
import fand.fandtpa.commands.GmCommand;
import fand.fandtpa.commands.HatCommand;
import fand.fandtpa.commands.HomeCommand;
import fand.fandtpa.commands.HomeTabCompleter;
import fand.fandtpa.commands.InvseeCommand;
import fand.fandtpa.commands.SetTitleCommand;
import fand.fandtpa.commands.SuicideCommand;
import fand.fandtpa.commands.TabReloadCommand;
import fand.fandtpa.commands.TpaCommand;
import fand.fandtpa.commands.TpacceptCommand;
import fand.fandtpa.commands.TpahereCommand;
import fand.fandtpa.commands.TpdenyCommand;
import fand.fandtpa.commands.TprandomCommand;
import fand.fandtpa.listeners.PlayerChatListener;
import fand.fandtpa.tab.TabListUpdater;
import fand.fandtpa.util.ChatColor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    public FileConfiguration tabConfig;
    private File homesFile;
    private FileConfiguration homesConfig;
    private File titlesFile;
    private FileConfiguration titlesConfig;
    private final HashMap<UUID, Location> deathLocations = new HashMap();

    public void onEnable() {
        this.logToConsole(String.valueOf((Object)ChatColor.GREEN) + "\u63d2\u4ef6\u6b63\u5728\u542f\u7528...");
        try {
            int time = 20;
            this.loadTabConfig();
            this.createDataFolders();
            this.loadConfigurationFiles();
            this.registerCommands();
            this.registerListeners();
            new TabListUpdater(this).runTaskTimer((Plugin)this, 0L, time);
            this.logToConsole(String.valueOf((Object)ChatColor.GREEN) + "\u63d2\u4ef6\u542f\u7528\u6210\u529f\uff01");
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, String.valueOf((Object)ChatColor.RED) + "\u63d2\u4ef6\u542f\u7528\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage(), e);
        }
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
    }

    public void onDisable() {
        this.logToConsole(String.valueOf((Object)ChatColor.GREEN) + "\u63d2\u4ef6\u6b63\u5728\u7981\u7528...");
        this.saveConfigurationFiles();
        this.logToConsole(String.valueOf((Object)ChatColor.GREEN) + "\u63d2\u4ef6\u5df2\u7981\u7528");
    }

    public void loadTabConfig() {
        File tabFile = new File(this.getDataFolder(), "tab.yml");
        if (!tabFile.exists()) {
            this.saveResource("tab.yml", false);
        }
        this.tabConfig = YamlConfiguration.loadConfiguration((File)tabFile);
    }

    private void createDataFolders() {
        if (!this.getDataFolder().exists() && !this.getDataFolder().mkdirs()) {
            this.getLogger().severe("\u63d2\u4ef6\u4e3b\u6570\u636e\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25: " + this.getDataFolder().getPath());
            return;
        }
        this.homesFile = this.createFile("homes.yml");
        this.titlesFile = this.createFile("titles.yml");
    }

    private File createFile(String fileName) {
        File file;
        block5: {
            file = new File(this.getDataFolder(), fileName);
            if (!file.exists()) {
                try {
                    if (file.createNewFile()) {
                        this.getLogger().info(fileName + " \u6587\u4ef6\u5df2\u521b\u5efa: " + file.getPath());
                        break block5;
                    }
                    this.getLogger().severe(fileName + " \u6587\u4ef6\u521b\u5efa\u5931\u8d25: " + file.getPath());
                }
                catch (IOException e) {
                    this.getLogger().log(Level.SEVERE, "\u521b\u5efa " + fileName + " \u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage(), e);
                }
            } else {
                this.getLogger().info(fileName + " \u6587\u4ef6\u5df2\u5b58\u5728: " + file.getPath());
            }
        }
        return file;
    }

    private void loadConfigurationFiles() {
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
        this.titlesConfig = YamlConfiguration.loadConfiguration((File)this.titlesFile);
    }

    private void saveConfigurationFiles() {
        this.saveConfigFile(this.homesConfig, this.homesFile);
        this.saveConfigFile(this.titlesConfig, this.titlesFile);
    }

    private void saveConfigFile(FileConfiguration config, File file) {
        try {
            if (config != null && file != null) {
                config.save(file);
            }
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, String.valueOf((Object)ChatColor.RED) + "\u4fdd\u5b58\u914d\u7f6e\u6587\u4ef6 " + file.getName() + " \u65f6\u53d1\u751f\u9519\u8bef: " + e.getMessage(), e);
        }
    }

    public FileConfiguration getHomesConfig() {
        return this.homesConfig;
    }

    public void saveHomesConfig() {
        this.saveConfigFile(this.homesConfig, this.homesFile);
    }

    public FileConfiguration getTitlesConfig() {
        return this.titlesConfig;
    }

    public void saveTitlesConfig() {
        this.saveConfigFile(this.titlesConfig, this.titlesFile);
    }

    private void registerCommands() {
        Objects.requireNonNull(this.getCommand("tpa")).setExecutor((CommandExecutor)new TpaCommand(this));
        Objects.requireNonNull(this.getCommand("tpahere")).setExecutor((CommandExecutor)new TpahereCommand(this));
        Objects.requireNonNull(this.getCommand("tpaccept")).setExecutor((CommandExecutor)new TpacceptCommand(this));
        Objects.requireNonNull(this.getCommand("tpdeny")).setExecutor((CommandExecutor)new TpdenyCommand(this));
        Objects.requireNonNull(this.getCommand("home")).setExecutor((CommandExecutor)new HomeCommand(this));
        Objects.requireNonNull(this.getCommand("home")).setTabCompleter((TabCompleter)new HomeTabCompleter(this));
        Objects.requireNonNull(this.getCommand("back")).setExecutor((CommandExecutor)new BackCommand(this.getLogger()));
        Objects.requireNonNull(this.getCommand("settitle")).setExecutor((CommandExecutor)new SetTitleCommand(this));
        Objects.requireNonNull(this.getCommand("suicide")).setExecutor((CommandExecutor)new SuicideCommand());
        Objects.requireNonNull(this.getCommand("rtp")).setExecutor((CommandExecutor)new TprandomCommand(this));
        Objects.requireNonNull(this.getCommand("invsee")).setExecutor((CommandExecutor)new InvseeCommand());
        Objects.requireNonNull(this.getCommand("hat")).setExecutor((CommandExecutor)new HatCommand());
        Objects.requireNonNull(this.getCommand("fly")).setExecutor((CommandExecutor)new FlyCommand());
        Objects.requireNonNull(this.getCommand("gm")).setExecutor((CommandExecutor)new GmCommand());
        Objects.requireNonNull(this.getCommand("tab")).setExecutor((CommandExecutor)new TabReloadCommand(this));
    }

    private void registerListeners() {
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerChatListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BackCommand(this.getLogger()), (Plugin)this);
    }

    private void logToConsole(String message) {
        this.getServer().getConsoleSender().sendMessage(message);
    }
}

