/*
 * Decompiled with CFR 0.152.
 */
package com.lyttledev.lyttleutils.utils.storage;

import com.lyttledev.lyttleutils.types.YamlConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import org.bukkit.plugin.java.JavaPlugin;

public class GlobalConfig {
    private static final String RELATIVE_CONFIG_PATH = "../LyttleDevelopment/global.yml";
    private static final String DEFAULT_CONFIG_CONTENT = "# Global configuration for all LyttleDevelopment plugins\nenabled: false\n\n################\n# Message Prefix\n################\nprefix: <dark_aqua><bold>Lyttle<aqua><bold>Development<reset> <dark_gray>- <gray>\n\n##########################\n# Generic Error Messages #\n##########################\nno_permission: <red>You do not have permission to do that!\nplayer_not_found: <dark_red>Player not found\nmust_be_player: <red>You must be a player to use this command!\nmessage_not_found: <red>Oh... I can't react to that. (Contact the Administrators)\n\n##########################\n\n# Used internally for configuration updates.\n# \u26a0\ufe0f Do not change this value.\nconfig_version: 0";
    private final JavaPlugin plugin;
    private final YamlConfig config;
    private WatchService watchService;

    public GlobalConfig(JavaPlugin plugin) {
        File globalFile;
        boolean created;
        this.plugin = plugin;
        File pluginsDir = plugin.getDataFolder().getParentFile();
        File globalFolder = new File(pluginsDir, "LyttleDevelopment");
        if (!globalFolder.exists() && !(created = globalFolder.mkdirs())) {
            plugin.getLogger().severe("Could not create LyttleDevelopment directory at " + globalFolder.getPath());
        }
        if (!(globalFile = new File(globalFolder, "global.yml")).exists()) {
            try (FileWriter writer = new FileWriter(globalFile);){
                writer.write(DEFAULT_CONFIG_CONTENT);
                writer.flush();
                plugin.getLogger().info("Created new global config at " + globalFile.getPath());
            }
            catch (IOException e) {
                plugin.getLogger().severe("Failed to create global.yml: " + e.getMessage());
            }
        }
        this.config = new YamlConfig(plugin, RELATIVE_CONFIG_PATH);
        this.migrateIfNeeded();
        this.startWatcher(globalFolder.toPath(), "global.yml");
    }

    private void migrateIfNeeded() {
        if (!this.config.contains("config_version")) {
            this.config.set("config_version", 0);
        }
        switch (this.config.get("config_version").toString()) {
            default: 
        }
    }

    private void startWatcher(Path folderPath, String fileName) {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            folderPath.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            Thread watcherThread = new Thread(() -> {
                while (!Thread.currentThread().isInterrupted()) {
                    WatchKey key;
                    try {
                        key = this.watchService.take();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent<?> ev;
                        Path changed;
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind != StandardWatchEventKinds.ENTRY_MODIFY || !(changed = (Path)(ev = event).context()).getFileName().toString().equals(fileName)) continue;
                        this.config.reload();
                        this.plugin.getLogger().info("Detected external change in global.yml; reloaded cache.");
                    }
                    boolean valid = key.reset();
                    if (valid) continue;
                    break;
                }
            }, "GlobalConfig-Watcher");
            watcherThread.setDaemon(true);
            watcherThread.start();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to start WatchService for global.yml: " + e.getMessage());
        }
    }

    public String get(String path) {
        Object value = this.config.get(path);
        return value != null ? value.toString() : null;
    }

    public void set(String path, Object value) {
        if (value == null) {
            this.config.remove(path);
        } else {
            this.config.set(path, value);
        }
    }

    public boolean contains(String path) {
        return this.config.contains(path);
    }
}

