/*
 * Decompiled with CFR 0.152.
 */
package com.lyttledev.lyttleutils.utils.selector;

import com.lyttledev.lyttleutils.utils.selector.SelectorResolver;
import com.lyttledev.lyttleutils.utils.selector.SelectorResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class SelectorUtil {
    private static final SelectorResolver RESOLVER = new SelectorResolver();

    public static List<Entity> resolveSelector(CommandSender sender, String input, boolean playersOnly) {
        SelectorResult result = RESOLVER.resolve(sender, input, playersOnly);
        return result.getEntities();
    }

    public static SelectorResult resolveSelectorDetailed(CommandSender sender, String input, boolean playersOnly) {
        return RESOLVER.resolve(sender, input, playersOnly);
    }

    @Deprecated
    private static List<Entity> resolveVanillaSelector(Player executor, String selector, boolean playersOnly) {
        List result = Bukkit.selectEntities((CommandSender)executor, (String)selector);
        if (playersOnly) {
            return result.stream().filter(e -> e instanceof Player).collect(Collectors.toList());
        }
        return result;
    }

    public static List<String> selectorCompletions(String current) {
        ArrayList<String> base = new ArrayList<String>(Arrays.asList("@a", "@p", "@r", "@s", "*", "**", "@e"));
        for (Player p : Bukkit.getOnlinePlayers()) {
            base.add(p.getName());
        }
        String pref = current == null ? "" : current.toLowerCase();
        ArrayList<String> out = new ArrayList<String>();
        for (String opt : base) {
            if (!opt.toLowerCase().startsWith(pref)) continue;
            out.add(opt);
        }
        return out;
    }

    public static List<String> selectorCompletions(String current, boolean singleTargetOnly) {
        if (!singleTargetOnly) {
            return SelectorUtil.selectorCompletions(current);
        }
        HashSet<String> disallow = new HashSet<String>(Arrays.asList("@a", "*", "**", "@e"));
        return SelectorUtil.selectorCompletions(current, disallow);
    }

    public static List<String> selectorCompletions(String current, Set<String> disallow) {
        ArrayList<String> base = new ArrayList<String>(Arrays.asList("@a", "@p", "@r", "@s", "*", "**", "@e"));
        for (Player p : Bukkit.getOnlinePlayers()) {
            base.add(p.getName());
        }
        String pref = current == null ? "" : current.toLowerCase();
        ArrayList<String> out = new ArrayList<String>();
        for (String opt : base) {
            if (disallow != null && disallow.contains(opt) || !opt.toLowerCase().startsWith(pref)) continue;
            out.add(opt);
        }
        return out;
    }
}

