/*
 * Decompiled with CFR 0.152.
 */
package com.lyttledev.lyttleutils.utils.selector;

import com.lyttledev.lyttleutils.utils.selector.SelectorResult;
import com.lyttledev.lyttleutils.utils.selector.SelectorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

final class SelectorResolver {
    public static final String PERM_VANILLA = "lyttleessentials.selector.vanilla";
    public static final String PERM_ALL = "lyttleessentials.selector.all";
    public static final String PERM_RANDOM = "lyttleessentials.selector.random";
    public static final String PERM_ENTITIES = "lyttleessentials.selector.entities";
    public static final String PERM_EXCEPT_SELF = "lyttleessentials.selector.except_self";

    SelectorResolver() {
    }

    SelectorResult resolve(CommandSender sender, String input, boolean playersOnly) {
        if (!Bukkit.isPrimaryThread()) {
            return SelectorResult.notOnMainThread();
        }
        if (input == null) {
            return SelectorResult.invalidInput("Selector input is null.");
        }
        String in = input.trim();
        if (in.isEmpty()) {
            return SelectorResult.invalidInput("Selector input is empty.");
        }
        if (in.equals("*") || in.equalsIgnoreCase("@a")) {
            if (!sender.hasPermission(PERM_ALL)) {
                return SelectorResult.noPermission("Missing permission: lyttleessentials.selector.all");
            }
            if (playersOnly) {
                return SelectorResult.ok(new ArrayList(Bukkit.getOnlinePlayers()));
            }
            List entities = Bukkit.getOnlinePlayers().stream().map(p -> p).collect(Collectors.toList());
            return SelectorResult.ok(entities);
        }
        if (in.equals("**")) {
            if (!(sender instanceof Player)) {
                return SelectorResult.invalidContext("The '**' alias requires a player as sender.");
            }
            if (!sender.hasPermission(PERM_EXCEPT_SELF)) {
                return SelectorResult.noPermission("Missing permission: lyttleessentials.selector.except_self");
            }
            Player self = (Player)sender;
            List others = Bukkit.getOnlinePlayers().stream().filter(p -> !p.equals((Object)self)).collect(Collectors.toList());
            return SelectorResult.ok(others);
        }
        if (in.equalsIgnoreCase("@r")) {
            if (!sender.hasPermission(PERM_RANDOM)) {
                return SelectorResult.noPermission("Missing permission: lyttleessentials.selector.random");
            }
            ArrayList players = new ArrayList(Bukkit.getOnlinePlayers());
            if (players.isEmpty()) {
                return SelectorResult.noMatches();
            }
            Player random = (Player)players.get(ThreadLocalRandom.current().nextInt(players.size()));
            return SelectorResult.ok(Collections.singletonList(random));
        }
        if (in.equalsIgnoreCase("@s")) {
            if (!sender.hasPermission(PERM_VANILLA)) {
                return SelectorResult.noPermission("Missing permission: lyttleessentials.selector.vanilla");
            }
            if (!(sender instanceof Player)) {
                return SelectorResult.invalidContext("The '@s' selector requires a player as sender.");
            }
            Player self = (Player)sender;
            return SelectorResult.ok(Collections.singletonList(self));
        }
        if (in.equalsIgnoreCase("@p")) {
            if (!sender.hasPermission(PERM_VANILLA)) {
                return SelectorResult.noPermission("Missing permission: lyttleessentials.selector.vanilla");
            }
            if (!(sender instanceof Player)) {
                return SelectorResult.invalidContext("The '@p' selector requires a player as sender.");
            }
            Player src = (Player)sender;
            ArrayList players = new ArrayList(Bukkit.getOnlinePlayers());
            if (players.isEmpty()) {
                return SelectorResult.noMatches();
            }
            Player nearest = players.stream().filter(p -> p.getWorld().equals((Object)src.getWorld())).min(Comparator.comparingDouble(p -> p.getLocation().distanceSquared(src.getLocation()))).orElse(null);
            if (nearest == null) {
                return SelectorResult.noMatches();
            }
            return SelectorResult.ok(Collections.singletonList(nearest));
        }
        if (in.startsWith("@")) {
            if (!sender.hasPermission(PERM_VANILLA)) {
                return SelectorResult.noPermission("Missing permission: lyttleessentials.selector.vanilla");
            }
            SelectorType kind = SelectorType.fromInput(in);
            switch (kind) {
                case ALL: {
                    if (sender.hasPermission(PERM_ALL)) break;
                    return SelectorResult.noPermission("Missing permission: lyttleessentials.selector.all");
                }
                case RANDOM: {
                    if (sender.hasPermission(PERM_RANDOM)) break;
                    return SelectorResult.noPermission("Missing permission: lyttleessentials.selector.random");
                }
                case ENTITIES: {
                    if (sender.hasPermission(PERM_ENTITIES)) break;
                    return SelectorResult.noPermission("Missing permission: lyttleessentials.selector.entities");
                }
            }
            try {
                List selected = Bukkit.selectEntities((CommandSender)sender, (String)in);
                if (playersOnly) {
                    selected = selected.stream().filter(e -> e instanceof Player).collect(Collectors.toList());
                }
                if (selected.isEmpty()) {
                    return SelectorResult.noMatches();
                }
                return SelectorResult.ok(selected);
            }
            catch (IllegalArgumentException iae) {
                return SelectorResult.invalidSelector("Invalid selector: " + in);
            }
            catch (Exception ex) {
                return SelectorResult.error("Error resolving selector: " + ex.getMessage());
            }
        }
        Player exact = Bukkit.getPlayerExact((String)in);
        if (exact != null) {
            return SelectorResult.ok(Collections.singletonList(exact));
        }
        try {
            UUID uuid = UUID.fromString(in);
            for (World w : Bukkit.getWorlds()) {
                Entity e2 = w.getEntity(uuid);
                if (e2 == null) continue;
                if (playersOnly && !(e2 instanceof Player)) {
                    return SelectorResult.noMatches();
                }
                return SelectorResult.ok(Collections.singletonList(e2));
            }
            return SelectorResult.noMatches();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return SelectorResult.noMatches();
        }
    }
}

