/*
 * Decompiled with CFR 0.152.
 */
package com.lyttledev.lyttleutils.utils.convertion;

import java.util.Base64;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public class ItemSerializer {
    public static String serializeInventory(ItemStack[] items) {
        StringBuilder serialized = new StringBuilder();
        for (ItemStack item : items) {
            if (item != null) {
                String serializedItem = Base64.getEncoder().encodeToString(item.serializeAsBytes());
                serialized.append(serializedItem).append(";");
                continue;
            }
            serialized.append("null;");
        }
        return serialized.toString();
    }

    public static ItemStack[] deserializeInventory(String serializedInventory, int tries) {
        try {
            String[] serializedItems = serializedInventory.split(";");
            ItemStack[] inventoryContents = new ItemStack[serializedItems.length];
            for (int i = 0; i < serializedItems.length; ++i) {
                String serializedItem = serializedItems[i];
                if (serializedItem.equals("null")) continue;
                byte[] serializedData = Base64.getDecoder().decode(serializedItem);
                inventoryContents[i] = ItemStack.deserializeBytes((byte[])serializedData);
            }
            return inventoryContents;
        }
        catch (Exception exception) {
            if (tries > 10) {
                Bukkit.getConsoleSender().sendMessage(Component.text((String)"GRAVESTONE: ERROR WHILE DE-SERIALISING INVENTORY!").color((TextColor)NamedTextColor.RED));
                return new ItemStack[0];
            }
            ItemSerializer.deserializeInventory(serializedInventory, tries + 1);
            return null;
        }
    }
}

