/*
 * Decompiled with CFR 0.152.
 */
package com.lyttledev.lyttleutils.utils.communication;

import com.lyttledev.lyttleutils.types.Message.ReplacementEntry;
import com.lyttledev.lyttleutils.types.Message.Replacements;
import com.lyttledev.lyttleutils.types.YamlConfig;
import com.lyttledev.lyttleutils.utils.communication.Console;
import com.lyttledev.lyttleutils.utils.convertion.Placeholder;
import com.lyttledev.lyttleutils.utils.storage.GlobalConfig;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class Message {
    private final JavaPlugin plugin;
    private final Console console;
    private final YamlConfig messages;
    private final GlobalConfig global;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public Message(JavaPlugin plugin, YamlConfig messages, GlobalConfig global) {
        this.plugin = plugin;
        this.messages = messages;
        this.global = global;
        this.console = new Console(plugin);
    }

    private Component _getPrefix() {
        return this._getMessageFromGlobalConfig("prefix");
    }

    private Component _getPrefix(Boolean enabled) {
        return enabled != false ? this._getMessageFromGlobalConfig("prefix") : Component.empty();
    }

    private Component _getMessageFromGlobalConfig(String messageKey) {
        if (!this.global.get("enabled").equalsIgnoreCase("true")) {
            return this._getMessageFromMessagesConfig(messageKey);
        }
        String message = this.global.get(messageKey);
        if (message == null) {
            return this._getMessageFromMessagesConfig(messageKey);
        }
        return this.miniMessage.deserialize((Object)message);
    }

    private Component _getMessageFromMessagesConfig(String messageKey) {
        String message = (String)this.messages.get(messageKey);
        if (message == null) {
            this.console.log("Message key " + messageKey + " not found in messages.yml");
            message = (String)this.messages.get("message_not_found");
        }
        if (message == null) {
            this.console.log("Even the message_not_found not found in messages.yml...");
            message = "&cOh... I can't react to that. (Contact the Administrators)";
        }
        return this.miniMessage.deserialize((Object)message);
    }

    private Component _replaceMessageStrings(Component message, Replacements replacements, @Nullable Player player) {
        String messageString = (String)this.miniMessage.serialize(message);
        for (ReplacementEntry replacement : replacements.getAll()) {
            messageString = messageString.replace(replacement.getKey(), replacement.getValue());
        }
        messageString = Placeholder.parsePlaceholders(player, messageString);
        return this.miniMessage.deserialize((Object)messageString);
    }

    private Component _replaceMessageStrings(Component message, Replacements replacements) {
        String messageString = (String)this.miniMessage.serialize(message);
        for (ReplacementEntry replacement : replacements.getAll()) {
            messageString = messageString.replace(replacement.getKey(), replacement.getValue());
        }
        messageString = Placeholder.parsePlaceholders(null, messageString);
        return this.miniMessage.deserialize((Object)messageString);
    }

    private Component _replaceMessageStrings(Component message, @Nullable Player player) {
        String messageString = (String)this.miniMessage.serialize(message);
        messageString = Placeholder.parsePlaceholders(player, messageString);
        return this.miniMessage.deserialize((Object)messageString);
    }

    private void _sendMessage(Object target, Component message) {
        if (target instanceof Player) {
            ((Player)target).sendMessage(message);
        }
        if (target instanceof ConsoleCommandSender) {
            ((ConsoleCommandSender)target).sendMessage(message);
        }
    }

    private Component _combineComponents(Component ... components) {
        TextComponent combined = Component.empty();
        for (Component component : components) {
            combined = combined.append(component);
        }
        return combined;
    }

    private Component _cleanupMessage(Component message) {
        String messageString = (String)this.miniMessage.serialize(message);
        messageString = messageString.replace("\\n", "\n");
        messageString = messageString.replace("\\", "");
        Component cleaned = MiniMessage.miniMessage().deserialize((Object)messageString);
        String legacySerialized = LegacyComponentSerializer.legacyAmpersand().serialize(cleaned);
        return LegacyComponentSerializer.legacyAmpersand().deserialize(legacySerialized);
    }

    private Component _cleanupMessage(Component ... components) {
        Component combined = this._combineComponents(components);
        return this._cleanupMessage(combined);
    }

    public void sendMessage(Object target, String messageKey) {
        Component msg = this._cleanupMessage(this._getPrefix(), this._getMessageFromGlobalConfig(messageKey));
        this._sendMessage(target, msg);
    }

    public void sendMessage(boolean prefix, Object target, String messageKey) {
        Component msg = this._cleanupMessage(this._getPrefix(prefix), this._getMessageFromGlobalConfig(messageKey));
        this._sendMessage(target, msg);
    }

    public void sendMessage(Object target, String messageKey, Replacements replacements) {
        Component msg = this._cleanupMessage(this._getPrefix(), this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), replacements));
        this._sendMessage(target, msg);
    }

    public void sendMessage(boolean prefix, Object target, String messageKey, Replacements replacements) {
        Component msg = this._cleanupMessage(this._getPrefix(prefix), this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), replacements));
        this._sendMessage(target, msg);
    }

    public void sendMessage(Object target, String messageKey, @Nullable Player player) {
        Component msg = this._cleanupMessage(this._getPrefix(), this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), player));
        this._sendMessage(target, msg);
    }

    public void sendMessage(boolean prefix, Object target, String messageKey, @Nullable Player player) {
        Component msg = this._cleanupMessage(this._getPrefix(prefix), this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), player));
        this._sendMessage(target, msg);
    }

    public void sendMessage(Object target, String messageKey, Replacements replacements, @Nullable Player player) {
        Component msg = this._cleanupMessage(this._getPrefix(), this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), replacements, player));
        this._sendMessage(target, msg);
    }

    public void sendMessage(boolean prefix, Object target, String messageKey, Replacements replacements, @Nullable Player player) {
        Component msg = this._cleanupMessage(this._getPrefix(prefix), this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), replacements, player));
        this._sendMessage(target, msg);
    }

    public void sendMessageRaw(Object target, Component message) {
        Component msg = this._cleanupMessage(this._getPrefix(), message);
        this._sendMessage(target, msg);
    }

    public void sendMessageRaw(boolean prefix, Object target, Component message) {
        Component msg = this._cleanupMessage(this._getPrefix(prefix), message);
        this._sendMessage(target, msg);
    }

    public void sendMessageRaw(Object target, Component message, Replacements replacements) {
        Component msg = this._cleanupMessage(this._getPrefix(), this._replaceMessageStrings(message, replacements));
        this._sendMessage(target, msg);
    }

    public void sendMessageRaw(boolean prefix, Object target, Component message, Replacements replacements) {
        Component msg = this._cleanupMessage(this._getPrefix(prefix), this._replaceMessageStrings(message, replacements));
        this._sendMessage(target, msg);
    }

    public void sendMessageRaw(Object target, Component message, @Nullable Player player) {
        Component msg = this._cleanupMessage(this._getPrefix(), this._replaceMessageStrings(message, player));
        this._sendMessage(target, msg);
    }

    public void sendMessageRaw(boolean prefix, Object target, Component message, @Nullable Player player) {
        Component msg = this._cleanupMessage(this._getPrefix(prefix), this._replaceMessageStrings(message, player));
        this._sendMessage(target, msg);
    }

    public void sendMessageRaw(Object target, Component message, Replacements replacements, @Nullable Player player) {
        Component msg = this._cleanupMessage(this._getPrefix(), this._replaceMessageStrings(message, replacements, player));
        this._sendMessage(target, msg);
    }

    public void sendMessageRaw(boolean prefix, Object target, Component message, Replacements replacements, @Nullable Player player) {
        Component msg = this._cleanupMessage(this._getPrefix(prefix), this._replaceMessageStrings(message, replacements, player));
        this._sendMessage(target, msg);
    }

    public void sendBroadcast(Component message) {
        Bukkit.broadcast((Component)this._cleanupMessage(message));
    }

    public void sendBroadcast(boolean prefix, Component message) {
        Bukkit.broadcast((Component)this._cleanupMessage(this._getPrefix(prefix), message));
    }

    public void sendBroadcast(String messageKey, Replacements replacements) {
        Component message = this._cleanupMessage(this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), replacements));
        this.sendBroadcast(message);
    }

    public void sendBroadcast(boolean prefix, String messageKey, Replacements replacements) {
        Component message = this._cleanupMessage(this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), replacements));
        this.sendBroadcast(prefix, message);
    }

    public void sendBroadcast(String messageKey, @Nullable Player player) {
        Component message = this._cleanupMessage(this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), player));
        this.sendBroadcast(message);
    }

    public void sendBroadcast(boolean prefix, String messageKey, @Nullable Player player) {
        Component message = this._cleanupMessage(this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), player));
        this.sendBroadcast(prefix, message);
    }

    public void sendBroadcast(String messageKey, Replacements replacements, @Nullable Player player) {
        Component message = this._cleanupMessage(this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), replacements, player));
        this.sendBroadcast(message);
    }

    public void sendBroadcast(boolean prefix, String messageKey, Replacements replacements, @Nullable Player player) {
        Component message = this._cleanupMessage(this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), replacements, player));
        this.sendBroadcast(prefix, message);
    }

    public void sendBroadcastRaw(Component message) {
        Bukkit.broadcast((Component)this._cleanupMessage(message));
    }

    public void sendBroadcastRaw(boolean prefix, Component message) {
        Bukkit.broadcast((Component)this._cleanupMessage(this._getPrefix(prefix), message));
    }

    public void sendBroadcastRaw(Component message, Replacements replacements) {
        message = this._cleanupMessage(this._replaceMessageStrings(message, replacements));
        this.sendBroadcast(message);
    }

    public void sendBroadcastRaw(boolean prefix, Component message, Replacements replacements) {
        message = this._cleanupMessage(this._replaceMessageStrings(message, replacements));
        this.sendBroadcast(prefix, message);
    }

    public void sendBroadcastRaw(Component message, @Nullable Player player) {
        message = this._cleanupMessage(this._replaceMessageStrings(message, player));
        this.sendBroadcast(message);
    }

    public void sendBroadcastRaw(boolean prefix, Component message, @Nullable Player player) {
        message = this._cleanupMessage(this._replaceMessageStrings(message, player));
        this.sendBroadcast(prefix, message);
    }

    public void sendBroadcastRaw(Component message, Replacements replacements, @Nullable Player player) {
        message = this._cleanupMessage(this._replaceMessageStrings(message, replacements, player));
        this.sendBroadcast(message);
    }

    public void sendBroadcastRaw(boolean prefix, Component message, Replacements replacements, @Nullable Player player) {
        message = this._cleanupMessage(this._replaceMessageStrings(message, replacements, player));
        this.sendBroadcast(prefix, message);
    }

    public Component getMessage(String messageKey) {
        return this._cleanupMessage(this._getMessageFromGlobalConfig(messageKey));
    }

    public Component getMessage(String messageKey, Replacements replacements) {
        return this._cleanupMessage(this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), replacements));
    }

    public Component getMessage(String messageKey, @Nullable Player player) {
        return this._cleanupMessage(this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), player));
    }

    public Component getMessage(String messageKey, Replacements replacements, @Nullable Player player) {
        return this._cleanupMessage(this._replaceMessageStrings(this._getMessageFromGlobalConfig(messageKey), replacements, player));
    }

    public Component getMessageRaw(Component message) {
        return this._cleanupMessage(message);
    }

    public Component getMessageRaw(String message) {
        return this._cleanupMessage(this.miniMessage.deserialize((Object)message));
    }

    public Component getMessageRaw(Component message, Replacements replacements) {
        return this._cleanupMessage(this._replaceMessageStrings(message, replacements));
    }

    public Component getMessageRaw(String message, Replacements replacements) {
        return this._cleanupMessage(this._replaceMessageStrings(this.miniMessage.deserialize((Object)message), replacements));
    }

    public Component getMessageRaw(Component message, @Nullable Player player) {
        return this._cleanupMessage(this._replaceMessageStrings(message, player));
    }

    public Component getMessageRaw(String message, @Nullable Player player) {
        return this._cleanupMessage(this._replaceMessageStrings(this.miniMessage.deserialize((Object)message), player));
    }

    public Component getMessageRaw(Component message, Replacements replacements, @Nullable Player player) {
        return this._cleanupMessage(this._replaceMessageStrings(message, replacements, player));
    }

    public Component getMessageRaw(String message, Replacements replacements, @Nullable Player player) {
        return this._cleanupMessage(this._replaceMessageStrings(this.miniMessage.deserialize((Object)message), replacements, player));
    }
}

