/*
 * Decompiled with CFR 0.152.
 */
package com.lyttledev.lyttleutils.types;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class YamlConfig {
    private final String pluginFolderPath;
    private final String configPath;
    private YamlConfiguration config = null;
    private final JavaPlugin plugin;

    public YamlConfig(JavaPlugin plugin, String configPath) {
        this.pluginFolderPath = plugin.getDataFolder().getPath();
        this.configPath = configPath;
        this.plugin = plugin;
    }

    private YamlConfiguration getConfig() {
        if (this.config == null) {
            try {
                String originalConfigString = Files.readString(Paths.get(this.pluginFolderPath, this.configPath));
                String configString = this.cleanConfig(originalConfigString);
                this.config = new YamlConfiguration();
                this.config.loadFromString(configString);
                if (!configString.equals(originalConfigString)) {
                    this.saveConfig();
                }
            }
            catch (IOException | InvalidConfigurationException var3) {
                this.config = null;
            }
        }
        if (this.config == null) {
            this.plugin.getLogger().severe("Failed to load config " + this.configPath);
            return null;
        }
        return this.config;
    }

    private String cleanConfig(String configString) {
        configString = configString.replaceAll("!!.+", "");
        return configString;
    }

    private void saveConfig() {
        try {
            String originalConfigString = this.config.saveToString();
            try {
                String configString = this.cleanConfig(originalConfigString);
                this.config.loadFromString(configString);
                this.config.save(new File(this.pluginFolderPath, this.configPath));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.config.loadFromString(originalConfigString);
        }
        catch (InvalidConfigurationException invalidConfigurationException) {
            // empty catch block
        }
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)new File(this.pluginFolderPath, this.configPath));
    }

    @Nullable
    public Object get(String path) {
        return this.get(path, null);
    }

    @Nullable
    public Object get(String path, @Nullable Object defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        return cfg != null && cfg.contains(path) ? cfg.get(path) : defaultValue;
    }

    @Nullable
    public String getString(String path) {
        return this.getString(path, null);
    }

    @Nullable
    public String getString(String path, @Nullable String defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        return cfg != null && cfg.contains(path) ? cfg.getString(path) : defaultValue;
    }

    @Nullable
    public Integer getInt(String path) {
        return this.getInt(path, null);
    }

    @Nullable
    public Integer getInt(String path, @Nullable Integer defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        return cfg != null && cfg.contains(path) ? cfg.getInt(path) : defaultValue.intValue();
    }

    @Nullable
    public Long getLong(String path) {
        return this.getLong(path, null);
    }

    @Nullable
    public Long getLong(String path, @Nullable Long defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        return cfg != null && cfg.contains(path) ? cfg.getLong(path) : defaultValue.longValue();
    }

    @Nullable
    public Double getDouble(String path) {
        return this.getDouble(path, null);
    }

    @Nullable
    public Double getDouble(String path, @Nullable Double defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        return cfg != null && cfg.contains(path) ? cfg.getDouble(path) : defaultValue.doubleValue();
    }

    @Nullable
    public Boolean getBoolean(String path) {
        return this.getBoolean(path, null);
    }

    @Nullable
    public Boolean getBoolean(String path, @Nullable Boolean defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        return cfg != null && cfg.contains(path) ? cfg.getBoolean(path) : defaultValue.booleanValue();
    }

    @Nullable
    public List<?> getList(String path) {
        return this.getList(path, null);
    }

    @Nullable
    public List<?> getList(String path, @Nullable List<?> defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        return cfg != null && cfg.contains(path) ? cfg.getList(path) : defaultValue;
    }

    @Nullable
    public List<String> getStringList(String path) {
        return this.getStringList(path, null);
    }

    @Nullable
    public List<String> getStringList(String path, @Nullable List<String> defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        List list = cfg != null && cfg.contains(path) ? cfg.getStringList(path) : null;
        return list != null ? list : defaultValue;
    }

    @Nullable
    public List<Integer> getIntegerList(String path) {
        return this.getIntegerList(path, null);
    }

    @Nullable
    public List<Integer> getIntegerList(String path, @Nullable List<Integer> defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        List list = cfg != null && cfg.contains(path) ? cfg.getIntegerList(path) : null;
        return list != null ? list : defaultValue;
    }

    @Nullable
    public List<Double> getDoubleList(String path) {
        return this.getDoubleList(path, null);
    }

    @Nullable
    public List<Double> getDoubleList(String path, @Nullable List<Double> defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        List list = cfg != null && cfg.contains(path) ? cfg.getDoubleList(path) : null;
        return list != null ? list : defaultValue;
    }

    @Nullable
    public List<Boolean> getBooleanList(String path) {
        return this.getBooleanList(path, null);
    }

    @Nullable
    public List<Boolean> getBooleanList(String path, @Nullable List<Boolean> defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        List list = cfg != null && cfg.contains(path) ? cfg.getBooleanList(path) : null;
        return list != null ? list : defaultValue;
    }

    @Nullable
    public Map<String, Object> getMap(String path) {
        return this.getMap(path, null);
    }

    @Nullable
    public Map<String, Object> getMap(String path, @Nullable Map<String, Object> defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        return cfg != null && cfg.contains(path) ? cfg.getConfigurationSection(path).getValues(false) : defaultValue;
    }

    @Nullable
    public Set<String> getKeySet(String path) {
        return this.getKeySet(path, null);
    }

    @Nullable
    public Set<String> getKeySet(String path, @Nullable Set<String> defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        return cfg != null && cfg.contains(path) ? cfg.getConfigurationSection(path).getKeys(false) : defaultValue;
    }

    @Nullable
    public List<Map<?, ?>> getMapList(String path) {
        return this.getMapList(path, null);
    }

    @Nullable
    public List<Map<?, ?>> getMapList(String path, @Nullable List<Map<?, ?>> defaultValue) {
        YamlConfiguration cfg = this.getConfig();
        List list = cfg != null && cfg.contains(path) ? cfg.getMapList(path) : null;
        return list != null ? list : defaultValue;
    }

    @Nullable
    public ConfigurationSection getSection(String path) {
        YamlConfiguration cfg = this.getConfig();
        return cfg != null && cfg.contains(path) ? cfg.getConfigurationSection(path) : null;
    }

    public void set(String path, @Nullable Object value) {
        YamlConfiguration cfg = this.getConfig();
        cfg.set(path, value);
        this.saveConfig();
    }

    public boolean remove(String path) {
        YamlConfiguration cfg = this.getConfig();
        if (cfg.contains(path)) {
            cfg.set(path, null);
            this.saveConfig();
            return true;
        }
        return false;
    }

    public boolean contains(String path) {
        YamlConfiguration cfg = this.getConfig();
        return cfg != null && cfg.contains(path);
    }

    public boolean containsLowercase(String path) {
        YamlConfiguration cfg = this.getConfig();
        if (cfg == null) {
            return false;
        }
        for (String key : cfg.getKeys(false)) {
            if (!key.toLowerCase().equalsIgnoreCase(path)) continue;
            return true;
        }
        return false;
    }

    public String[] getKeys(String path) {
        YamlConfiguration cfg = this.getConfig();
        if (cfg == null || !cfg.contains(path)) {
            return null;
        }
        Set keys = cfg.getConfigurationSection(path).getKeys(false);
        return keys.toArray(new String[0]);
    }

    public Object[] getAll(String path) {
        YamlConfiguration cfg = this.getConfig();
        if (cfg == null || !cfg.contains(path)) {
            return new Object[0];
        }
        return cfg.getConfigurationSection(path).getValues(false).values().toArray(new Object[0]);
    }

    public void clear() {
        File configFile = new File(this.pluginFolderPath, this.configPath);
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        for (String key : config.getKeys(false)) {
            config.set(key, null);
        }
        try {
            config.save(configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.reload();
    }
}

