/*
 * Decompiled with CFR 0.152.
 */
package com.lyttledev.lyttleutils.types.Message;

import com.lyttledev.lyttleutils.types.Message.ReplacementEntry;
import java.util.ArrayList;
import java.util.List;

public class Replacements {
    private final List<ReplacementEntry> entries;

    private Replacements(List<ReplacementEntry> entries) {
        this.entries = entries;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Replacements fromStringPairs(String[][] pairs) {
        ReplacementEntry[] entries = new ReplacementEntry[pairs.length];
        for (int i = 0; i < pairs.length; ++i) {
            String key = pairs[i][0];
            String value = pairs[i][1];
            entries[i] = new ReplacementEntry(key, value);
        }
        return new Replacements(List.of(entries));
    }

    public List<ReplacementEntry> getAll() {
        return this.entries;
    }

    public String getValueForKey(String key) {
        for (ReplacementEntry entry : this.entries) {
            if (!entry.getKey().equals(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ReplacementEntry entry : this.entries) {
            sb.append(entry.getKey()).append(" = ").append(entry.getValue()).append("\n");
        }
        return sb.toString();
    }

    public static class Builder {
        private final List<ReplacementEntry> entries = new ArrayList<ReplacementEntry>();

        public Builder add(String key, String value) {
            this.entries.add(new ReplacementEntry(key, value));
            return this;
        }

        public Replacements build() {
            return new Replacements(this.entries);
        }
    }
}

