/*
 * Decompiled with CFR 0.152.
 */
package com.lyttledev.lyttleutils.types;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class JsonConfig<T> {
    private final String pluginFolderPath;
    private final String configPath;
    private final JavaPlugin plugin;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Class<T> dataClass;
    private T dataCache = null;
    private JsonObject configCache = null;

    public JsonConfig(JavaPlugin plugin, String configPath, Class<T> dataClass) {
        this.pluginFolderPath = plugin.getDataFolder().getPath();
        this.configPath = configPath;
        this.plugin = plugin;
        this.dataClass = dataClass;
    }

    @Nullable
    public T getData() {
        block10: {
            if (this.dataCache == null) {
                try {
                    File file = new File(this.pluginFolderPath, this.configPath);
                    if (!file.exists()) {
                        this.dataCache = this.dataClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.saveData();
                        break block10;
                    }
                    try (FileReader reader = new FileReader(file);){
                        this.dataCache = this.gson.fromJson((Reader)reader, this.dataClass);
                        if (this.dataCache == null) {
                            this.dataCache = this.dataClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to load config (POJO) " + this.configPath + ": " + e.getMessage());
                    this.dataCache = null;
                }
            }
        }
        return this.dataCache;
    }

    @Nullable
    private JsonObject getConfig() {
        block9: {
            if (this.configCache == null) {
                try {
                    File file = new File(this.pluginFolderPath, this.configPath);
                    if (!file.exists()) {
                        this.configCache = new JsonObject();
                        this.saveConfig();
                        break block9;
                    }
                    try (FileReader reader = new FileReader(file);){
                        JsonElement element = JsonParser.parseReader((Reader)reader);
                        this.configCache = element != null && element.isJsonObject() ? element.getAsJsonObject() : new JsonObject();
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to load config (JSON) " + this.configPath + ": " + e.getMessage());
                    this.configCache = null;
                }
            }
        }
        return this.configCache;
    }

    public void saveData() {
        try (FileWriter writer = new FileWriter(new File(this.pluginFolderPath, this.configPath));){
            this.gson.toJson(this.getData(), (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save POJO config: " + e.getMessage());
        }
        this.dataCache = null;
        this.configCache = null;
    }

    private void saveConfig() {
        try (FileWriter writer = new FileWriter(new File(this.pluginFolderPath, this.configPath));){
            this.gson.toJson((JsonElement)this.configCache, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save JSON config: " + e.getMessage());
        }
        this.dataCache = null;
        this.configCache = null;
    }

    public void reload() {
        this.dataCache = null;
        this.configCache = null;
        this.getData();
        this.getConfig();
    }

    @Nullable
    public Object get(String path) {
        return this.get(path, null);
    }

    @Nullable
    public Object get(String path, @Nullable Object defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        return element != null ? this.gson.fromJson(element, Object.class) : defaultValue;
    }

    @Nullable
    public String getString(String path) {
        return this.getString(path, null);
    }

    @Nullable
    public String getString(String path, @Nullable String defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        return element != null && element.isJsonPrimitive() ? element.getAsString() : defaultValue;
    }

    @Nullable
    public Integer getInt(String path) {
        return this.getInt(path, null);
    }

    @Nullable
    public Integer getInt(String path, @Nullable Integer defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        return element != null && element.isJsonPrimitive() ? element.getAsInt() : defaultValue.intValue();
    }

    @Nullable
    public Long getLong(String path) {
        return this.getLong(path, null);
    }

    @Nullable
    public Long getLong(String path, @Nullable Long defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        return element != null && element.isJsonPrimitive() ? element.getAsLong() : defaultValue.longValue();
    }

    @Nullable
    public Double getDouble(String path) {
        return this.getDouble(path, null);
    }

    @Nullable
    public Double getDouble(String path, @Nullable Double defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        return element != null && element.isJsonPrimitive() ? element.getAsDouble() : defaultValue.doubleValue();
    }

    @Nullable
    public Boolean getBoolean(String path) {
        return this.getBoolean(path, null);
    }

    @Nullable
    public Boolean getBoolean(String path, @Nullable Boolean defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        return element != null && element.isJsonPrimitive() ? element.getAsBoolean() : defaultValue.booleanValue();
    }

    @Nullable
    public List<?> getList(String path) {
        return this.getList(path, null);
    }

    @Nullable
    public List<?> getList(String path, @Nullable List<?> defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        return element != null && element.isJsonArray() ? (List)this.gson.fromJson(element, List.class) : defaultValue;
    }

    @Nullable
    public List<String> getStringList(String path) {
        return this.getStringList(path, null);
    }

    @Nullable
    public List<String> getStringList(String path, @Nullable List<String> defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        if (element != null && element.isJsonArray()) {
            ArrayList<String> list = new ArrayList<String>();
            element.getAsJsonArray().forEach(e -> {
                if (e.isJsonPrimitive()) {
                    list.add(e.getAsString());
                }
            });
            return list;
        }
        return defaultValue;
    }

    @Nullable
    public List<Integer> getIntegerList(String path) {
        return this.getIntegerList(path, null);
    }

    @Nullable
    public List<Integer> getIntegerList(String path, @Nullable List<Integer> defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        if (element != null && element.isJsonArray()) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            element.getAsJsonArray().forEach(e -> {
                if (e.isJsonPrimitive()) {
                    list.add(e.getAsInt());
                }
            });
            return list;
        }
        return defaultValue;
    }

    @Nullable
    public List<Double> getDoubleList(String path) {
        return this.getDoubleList(path, null);
    }

    @Nullable
    public List<Double> getDoubleList(String path, @Nullable List<Double> defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        if (element != null && element.isJsonArray()) {
            ArrayList<Double> list = new ArrayList<Double>();
            element.getAsJsonArray().forEach(e -> {
                if (e.isJsonPrimitive()) {
                    list.add(e.getAsDouble());
                }
            });
            return list;
        }
        return defaultValue;
    }

    @Nullable
    public List<Boolean> getBooleanList(String path) {
        return this.getBooleanList(path, null);
    }

    @Nullable
    public List<Boolean> getBooleanList(String path, @Nullable List<Boolean> defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        if (element != null && element.isJsonArray()) {
            ArrayList<Boolean> list = new ArrayList<Boolean>();
            element.getAsJsonArray().forEach(e -> {
                if (e.isJsonPrimitive()) {
                    list.add(e.getAsBoolean());
                }
            });
            return list;
        }
        return defaultValue;
    }

    @Nullable
    public Map<String, Object> getMap(String path) {
        return this.getMap(path, null);
    }

    @Nullable
    public Map<String, Object> getMap(String path, @Nullable Map<String, Object> defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        return element != null && element.isJsonObject() ? (Map)this.gson.fromJson(element, Map.class) : defaultValue;
    }

    @Nullable
    public Set<String> getKeySet(String path) {
        return this.getKeySet(path, null);
    }

    @Nullable
    public Set<String> getKeySet(String path, @Nullable Set<String> defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        return element != null && element.isJsonObject() ? element.getAsJsonObject().keySet() : defaultValue;
    }

    @Nullable
    public List<Map<?, ?>> getMapList(String path) {
        return this.getMapList(path, null);
    }

    @Nullable
    public List<Map<?, ?>> getMapList(String path, @Nullable List<Map<?, ?>> defaultValue) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return defaultValue;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        if (element != null && element.isJsonArray()) {
            ArrayList list = new ArrayList();
            element.getAsJsonArray().forEach(e -> {
                if (e != null && e.isJsonObject()) {
                    list.add((Map)this.gson.fromJson(e, Map.class));
                }
            });
            return list;
        }
        return defaultValue;
    }

    @Nullable
    public JsonObject getSection(String path) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return null;
        }
        JsonElement element = this.getElementByPath(cfg, path);
        return element != null && element.isJsonObject() ? element.getAsJsonObject() : null;
    }

    public void set(String path, @Nullable Object value) {
        JsonObject cfg = this.getConfig();
        this.setElementByPath(cfg, path, this.gson.toJsonTree(value));
        this.saveConfig();
    }

    public boolean remove(String path) {
        JsonObject cfg = this.getConfig();
        boolean removed = this.removeElementByPath(cfg, path);
        if (removed) {
            this.saveConfig();
        }
        return removed;
    }

    public boolean contains(String path) {
        JsonObject cfg = this.getConfig();
        return cfg != null && this.getElementByPath(cfg, path) != null;
    }

    public boolean containsLowercase(String path) {
        JsonObject cfg = this.getConfig();
        if (cfg == null) {
            return false;
        }
        for (String key : cfg.keySet()) {
            if (!key.equalsIgnoreCase(path)) continue;
            return true;
        }
        return false;
    }

    public String[] getKeys(String path) {
        Set<String> keys = this.getKeySet(path);
        return keys != null ? keys.toArray(new String[0]) : null;
    }

    public Object[] getAll(String path) {
        Map<String, Object> map = this.getMap(path);
        return map != null ? map.values().toArray(new Object[0]) : new Object[]{};
    }

    public void clear() {
        if (new File(this.pluginFolderPath, this.configPath).delete()) {
            this.reload();
        }
    }

    private JsonElement getElementByPath(JsonObject obj, String path) {
        String[] parts = path.split("\\.");
        JsonObject current = obj;
        for (String part : parts) {
            if (current == null || !current.isJsonObject()) {
                return null;
            }
            JsonObject currentObj = current.getAsJsonObject();
            if (!currentObj.has(part)) {
                return null;
            }
            current = currentObj.get(part);
        }
        return current;
    }

    private void setElementByPath(JsonObject obj, String path, JsonElement value) {
        String[] parts = path.split("\\.");
        JsonObject current = obj;
        for (int i = 0; i < parts.length - 1; ++i) {
            String key = parts[i];
            if (!current.has(key) || !current.get(key).isJsonObject()) {
                JsonObject child = new JsonObject();
                current.add(key, (JsonElement)child);
            }
            current = current.getAsJsonObject(key);
        }
        current.add(parts[parts.length - 1], value);
    }

    private boolean removeElementByPath(JsonObject obj, String path) {
        String[] parts = path.split("\\.");
        JsonObject current = obj;
        for (int i = 0; i < parts.length - 1; ++i) {
            String key = parts[i];
            if (!current.has(key) || !current.get(key).isJsonObject()) {
                return false;
            }
            current = current.getAsJsonObject(key);
        }
        return current.remove(parts[parts.length - 1]) != null;
    }
}

