/*
 * Decompiled with CFR 0.152.
 */
package com.lyttledev.lyttletab.types;

import com.lyttledev.lyttletab.LyttleTab;
import com.lyttledev.lyttleutils.types.YamlConfig;

public class Configs {
    private final LyttleTab plugin;
    public YamlConfig general;
    public YamlConfig messages;
    public YamlConfig bossbar;
    public YamlConfig tab;
    public YamlConfig defaultGeneral;
    public YamlConfig defaultMessages;
    public YamlConfig defaultBossbar;
    public YamlConfig defaultTab;

    public Configs(LyttleTab plugin) {
        this.plugin = plugin;
        this.general = new YamlConfig(plugin, "config.yml");
        this.messages = new YamlConfig(plugin, "messages.yml");
        this.bossbar = new YamlConfig(plugin, "bossbar.yml");
        this.tab = new YamlConfig(plugin, "tab.yml");
        this.defaultGeneral = new YamlConfig(plugin, "#defaults/config.yml");
        this.defaultMessages = new YamlConfig(plugin, "#defaults/messages.yml");
        this.defaultBossbar = new YamlConfig(plugin, "#defaults/bossbar.yml");
        this.defaultTab = new YamlConfig(plugin, "#defaults/tab.yml");
    }

    public void reload() {
        this.general.reload();
        this.messages.reload();
        this.bossbar.reload();
        this.tab.reload();
        this.plugin.reloadConfig();
    }

    private String getConfigPath(String path) {
        return this.plugin.getConfig().getString("configs." + path);
    }
}

