/*
 * Decompiled with CFR 0.152.
 */
package com.lyttledev.lyttletab.handlers;

import com.lyttledev.lyttletab.LyttleTab;
import com.lyttledev.lyttletab.types.Configs;
import com.lyttledev.lyttleutils.types.Message.Replacements;
import com.lyttledev.lyttleutils.utils.entity.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class TabHandler
implements Listener {
    public static LyttleTab plugin;
    private List<String> animatedHeaders;
    private List<String> animatedFooters;
    private int tabListRefreshInterval;
    private int tabListAnimationInterval;
    private AtomicInteger headerIndex = new AtomicInteger(0);
    private AtomicInteger footerIndex = new AtomicInteger(0);
    private int headerTaskId = -1;
    private int footerTaskId = -1;
    private int refreshTaskId = -1;
    private boolean sortingEnabled = true;
    private SortEngine sortEngine = new SortEngine();
    private static final PlainTextComponentSerializer PLAIN_SERIALIZER;

    public TabHandler(LyttleTab plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        TabHandler.plugin = plugin;
        this.loadConfig();
        this.startTasks();
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        this.refreshTabList();
    }

    @EventHandler
    public void onPotionEffect(EntityPotionEffectEvent event) {
        if (!(event.getEntity() instanceof org.bukkit.entity.Player)) {
            return;
        }
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)event.getEntity();
        if (event.getNewEffect() != null && event.getNewEffect().getType() == PotionEffectType.INVISIBILITY) {
            this.hidePlayerFromTab(player, true);
            return;
        }
        if (event.getOldEffect() != null && event.getOldEffect().getType() == PotionEffectType.INVISIBILITY) {
            this.hidePlayerFromTab(player, false);
        }
    }

    public void hidePlayerFromTab(org.bukkit.entity.Player player, Boolean bool) {
        for (org.bukkit.entity.Player target : Bukkit.getOnlinePlayers()) {
            if (target == player) {
                return;
            }
            if (bool.booleanValue()) {
                target.unlistPlayer(player);
                return;
            }
            target.listPlayer(player);
        }
    }

    public void refreshTabList() {
        Collection online = plugin.getServer().getOnlinePlayers();
        if (online.isEmpty()) {
            return;
        }
        ArrayList<org.bukkit.entity.Player> players = new ArrayList<org.bukkit.entity.Player>(online);
        if (this.sortingEnabled && !this.sortEngine.rules.isEmpty()) {
            this.sortEngine.prepare(players);
            players.sort(this.sortEngine.comparator());
        }
        String header = this.animatedHeaders.isEmpty() ? "" : this.animatedHeaders.get(this.headerIndex.get());
        String footer = this.animatedFooters.isEmpty() ? "" : this.animatedFooters.get(this.footerIndex.get());
        for (int i = 0; i < players.size(); ++i) {
            org.bukkit.entity.Player player = (org.bukkit.entity.Player)players.get(i);
            this.applyTabVisuals(player, header, footer);
            player.setPlayerListOrder(i);
        }
    }

    private void advanceHeader() {
        if (this.animatedHeaders.isEmpty()) {
            return;
        }
        this.headerIndex.updateAndGet(i -> (i + 1) % this.animatedHeaders.size());
    }

    private void advanceFooter() {
        if (this.animatedFooters.isEmpty()) {
            return;
        }
        this.footerIndex.updateAndGet(i -> (i + 1) % this.animatedFooters.size());
    }

    private void applyTabVisuals(org.bukkit.entity.Player player, String header, String footer) {
        Replacements replacements = new Replacements.Builder().add("<NAME>", Player.getDisplayName(player)).build();
        String playerName = (String)TabHandler.plugin.config.tab.get("tab_player_name");
        player.playerListName(TabHandler.plugin.message.getMessageRaw(playerName, replacements, player));
        if (!header.isEmpty()) {
            player.sendPlayerListHeader(TabHandler.plugin.message.getMessageRaw(header, player));
        }
        if (!footer.isEmpty()) {
            player.sendPlayerListFooter(TabHandler.plugin.message.getMessageRaw(footer, player));
        }
    }

    public void reload() {
        this.stopTasks();
        this.loadConfig();
        this.resetIndexes();
        this.startTasks();
        this.refreshTabList();
    }

    private void loadConfig() {
        Configs config = TabHandler.plugin.config;
        List<String> loadedHeaders = config.tab.getStringList("tab_list_header");
        List<String> loadedFooters = config.tab.getStringList("tab_list_footer");
        this.animatedHeaders = loadedHeaders != null ? new ArrayList<String>(loadedHeaders) : new ArrayList();
        this.animatedFooters = loadedFooters != null ? new ArrayList<String>(loadedFooters) : new ArrayList();
        this.tabListRefreshInterval = config.tab.getInt("tab_list_refresh_interval");
        this.tabListAnimationInterval = config.tab.getInt("tab_list_animation_interval");
        this.sortingEnabled = TabHandler.getBooleanSafe(config, "sorting.enabled", true);
        this.sortEngine = new SortEngine();
        List<Map<?, ?>> ruleMaps = config.tab.getMapList("sorting.rules");
        if (ruleMaps != null) {
            for (Map<?, ?> rawRule : ruleMaps) {
                String type;
                if (rawRule == null) continue;
                switch (type = TabHandler.toStringSafe(rawRule.get("type")).toLowerCase(Locale.ROOT).trim()) {
                    case "placeholder": {
                        String placeholder = TabHandler.toStringSafe(rawRule.get("placeholder"));
                        SequencedCollection order = TabHandler.toStringList(rawRule.get("order")).reversed();
                        if (placeholder.isEmpty()) break;
                        this.sortEngine.rules.add(new PlaceholderOrderRule(placeholder, (List<String>)order));
                        break;
                    }
                    case "group": {
                        SequencedCollection order = TabHandler.toStringList(rawRule.get("order")).reversed();
                        this.sortEngine.rules.add(new GroupOrderRule((List<String>)order));
                        break;
                    }
                    case "placeholder_a_to_z": {
                        boolean asc;
                        String placeholder = TabHandler.toStringSafe(rawRule.get("placeholder"));
                        String direction = TabHandler.toStringSafe(rawRule.get("order"));
                        boolean bl = asc = !"desc".equalsIgnoreCase(direction);
                        if (placeholder.isEmpty()) break;
                        this.sortEngine.rules.add(new PlaceholderAlphaRule(placeholder, asc));
                        break;
                    }
                }
            }
        }
    }

    private void startTasks() {
        if (!this.animatedHeaders.isEmpty()) {
            this.headerTaskId = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, this::advanceHeader, 0L, (long)Math.max(1, this.tabListAnimationInterval) * 20L).getTaskId();
        }
        if (!this.animatedFooters.isEmpty()) {
            this.footerTaskId = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, this::advanceFooter, 0L, (long)Math.max(1, this.tabListAnimationInterval) * 20L).getTaskId();
        }
        this.refreshTaskId = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, this::refreshTabList, 0L, (long)Math.max(1, this.tabListRefreshInterval) * 20L).getTaskId();
    }

    private void stopTasks() {
        if (this.headerTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.headerTaskId);
        }
        if (this.footerTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.footerTaskId);
        }
        if (this.refreshTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.refreshTaskId);
        }
        this.headerTaskId = -1;
        this.footerTaskId = -1;
        this.refreshTaskId = -1;
    }

    private void resetIndexes() {
        this.headerIndex.set(0);
        this.footerIndex.set(0);
    }

    private static boolean getBooleanSafe(Configs config, String path, boolean def) {
        try {
            Object v = config.tab.get(path);
            return v instanceof Boolean ? (Boolean)v : def;
        }
        catch (Exception e) {
            return def;
        }
    }

    private static String toStringSafe(Object o) {
        return o == null ? "" : String.valueOf(o);
    }

    private static List<String> toStringList(Object o) {
        if (o == null) {
            return Collections.emptyList();
        }
        if (o instanceof List) {
            List list = (List)o;
            ArrayList<String> out = new ArrayList<String>(list.size());
            for (Object e : list) {
                if (e == null) continue;
                out.add(String.valueOf(e));
            }
            return out;
        }
        return Collections.singletonList(String.valueOf(o));
    }

    private String resolvePlaceholderAsString(String placeholder, org.bukkit.entity.Player player) {
        try {
            Component papiValue = TabHandler.plugin.message.getMessageRaw(placeholder, player);
            if (papiValue == null) {
                return "";
            }
            String out = PLAIN_SERIALIZER.serialize(papiValue).trim();
            if (out.equalsIgnoreCase(placeholder)) {
                return "";
            }
            return out.toLowerCase(Locale.ROOT);
        }
        catch (Exception e) {
            return "";
        }
    }

    static {
        PLAIN_SERIALIZER = PlainTextComponentSerializer.plainText();
    }

    private static final class SortEngine {
        private final List<SortRule> rules = new ArrayList<SortRule>();

        private SortEngine() {
        }

        void prepare(List<org.bukkit.entity.Player> players) {
            for (SortRule rule : this.rules) {
                rule.prepare(players);
            }
        }

        Comparator<org.bukkit.entity.Player> comparator() {
            if (this.rules.isEmpty()) {
                return Comparator.comparing(org.bukkit.entity.Player::getName, String.CASE_INSENSITIVE_ORDER);
            }
            return (a, b) -> {
                for (SortRule rule : this.rules) {
                    int c = rule.compare((org.bukkit.entity.Player)a, (org.bukkit.entity.Player)b);
                    if (c == 0) continue;
                    return c;
                }
                return String.CASE_INSENSITIVE_ORDER.compare(a.getName().toLowerCase(Locale.ROOT), b.getName().toLowerCase(Locale.ROOT));
            };
        }
    }

    private final class PlaceholderOrderRule
    implements SortRule {
        private final String placeholder;
        private final List<String> explicitOrder;
        private final Map<String, Integer> orderIndex;
        private final Map<UUID, String> values = new HashMap<UUID, String>();

        private PlaceholderOrderRule(String placeholder, List<String> order) {
            this.placeholder = placeholder.toLowerCase(Locale.ROOT);
            this.explicitOrder = order == null ? Collections.emptyList() : new ArrayList();
            this.orderIndex = new HashMap<String, Integer>();
            if (order != null) {
                for (int i = 0; i < order.size(); ++i) {
                    String val = order.get(i) == null ? "" : order.get(i).toLowerCase(Locale.ROOT);
                    this.explicitOrder.add(val);
                    this.orderIndex.put(val, i);
                }
            }
        }

        @Override
        public void prepare(List<org.bukkit.entity.Player> players) {
            this.values.clear();
            for (org.bukkit.entity.Player p : players) {
                String v = TabHandler.this.resolvePlaceholderAsString(this.placeholder, p);
                this.values.put(p.getUniqueId(), v == null ? "" : v.toLowerCase(Locale.ROOT));
            }
        }

        @Override
        public int compare(org.bukkit.entity.Player a, org.bukkit.entity.Player b) {
            Integer ib;
            String va = this.values.getOrDefault(a.getUniqueId(), "");
            String vb = this.values.getOrDefault(b.getUniqueId(), "");
            Integer ia = this.lookupIndex(va);
            if (!ia.equals(ib = this.lookupIndex(vb))) {
                return Integer.compare(ia, ib);
            }
            return va.compareTo(vb);
        }

        private Integer lookupIndex(String v) {
            if (v == null) {
                return this.explicitOrder.size();
            }
            Integer idx = this.orderIndex.get(v);
            return idx != null ? idx.intValue() : this.explicitOrder.size();
        }

        @Override
        public String describe() {
            return "placeholder(type=order, placeholder=" + this.placeholder + ", order=" + String.valueOf(this.explicitOrder) + ")";
        }
    }

    private static final class GroupOrderRule
    implements SortRule {
        private final List<String> explicitOrder;
        private final Map<String, Integer> orderIndex;
        private final Map<UUID, List<String>> playerGroups = new HashMap<UUID, List<String>>();

        private GroupOrderRule(List<String> order) {
            this.explicitOrder = order == null ? Collections.emptyList() : new ArrayList();
            this.orderIndex = new HashMap<String, Integer>();
            if (order != null) {
                for (int i = 0; i < order.size(); ++i) {
                    String val = order.get(i) == null ? "" : order.get(i).toLowerCase(Locale.ROOT);
                    this.explicitOrder.add(val);
                    this.orderIndex.put(val, i);
                }
            }
        }

        @Override
        public void prepare(List<org.bukkit.entity.Player> players) {
            this.playerGroups.clear();
            for (org.bukkit.entity.Player p : players) {
                List<String> groups = GroupOrderRule.extractGroups(p);
                ArrayList<String> lowerGroups = new ArrayList<String>(groups.size());
                for (String g : groups) {
                    lowerGroups.add(g.toLowerCase(Locale.ROOT));
                }
                this.playerGroups.put(p.getUniqueId(), lowerGroups);
            }
        }

        @Override
        public int compare(org.bukkit.entity.Player a, org.bukkit.entity.Player b) {
            int ib;
            int ia = this.firstMatchIndex(this.playerGroups.getOrDefault(a.getUniqueId(), Collections.emptyList()));
            if (ia != (ib = this.firstMatchIndex(this.playerGroups.getOrDefault(b.getUniqueId(), Collections.emptyList())))) {
                return Integer.compare(ia, ib);
            }
            String ga = GroupOrderRule.firstGroupName(this.playerGroups.get(a.getUniqueId()));
            String gb = GroupOrderRule.firstGroupName(this.playerGroups.get(b.getUniqueId()));
            return ga.compareTo(gb);
        }

        private int firstMatchIndex(List<String> groups) {
            if (groups == null || groups.isEmpty()) {
                return this.explicitOrder.size();
            }
            for (String g : groups) {
                Integer idx = this.orderIndex.get(g);
                if (idx == null) continue;
                return idx;
            }
            return this.explicitOrder.size();
        }

        private static String firstGroupName(List<String> groups) {
            if (groups == null || groups.isEmpty()) {
                return "";
            }
            return groups.get(0);
        }

        private static List<String> extractGroups(org.bukkit.entity.Player p) {
            LinkedHashSet<String> groups = new LinkedHashSet<String>();
            for (PermissionAttachmentInfo pai : p.getEffectivePermissions()) {
                String perm = pai.getPermission();
                if (perm == null) continue;
                String lower = perm.toLowerCase(Locale.ROOT);
                if (lower.startsWith("group.") && lower.length() > 6) {
                    groups.add(lower.substring("group.".length()));
                    continue;
                }
                if (!lower.startsWith("luckperms.group.") || lower.length() <= "luckperms.group.".length()) continue;
                groups.add(lower.substring("luckperms.group.".length()));
            }
            return new ArrayList<String>(groups);
        }

        @Override
        public String describe() {
            return "group(order=" + String.valueOf(this.explicitOrder) + ")";
        }
    }

    private final class PlaceholderAlphaRule
    implements SortRule {
        private final String placeholder;
        private final boolean asc;
        private final Map<UUID, String> values = new HashMap<UUID, String>();

        private PlaceholderAlphaRule(String placeholder, boolean asc) {
            this.placeholder = placeholder.toLowerCase(Locale.ROOT);
            this.asc = asc;
        }

        @Override
        public void prepare(List<org.bukkit.entity.Player> players) {
            this.values.clear();
            for (org.bukkit.entity.Player p : players) {
                String v;
                if ("%player%".equalsIgnoreCase(this.placeholder.trim())) {
                    v = p.getName().toLowerCase(Locale.ROOT);
                } else {
                    v = TabHandler.this.resolvePlaceholderAsString(this.placeholder, p);
                    if (v != null && v.trim().equalsIgnoreCase(this.placeholder.trim())) {
                        v = "";
                    } else if (v != null) {
                        v = v.toLowerCase(Locale.ROOT);
                    }
                }
                this.values.put(p.getUniqueId(), v == null ? "" : v);
            }
        }

        @Override
        public int compare(org.bukkit.entity.Player a, org.bukkit.entity.Player b) {
            boolean bEmpty;
            String va = this.values.getOrDefault(a.getUniqueId(), "");
            String vb = this.values.getOrDefault(b.getUniqueId(), "");
            boolean aEmpty = va == null || va.isEmpty();
            boolean bl = bEmpty = vb == null || vb.isEmpty();
            if (aEmpty && bEmpty) {
                return 0;
            }
            if (aEmpty != bEmpty) {
                return aEmpty ? 1 : -1;
            }
            int cmp = va.compareTo(vb);
            return this.asc ? cmp : -cmp;
        }

        @Override
        public String describe() {
            return "placeholder_a_to_z(placeholder=" + this.placeholder + ", order=" + (this.asc ? "asc" : "desc") + ")";
        }
    }

    private static interface SortRule {
        public void prepare(List<org.bukkit.entity.Player> var1);

        public int compare(org.bukkit.entity.Player var1, org.bukkit.entity.Player var2);

        public String describe();
    }
}

