/*
 * Decompiled with CFR 0.152.
 */
package com.lyttledev.lyttletab.handlers;

import com.lyttledev.lyttletab.LyttleTab;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class BossbarHandler
implements Listener {
    public static LyttleTab plugin;
    HashMap<UUID, BossBar> bossBars = new HashMap();

    public BossbarHandler(LyttleTab plugin) {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        BossbarHandler.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.setBossbar(player);
    }

    public void refreshBossbar() {
        plugin.getServer().getOnlinePlayers().forEach(player -> {
            if (this.bossBars.containsKey(player.getUniqueId())) {
                UUID uuid = player.getUniqueId();
                BossBar bossBar = this.bossBars.get(uuid);
                player.hideBossBar(bossBar);
                this.bossBars.remove(uuid);
            }
            this.setBossbar((Player)player);
        });
    }

    public Component getMessage(List<String> messages, int index, Player player) {
        if (index < 0 || index >= messages.size()) {
            index = messages.size() - 1;
        }
        try {
            return BossbarHandler.plugin.message.getMessageRaw(messages.get(index), player);
        }
        catch (Exception e) {
            return BossbarHandler.plugin.message.getMessage("bossbar", player);
        }
    }

    public BossBar.Color getColor(List<String> colors, int index) {
        if (index < 0 || index >= colors.size()) {
            index = colors.size() - 1;
        }
        String color = colors.get(index).toUpperCase();
        switch (color.toUpperCase()) {
            case "BLUE": {
                return BossBar.Color.BLUE;
            }
            case "RED": {
                return BossBar.Color.RED;
            }
            case "PINK": {
                return BossBar.Color.PINK;
            }
            case "GREEN": {
                return BossBar.Color.GREEN;
            }
            case "PURPLE": {
                return BossBar.Color.PURPLE;
            }
            case "WHITE": {
                return BossBar.Color.WHITE;
            }
            case "YELLOW": {
                return BossBar.Color.YELLOW;
            }
        }
        return BossBar.Color.WHITE;
    }

    public float getProgress(List<String> percentages, int index) {
        if (index < 0 || index >= percentages.size()) {
            index = percentages.size() - 1;
        }
        String fillPercentage = percentages.get(index);
        return Float.parseFloat(String.valueOf(fillPercentage)) / 100.0f;
    }

    public BossBar.Overlay getOverlay(List<String> overlays, int index) {
        if (index < 0 || index >= overlays.size()) {
            index = overlays.size() - 1;
        }
        String color = overlays.get(index).toUpperCase();
        switch (color.toUpperCase()) {
            case "2": 
            case "6": 
            case "NOTCHED_6": {
                return BossBar.Overlay.NOTCHED_6;
            }
            case "3": 
            case "10": 
            case "NOTCHED_10": {
                return BossBar.Overlay.NOTCHED_10;
            }
            case "4": 
            case "12": 
            case "NOTCHED_12": {
                return BossBar.Overlay.NOTCHED_12;
            }
            case "5": 
            case "20": 
            case "NOTCHED_20": {
                return BossBar.Overlay.NOTCHED_20;
            }
        }
        return BossBar.Overlay.PROGRESS;
    }

    public void setBossbar(final Player player) {
        long interval;
        final List colors = (List)BossbarHandler.plugin.config.bossbar.get("bossbar_color");
        final List presentages = (List)BossbarHandler.plugin.config.bossbar.get("bossbar_fill_percentage");
        final List messages = (List)BossbarHandler.plugin.config.bossbar.get("bossbar_text");
        final List overlays = (List)BossbarHandler.plugin.config.bossbar.get("bossbar_overlay");
        Double intervalDouble = (Double)BossbarHandler.plugin.config.bossbar.get("bossbar_interval");
        int intervalInt = Math.toIntExact(Math.round(intervalDouble * 20.0));
        long l = interval = intervalInt > 0 ? (long)intervalInt : 100L;
        if (colors.isEmpty() || presentages.isEmpty() || messages.isEmpty() || overlays.isEmpty()) {
            plugin.getLogger().warning("Bossbar configuration is incomplete. Please check your config.");
            return;
        }
        final BossBar bossBar = BossBar.bossBar((Component)this.getMessage(messages, 0, player), (float)this.getProgress(presentages, 0), (BossBar.Color)this.getColor(colors, 0), (BossBar.Overlay)this.getOverlay(overlays, 0));
        player.showBossBar(bossBar);
        this.bossBars.put(player.getUniqueId(), bossBar);
        final int[] index = new int[]{0};
        new BukkitRunnable(){

            public void run() {
                if (player.isOnline()) {
                    index[0] = (index[0] + 1) % messages.size();
                    bossBar.name(BossbarHandler.this.getMessage(messages, index[0], player));
                    bossBar.color(BossbarHandler.this.getColor(colors, index[0]));
                    bossBar.progress(BossbarHandler.this.getProgress(presentages, index[0]));
                    bossBar.overlay(BossbarHandler.this.getOverlay(overlays, index[0]));
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)plugin, 0L, interval);
    }
}

