/*
 * Decompiled with CFR 0.152.
 */
package com.lyttledev.lyttletab.commands;

import com.lyttledev.lyttletab.LyttleTab;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.command.CommandSender;

public class LyttleTabCommand {
    private static LyttleTab plugin;

    public static void createCommand(LyttleTab lyttlePlugin, Commands commands) {
        plugin = lyttlePlugin;
        LiteralArgumentBuilder top = (LiteralArgumentBuilder)Commands.literal((String)"lyttletab").then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(source -> source.getSender().hasPermission("lyttletab.lyttletab.reload"))).executes(LyttleTabCommand::reloadNode));
        top.requires(source -> source.getSender().hasPermission("lyttletab.lyttletab"));
        top.executes(LyttleTabCommand::rootNode);
        commands.register(top.build(), "Admin command for the LyttleTab plugin");
    }

    private static int rootNode(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        TextComponent version = Component.text((String)("Plugin version: " + plugin.getDescription().getVersion()));
        LyttleTabCommand.plugin.message.sendMessageRaw(sender, (Component)version);
        return 1;
    }

    private static int reloadNode(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        LyttleTabCommand.plugin.config.reload();
        LyttleTabCommand.plugin.message.sendMessageRaw(sender, (Component)Component.text((String)"The config has been reloaded"));
        if (((Boolean)LyttleTabCommand.plugin.config.tab.get("tab_enabled")).booleanValue()) {
            LyttleTabCommand.plugin.tabHandler.reload();
        }
        if (((Boolean)LyttleTabCommand.plugin.config.bossbar.get("bossbar_enabled")).booleanValue()) {
            LyttleTabCommand.plugin.bossbarHandler.refreshBossbar();
        }
        return 1;
    }
}

