/*
 * Decompiled with CFR 0.152.
 */
package com.lyttledev.lyttletab;

import com.lyttledev.lyttletab.commands.LyttleTabCommand;
import com.lyttledev.lyttletab.handlers.BossbarHandler;
import com.lyttledev.lyttletab.handlers.TabHandler;
import com.lyttledev.lyttletab.types.Configs;
import com.lyttledev.lyttleutils.utils.communication.Console;
import com.lyttledev.lyttleutils.utils.communication.Message;
import com.lyttledev.lyttleutils.utils.storage.GlobalConfig;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.util.List;
import org.bukkit.plugin.java.JavaPlugin;

public final class LyttleTab
extends JavaPlugin {
    public Configs config;
    public Console console;
    public Message message;
    public GlobalConfig global;
    public TabHandler tabHandler;
    public BossbarHandler bossbarHandler;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = new Configs(this);
        this.global = new GlobalConfig(this);
        this.migrateConfig();
        this.console = new Console(this);
        this.message = new Message(this, this.config.messages, this.global);
        LifecycleEventManager manager = this.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            this.registerCommands(commands);
        });
        if (((Boolean)this.config.tab.get("tab_enabled")).booleanValue()) {
            this.tabHandler = new TabHandler(this);
        }
        if (((Boolean)this.config.bossbar.get("bossbar_enabled")).booleanValue()) {
            this.bossbarHandler = new BossbarHandler(this);
        }
    }

    public void registerCommands(Commands commands) {
        LyttleTabCommand.createCommand(this, commands);
    }

    public void saveDefaultConfig() {
        String configPath = "config.yml";
        if (!new File(this.getDataFolder(), configPath).exists()) {
            this.saveResource(configPath, false);
        }
        String messagesPath = "messages.yml";
        if (!new File(this.getDataFolder(), messagesPath).exists()) {
            this.saveResource(messagesPath, false);
        }
        String bossbarPath = "bossbar.yml";
        if (!new File(this.getDataFolder(), bossbarPath).exists()) {
            this.saveResource(bossbarPath, false);
        }
        String tabPath = "tab.yml";
        if (!new File(this.getDataFolder(), tabPath).exists()) {
            this.saveResource(tabPath, false);
        }
        String defaultPath = "#defaults/";
        String defaultGeneralPath = defaultPath + configPath;
        this.saveResource(defaultGeneralPath, true);
        String defaultMessagesPath = defaultPath + messagesPath;
        this.saveResource(defaultMessagesPath, true);
        String defaultBossbarPath = defaultPath + bossbarPath;
        this.saveResource(defaultBossbarPath, true);
        String defaultTabPath = defaultPath + tabPath;
        this.saveResource(defaultTabPath, true);
    }

    private void migrateConfig() {
        if (!this.config.general.contains("config_version")) {
            this.config.general.set("config_version", 0);
        }
        switch (this.config.general.get("config_version").toString()) {
            case "0": {
                this.config.tab.set("tab_list_refresh_interval", this.config.defaultTab.get("tab_list_refresh_interval"));
                this.config.general.set("config_version", 1);
                this.migrateConfig();
                break;
            }
            case "1": {
                this.config.tab.set("tab_list_header", List.of(this.config.tab.get("tab_list_header")));
                this.config.tab.set("tab_list_footer", List.of(this.config.tab.get("tab_list_footer")));
                this.config.tab.set("tab_list_animation_interval", this.config.defaultTab.get("tab_list_animation_interval"));
                this.config.tab.set("sorting", this.config.defaultTab.get("sorting"));
                this.config.tab.set("tab_hide_on_invisibility_potion", this.config.defaultTab.get("tab_hide_on_invisibility_potion"));
                this.config.general.set("config_version", 2);
                this.migrateConfig();
                break;
            }
        }
    }
}

