/*
 * Decompiled with CFR 0.152.
 */
package me.lukiiy.wildTag;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import me.lukiiy.wildTag.Cmd;
import me.lukiiy.wildTag.Listen;
import me.lukiiy.wildTag.Match;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class WildTag
extends JavaPlugin {
    public final Random rng = ThreadLocalRandom.current();

    public void onEnable() {
        this.setupConfig();
        this.getServer().getPluginManager().registerEvents((Listener)new Listen(), (Plugin)this);
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, it -> ((Commands)it.registrar()).register(Cmd.INSTANCE.register(), "WildTag main command"));
    }

    public void onDisable() {
        this.endAll();
    }

    public static WildTag getInstance() {
        return (WildTag)JavaPlugin.getPlugin(WildTag.class);
    }

    public void setupConfig() {
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
    }

    public Map<World, Match> getMatches() {
        return Match.getMatches();
    }

    public Match getMatch(World world) {
        return this.getMatches().get(world);
    }

    public Match getMatch(Player player) {
        Match match = this.getMatch(player.getWorld());
        if (match != null && match.players.get(player) != null) {
            return match;
        }
        return null;
    }

    public Location randomLocation(World world) {
        int range = this.getConfig().getInt("mapSearchRange");
        int cX = this.rng.nextInt(range * 2) - range;
        int cZ = this.rng.nextInt(range * 2) - range;
        int cY = world.getHighestBlockYAt(cX, cZ);
        return new Location(world, (double)cX, (double)cY, (double)cZ);
    }

    public void endAll() {
        Match.getMatches().values().forEach(Match::end);
    }

    public static boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

