/*
 * Decompiled with CFR 0.152.
 */
package me.lukiiy.wildTag;

import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.LodestoneTracker;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import me.lukiiy.wayTrick.WayTrick;
import me.lukiiy.wildTag.Kit;
import me.lukiiy.wildTag.WildTag;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.minecraft.SharedConstants;
import net.minecraft.world.waypoints.Waypoint;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.GameRule;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Match {
    private static final Map<World, Match> ACTIVE = new HashMap<World, Match>();
    public final Map<Player, Teams> players = new HashMap<Player, Teams>();
    private final long timerFull;
    public long timer;
    public final Location center;
    public final World world;
    public final BossBar bar;
    private final Location ogCenter;
    private final double ogSize;
    private ScheduledTask task;
    private WayTrick fakeLocators;
    private boolean originalLocatorRule = false;
    private static final Kit defaultKit = new Kit(ItemStack.of((Material)Material.DIAMOND_PICKAXE), ItemStack.of((Material)Material.DIAMOND_AXE), ItemStack.of((Material)Material.DIAMOND_SHOVEL), ItemStack.of((Material)Material.COBBLESTONE, (int)16));
    private static final Kit hunterKit = new Kit(Match.getTracker());

    Match(@NotNull List<Player> players, @NotNull World world, @Nullable Location center, double size, long seconds, @Nullable List<Player> hunters) {
        if (players.size() < 2) {
            throw new IllegalArgumentException("Not enough players to start a match.");
        }
        if (ACTIVE.containsKey(world)) {
            throw new IllegalArgumentException("This world already has a running match.");
        }
        if (center != null && center.getWorld() != world) {
            throw new IllegalArgumentException("The center is in another world.");
        }
        WildTag tag = WildTag.getInstance();
        ACTIVE.put(world, this);
        tag.getComponentLogger().info(Component.text((String)("Starting tag match on world " + world.getName() + "!")).color((TextColor)NamedTextColor.GOLD));
        this.world = world;
        for (Player p : players) {
            this.players.put(p, Teams.RUNNER);
        }
        if (hunters == null || hunters.isEmpty()) {
            this.players.put(players.get(tag.rng.nextInt(players.size())), Teams.HUNTER);
        } else {
            hunters.forEach(h -> this.players.put((Player)h, Teams.HUNTER));
        }
        WorldBorder border = world.getWorldBorder();
        this.ogCenter = border.getCenter();
        this.ogSize = border.getSize();
        long morePlayerTimer = tag.getConfig().getLong("morePlayerTimer", 0L);
        if (players.size() > 2 && morePlayerTimer != 0L) {
            seconds += morePlayerTimer * (long)(players.size() - 2);
        }
        this.timerFull = this.timer = seconds;
        this.bar = BossBar.bossBar((Component)Component.text((String)(this.timer + " seconds")), (float)1.0f, (BossBar.Color)BossBar.Color.GREEN, (BossBar.Overlay)BossBar.Overlay.PROGRESS);
        this.center = center == null ? tag.randomLocation(world) : center;
        List<Location> spawns = Match.getSpawns(this.center, size, players.size());
        AtomicInteger ready = new AtomicInteger(0);
        if (SharedConstants.getProtocolVersion() >= 771) {
            this.originalLocatorRule = Boolean.TRUE.equals(world.getGameRuleValue(GameRule.LOCATOR_BAR));
            Bukkit.getGlobalRegionScheduler().execute((Plugin)WildTag.getInstance(), () -> {
                world.setGameRule(GameRule.LOCATOR_BAR, (Object)false);
                if (WildTag.getInstance().getConfig().getBoolean("trackers.locatorBar")) {
                    this.fakeLocators = new WayTrick();
                }
            });
        }
        for (int i = 0; i < players.size(); ++i) {
            Player p = players.get(i);
            Location spawn = spawns.get(i);
            p.teleportAsync(spawn).thenAccept(success -> {
                if (!success.booleanValue()) {
                    return;
                }
                p.sendActionBar((Component)Component.text((String)"Preparing terrain..."));
                this.isChunkReady(spawn).thenRun(() -> {
                    if (ready.incrementAndGet() == players.size()) {
                        this.start(players, size);
                    }
                });
            });
        }
    }

    public void start(List<Player> players, double size) {
        WorldBorder border = this.world.getWorldBorder();
        border.setCenter(this.center);
        border.setSize(size);
        for (Player p : players) {
            this.preparePlayer(p);
            this.bar.addViewer((Audience)p);
            p.playSound((Entity)p, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.0f);
        }
        this.setupWaypoints();
        this.task = Bukkit.getGlobalRegionScheduler().runAtFixedRate((Plugin)WildTag.getInstance(), task -> {
            if (this.timer == 0L) {
                this.end(this.getPlayers(Teams.RUNNER));
                return;
            }
            if (players.isEmpty() || players.size() == 1) {
                this.end();
                return;
            }
            if (this.timer < 16L) {
                players.forEach(p -> p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BIT, 1.0f, 1.0f));
                this.bar.color(BossBar.Color.RED);
            }
            if (this.timer == this.timerFull / 2L) {
                this.bar.color(BossBar.Color.YELLOW);
            }
            --this.timer;
            this.bar.name((Component)Component.text((String)(this.timer + " seconds")));
            this.bar.progress((float)this.timer / (float)this.timerFull);
            for (Player p2 : players) {
                if (this.getPlayers(Teams.HUNTER).contains(p2)) {
                    Component text = Component.text((String)"Catch them all!").color(TextColor.color((int)16753079));
                    if (this.timer > this.timerFull - 5L) {
                        text = Component.text((String)"Remember to use the compass!").color(TextColor.color((int)16745047));
                    }
                    p2.sendActionBar(text);
                    continue;
                }
                p2.sendActionBar(Component.text((String)"Run away from ").append(Component.join((JoinConfiguration)JoinConfiguration.commas((boolean)true), this.getPlayers(Teams.HUNTER).stream().map(CommandSender::name).toList())));
            }
            if (this.fakeLocators != null) {
                this.fakeLocators.updateAll();
            }
        }, 1L, 20L);
    }

    public void end(List<Player> winners) {
        ACTIVE.remove(this.world);
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
        WorldBorder border = this.world.getWorldBorder();
        border.setCenter(this.ogCenter);
        border.setSize(this.ogSize);
        if (WildTag.getInstance().getConfig().getBoolean("trackers.locatorBar") && this.fakeLocators != null) {
            this.fakeLocators.clear();
        }
        if (WildTag.isFolia()) {
            Bukkit.getGlobalRegionScheduler().execute((Plugin)WildTag.getInstance(), () -> this.world.setGameRule(GameRule.LOCATOR_BAR, (Object)this.originalLocatorRule));
        } else {
            this.world.setGameRule(GameRule.LOCATOR_BAR, (Object)this.originalLocatorRule);
        }
        ArrayList players = new ArrayList(this.world.getPlayers());
        players.forEach(p -> {
            this.bar.removeViewer((Audience)p);
            if (this.getPlayers(Teams.HUNTER).contains(p)) {
                p.getInventory().remove(Material.COMPASS);
            }
            if (winners == null || winners.isEmpty()) {
                p.sendMessage(((TextComponent)Component.text((String)"Nobody won...").color(TextColor.color((int)11018031))).decorate(TextDecoration.ITALIC));
            } else {
                Component list = Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.text((String)", ")), winners.stream().map(CommandSender::name).toList());
                p.sendMessage(list.append(((TextComponent)Component.text((String)" won!").color(TextColor.color((int)1048403))).decorate(TextDecoration.BOLD)));
            }
            if (p.getGameMode() == GameMode.SPECTATOR) {
                Location pLoc = p.getLocation();
                p.teleportAsync(new Location(this.world, pLoc.getX(), (double)(this.world.getHighestBlockYAt(pLoc.getBlockX(), pLoc.getBlockZ()) + 1), pLoc.getZ()));
                p.setGameMode(GameMode.SURVIVAL);
            }
            p.playSound(p.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.0f);
            p.sendActionBar((Component)Component.empty());
        });
    }

    public void end() {
        this.end(Collections.emptyList());
    }

    public void eliminate(Player p) {
        this.players.put(p, Teams.SPECTATOR);
        if (this.fakeLocators != null) {
            this.fakeLocators.untrackTarget(p);
        }
        if (this.getPlayers(Teams.RUNNER).isEmpty()) {
            this.end(this.getPlayers(Teams.HUNTER));
            return;
        }
        if (this.getPlayers(Teams.HUNTER).isEmpty()) {
            this.end(this.getPlayers(Teams.RUNNER));
            return;
        }
        this.uncastInfo(p);
    }

    public void castInfo(Player p) {
        p.sendMessage((Component)Component.newline());
        p.sendMessage(((TextComponent)Component.text((String)"Runners: ").color((TextColor)NamedTextColor.YELLOW)).append(Component.join((JoinConfiguration)JoinConfiguration.commas((boolean)true), this.getPlayers(Teams.RUNNER).stream().map(Player::displayName).toList())));
        p.sendMessage(((TextComponent)Component.text((String)"Hunter: ").color((TextColor)NamedTextColor.YELLOW)).append(Component.join((JoinConfiguration)JoinConfiguration.commas((boolean)true), this.getPlayers(Teams.HUNTER).stream().map(Player::displayName).toList())));
        p.sendMessage((Component)Component.newline());
        this.bar.addViewer((Audience)p);
    }

    public void uncastInfo(Player p) {
        this.bar.removeViewer((Audience)p);
    }

    public List<Player> getPlayers(Teams team) {
        return this.players.entrySet().stream().filter(entry -> entry.getValue() == team).map(Map.Entry::getKey).filter(OfflinePlayer::isOnline).toList();
    }

    private static List<Location> getSpawns(Location center, double borderSize, int pSize) {
        if (center == null || center.getWorld() == null) {
            return List.of();
        }
        ArrayList<Location> pos = new ArrayList<Location>();
        World world = center.getWorld();
        double radius = borderSize / 2.0 - 8.0;
        int minY = world.getMinHeight();
        while (pos.size() < pSize) {
            int x1 = (int)(center.getX() + radius);
            int x2 = (int)(center.getX() - radius);
            int z1 = (int)(center.getZ() + radius);
            int z2 = (int)(center.getZ() - radius);
            int y_ne = Match.getValidY(world, x1, z1);
            int y_nw = Match.getValidY(world, x2, z1);
            int y_se = Match.getValidY(world, x1, z2);
            int y_sw = Match.getValidY(world, x2, z2);
            if (y_ne == minY && y_nw == minY && y_se == minY && y_sw == minY) {
                y_se = y_sw = WildTag.getInstance().rng.nextInt(32, 96);
                y_nw = y_sw;
                y_ne = y_sw;
            }
            pos.add(new Location(world, (double)x1 + 0.5, (double)(y_ne + 1), (double)z1 + 0.5));
            if (pos.size() < pSize) {
                pos.add(new Location(world, (double)x2 + 0.5, (double)(y_sw + 1), (double)z2 + 0.5));
            }
            if (pos.size() < pSize) {
                pos.add(new Location(world, (double)x2 + 0.5, (double)(y_nw + 1), (double)z1 + 0.5));
            }
            if (pos.size() < pSize) {
                pos.add(new Location(world, (double)x1 + 0.5, (double)(y_se + 1), (double)z2 + 0.5));
            }
            radius -= 12.0;
        }
        Collections.shuffle(pos);
        return pos;
    }

    private static int getValidY(World world, int x, int z) {
        int y = world.getHighestBlockYAt(x, z);
        int maxY = world.getMaxHeight();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            int fallbackY = maxY / 2;
            for (y = world.getMinHeight(); y < maxY; ++y) {
                if (!world.getBlockAt(x, y, z).isPassable()) continue;
                y = Match.avoidLiquid(world.getBlockAt(x, y, z), maxY);
                return y;
            }
            world.getBlockAt(x, fallbackY, z).setType(Material.AIR);
            return fallbackY;
        }
        y = Match.avoidLiquid(world.getBlockAt(x, y, z), maxY);
        return y;
    }

    private static int avoidLiquid(Block b, int maxY) {
        int y = b.getY();
        if (b.isLiquid()) {
            while (b.isLiquid() && y < maxY) {
                b = b.getWorld().getBlockAt(b.getX(), ++y, b.getZ());
            }
            --y;
        }
        return y;
    }

    private static ItemStack getTracker() {
        if (!WildTag.getInstance().getConfig().getBoolean("trackers.compass")) {
            return ItemStack.empty();
        }
        ItemStack compass = ItemStack.of((Material)Material.COMPASS);
        compass.setData(DataComponentTypes.CUSTOM_NAME, (Object)Component.text((String)"Tracker").decoration(TextDecoration.ITALIC, TextDecoration.State.FALSE));
        compass.setData(DataComponentTypes.ENCHANTMENT_GLINT_OVERRIDE, (Object)false);
        return compass;
    }

    private void preparePlayer(Player p) {
        AttributeInstance h = p.getAttribute(Attribute.MAX_HEALTH);
        if (h != null) {
            p.setHealth(h.getValue());
        }
        Block pBlock = p.getLocation().getBlock();
        pBlock.setType(Material.AIR);
        pBlock.getRelative(BlockFace.UP).setType(Material.AIR);
        Block blockBelow = pBlock.getRelative(BlockFace.DOWN);
        if (blockBelow.isEmpty() || blockBelow.isLiquid()) {
            blockBelow.setType(Material.GLASS);
        }
        p.setVelocity(new Vector(0, 0, 0));
        p.setGameMode(GameMode.SURVIVAL);
        p.setFoodLevel(20);
        p.setFireTicks(0);
        p.setSaturation(5.0f);
        p.setRemainingAir(p.getMaximumAir());
        p.getActivePotionEffects().forEach(potion -> p.removePotionEffect(potion.getType()));
        p.setFallDistance(0.0f);
        p.resetTitle();
        PlayerInventory pInv = p.getInventory();
        pInv.clear();
        defaultKit.apply(pInv);
        if (this.getPlayers(Teams.HUNTER).contains(p)) {
            hunterKit.apply(pInv);
        }
        this.getPlayers(Teams.HUNTER).forEach(hunter -> hunter.getScheduler().run((Plugin)WildTag.getInstance(), task -> this.getNearestRunner((Player)hunter), null));
    }

    public Player getNearestRunner(Player p) {
        Player nearest = this.getPlayers(Teams.RUNNER).stream().filter(Entity::isValid).min(Comparator.comparingDouble(targets -> targets.getLocation().distanceSquared(p.getLocation()))).orElse(null);
        if (nearest == null) {
            return null;
        }
        Arrays.stream(p.getInventory().getContents()).filter(Objects::nonNull).filter(item -> item.getType() == Material.COMPASS).forEach(compass -> compass.setData(DataComponentTypes.LODESTONE_TRACKER, (Object)((LodestoneTracker)LodestoneTracker.lodestoneTracker().location(nearest.getLocation()).tracked(false).build())));
        return nearest;
    }

    private void setupWaypoints() {
        if (this.fakeLocators == null) {
            return;
        }
        Waypoint.Icon runnerStyle = new Waypoint.Icon();
        runnerStyle.color = Optional.of(0xFFFFFF);
        this.getPlayers(Teams.HUNTER).forEach(this.fakeLocators::addViewer);
        this.getPlayers(Teams.RUNNER).forEach(runner -> this.fakeLocators.trackTarget((Player)runner, runnerStyle));
    }

    private CompletableFuture<Void> isChunkReady(Location location) {
        if (location.getWorld() == null) {
            return CompletableFuture.completedFuture(null);
        }
        Chunk chunk = location.getChunk();
        if (chunk.isLoaded()) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        chunk.getWorld().getChunkAtAsync(chunk.getX(), chunk.getZ(), true).thenAccept(c -> future.complete(null));
        return future;
    }

    public static Map<World, Match> getMatches() {
        return Collections.unmodifiableMap(ACTIVE);
    }

    public static enum Teams {
        RUNNER,
        HUNTER,
        SPECTATOR;

    }
}

