/*
 * Decompiled with CFR 0.152.
 */
package me.lukiiy.wildTag;

import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import me.lukiiy.wildTag.Kit;
import me.lukiiy.wildTag.Match;
import me.lukiiy.wildTag.WildTag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minecraft.SharedConstants;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class Listen
implements Listener {
    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void hit(EntityDamageByEntityEvent e) {
        Player player;
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player attacked = (Player)entity;
        Match match = WildTag.getInstance().getMatch(attacked);
        if (match == null) {
            return;
        }
        Entity entity2 = e.getDamager();
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, Projectile.class}, (Object)entity3, n)) {
                case 0: {
                    Player p;
                    player = p = (Player)entity3;
                    break block4;
                }
                case 1: {
                    Projectile proj = (Projectile)entity3;
                    ProjectileSource projectileSource = proj.getShooter();
                    if (!(projectileSource instanceof Player)) {
                        n = 2;
                        continue block4;
                    }
                    Player shooter = (Player)projectileSource;
                    player = shooter;
                    break block4;
                }
                default: {
                    player = null;
                    break block4;
                }
            }
            break;
        }
        Player damager = player;
        if (damager == null) {
            return;
        }
        List<Player> runners = match.getPlayers(Match.Teams.RUNNER);
        List<Player> hunters = match.getPlayers(Match.Teams.HUNTER);
        if (runners.contains(damager) || Kit.isKitItem(damager.getInventory().getItemInMainHand())) {
            e.setDamage(0.0);
        }
        if (hunters.contains(damager) && runners.contains(attacked)) {
            if (runners.size() == 1) {
                match.eliminate(attacked);
                return;
            }
            e.setDamage(attacked.getHealth() + 1.0);
            hunters.forEach(h -> h.getScheduler().run((Plugin)WildTag.getInstance(), task -> match.getNearestRunner((Player)h), null));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void projPickup(PlayerPickupArrowEvent e) {
        ProjectileSource projectileSource = e.getArrow().getShooter();
        if (!(projectileSource instanceof Player)) {
            return;
        }
        Player shooter = (Player)projectileSource;
        Match match = WildTag.getInstance().getMatch(shooter);
        if (match == null) {
            return;
        }
        List<Player> hunters = match.getPlayers(Match.Teams.HUNTER);
        if (hunters.contains(shooter) && !hunters.contains(e.getPlayer())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void death(PlayerDeathEvent e) {
        e.getDrops().removeIf(Kit::isKitItem);
        Player p = e.getEntity();
        Match match = WildTag.getInstance().getMatch(p);
        if (match == null) {
            return;
        }
        match.eliminate(p);
        p.getScheduler().execute((Plugin)WildTag.getInstance(), () -> {
            if (match.players.size() <= 1) {
                return;
            }
            p.spigot().respawn();
        }, null, 40L);
    }

    @EventHandler
    public void join(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        Match match = WildTag.getInstance().getMatch(p.getWorld());
        if (match == null) {
            return;
        }
        p.setGameMode(GameMode.SPECTATOR);
        p.teleportAsync(match.center);
        match.castInfo(p);
    }

    @EventHandler
    public void quit(PlayerQuitEvent e) {
        Player p = e.getPlayer();
        Match match = WildTag.getInstance().getMatch(p);
        if (match == null) {
            return;
        }
        match.eliminate(p);
    }

    @EventHandler
    public void food(FoodLevelChangeEvent e) {
        if (WildTag.getInstance().getMatch((Player)e.getEntity()) == null) {
            return;
        }
        e.setCancelled(true);
    }

    @EventHandler
    public void itemUse(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        Match match = WildTag.getInstance().getMatch(p);
        if (match == null) {
            return;
        }
        if ((p.getInventory().getItemInMainHand().getType() == Material.COMPASS || p.getInventory().getItemInOffHand().getType() == Material.COMPASS) && match.getPlayers(Match.Teams.HUNTER).contains(p) && p.getCooldown(Material.COMPASS) <= 0) {
            Player nearest = match.getNearestRunner(p);
            if (nearest == null) {
                return;
            }
            int fY = nearest.getLocation().getBlockY() - p.getLocation().getBlockY();
            String yDisplay = fY == 0 ? "" : "(y " + (String)(fY > 0 ? "+" + fY : String.valueOf(fY)) + ")";
            p.sendMessage(((TextComponent)((TextComponent)Component.text((String)"Pointing at ").append(nearest.name().color(TextColor.color((int)1048403)))).appendSpace()).append(Component.text((String)yDisplay).color(TextColor.color((int)16514915))));
            p.setCooldown(Material.COMPASS, 5);
            e.setUseInteractedBlock(Event.Result.DENY);
            return;
        }
        if (e.hasBlock() && e.getClickedBlock() != null && e.getClickedBlock().getType() == Material.ENDER_CHEST) {
            p.sendActionBar((Component)Component.translatable((String)"container.isLocked").arguments(new ComponentLike[]{Component.translatable((String)"block.minecraft.ender_chest")}));
            if (SharedConstants.getProtocolVersion() > 773) {
                p.getWorld().playSound(e.getClickedBlock().getLocation(), Sound.BLOCK_CHEST_LOCKED, 1.0f, 1.0f);
            } else {
                p.playSound((Entity)p, Sound.BLOCK_CHEST_LOCKED, 1.0f, 1.0f);
            }
            e.setUseInteractedBlock(Event.Result.DENY);
        }
    }

    @EventHandler
    public void drop(PlayerDropItemEvent e) {
        Match match = WildTag.getInstance().getMatch(e.getPlayer());
        if (Kit.isKitItem(e.getItemDrop().getItemStack())) {
            if (match != null) {
                e.setCancelled(true);
            } else {
                e.getItemDrop().remove();
            }
        }
    }

    @EventHandler
    public void worldChange(PlayerChangedWorldEvent e) {
        Player p = e.getPlayer();
        Match matchFrom = WildTag.getInstance().getMatch(e.getFrom());
        Match matchTo = WildTag.getInstance().getMatch(p.getWorld());
        if (matchFrom != null && matchFrom.getPlayers(Match.Teams.RUNNER).contains(p)) {
            matchFrom.world.getPlayers().forEach(mP -> mP.sendMessage((Component)Component.translatable((String)"death.attack.outsideBorder", (ComponentLike[])new ComponentLike[]{p.name()})));
            p.sendMessage(Component.text((String)"You got eliminated because you changed worlds!").color((TextColor)NamedTextColor.RED));
            matchFrom.eliminate(p);
        }
        if (matchTo != null) {
            p.sendMessage(Component.text((String)"This world has an on-going tag match!").color((TextColor)NamedTextColor.YELLOW));
            p.setGameMode(GameMode.SPECTATOR);
            p.teleportAsync(matchTo.center);
            matchTo.castInfo(p);
        }
    }

    @EventHandler
    public void respawn(PlayerPostRespawnEvent e) {
        Player p = e.getPlayer();
        Location loc = p.getLastDeathLocation();
        if (loc == null || !loc.isChunkLoaded()) {
            return;
        }
        Match match = WildTag.getInstance().getMatch(loc.getWorld());
        if (match == null) {
            return;
        }
        p.teleportAsync(match.center).thenAccept(s -> {
            if (s.booleanValue()) {
                p.setGameMode(GameMode.SPECTATOR);
            }
        });
    }
}

