/*
 * Decompiled with CFR 0.152.
 */
package me.lukiiy.wayTrick;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import me.lukiiy.wayTrick.NMSUtils;
import me.lukiiy.wayTrick.TrackedTarget;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTrackedWaypointPacket;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.waypoints.Waypoint;
import org.bukkit.entity.Player;

public class WayTrick {
    private final Map<UUID, TrackedTarget> targets = new HashMap<UUID, TrackedTarget>();
    private final Set<Player> viewers = new HashSet<Player>();

    public void addViewer(Player viewer) {
        this.viewers.add(viewer);
        this.targets.values().forEach(t -> t.sendWaypoint(viewer));
    }

    public void removeViewer(Player viewer) {
        this.viewers.remove(viewer);
        for (Map.Entry<UUID, TrackedTarget> e : this.targets.entrySet()) {
            e.getValue().clear(viewer);
            this.removeWaypoint(viewer, e.getKey());
        }
    }

    public void trackTarget(Player target, Waypoint.Icon style) {
        UUID targetId = target.getUniqueId();
        TrackedTarget tracked = new TrackedTarget(target, style, null);
        this.targets.put(targetId, tracked);
        this.viewers.forEach(tracked::sendWaypoint);
    }

    public void trackTarget(Player target, Waypoint.Icon style, BiFunction<Player, Player, Vec3> positionMethod) {
        UUID targetId = target.getUniqueId();
        TrackedTarget tracked = new TrackedTarget(target, style, positionMethod);
        this.targets.put(targetId, tracked);
        this.viewers.forEach(tracked::sendWaypoint);
    }

    public void untrackTarget(Player target) {
        UUID id = target.getUniqueId();
        TrackedTarget tracked = this.targets.remove(id);
        if (tracked == null) {
            return;
        }
        Set<Player> viewersSnapshot = Set.copyOf(this.viewers);
        viewersSnapshot.forEach(viewer -> {
            tracked.clear((Player)viewer);
            this.removeWaypoint((Player)viewer, id);
        });
    }

    public void updateAll() {
        Set<Player> viewerSnapshot = Set.copyOf(this.viewers);
        List<TrackedTarget> targets = List.copyOf(this.targets.values());
        targets.forEach(t -> t.update(viewerSnapshot));
    }

    public void clear() {
        this.targets.keySet().forEach(id -> this.viewers.forEach(viewer -> this.removeWaypoint((Player)viewer, (UUID)id)));
        this.targets.clear();
        this.viewers.clear();
    }

    private void removeWaypoint(Player viewer, UUID targetId) {
        NMSUtils.handler((Player)viewer).connection.send((Packet)ClientboundTrackedWaypointPacket.removeWaypoint((UUID)targetId));
    }
}

