/*
 * Decompiled with CFR 0.152.
 */
package me.lukiiy.wayTrick;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import me.lukiiy.wayTrick.NMSUtils;
import me.lukiiy.wayTrick.ViewerState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTrackedWaypointPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.waypoints.Waypoint;
import net.minecraft.world.waypoints.WaypointTransmitter;
import org.bukkit.entity.Player;

class TrackedTarget {
    private final Player target;
    private final Waypoint.Icon style;
    private final BiFunction<Player, Player, Vec3> positionFun;
    private final Map<Player, ViewerState> viewerState = new HashMap<Player, ViewerState>();
    private static final float VERY_FAR = 332.0f;
    private static final float AZIMUTH_ANGLE_THRESHOLD = (float)Math.PI / 360;

    TrackedTarget(Player target, Waypoint.Icon style, BiFunction<Player, Player, Vec3> positionMethod) {
        this.target = target;
        this.style = style;
        this.positionFun = positionMethod;
    }

    public void sendWaypoint(Player viewer) {
        ServerPlayer craftViewer = NMSUtils.handler(viewer);
        Vec3 targetPos = this.positionFun != null ? this.positionFun.apply(this.target, viewer) : NMSUtils.handler(this.target).position();
        BlockPos blockPos = BlockPos.containing((Position)targetPos);
        ChunkPos chunkPos = new ChunkPos(blockPos);
        UUID targetId = this.target.getUniqueId();
        ViewerState state = this.viewerState.computeIfAbsent(viewer, v -> new ViewerState());
        if (craftViewer.position().distanceTo(targetPos) > 332.0) {
            float angle = this.calcAzimuth(craftViewer.position(), targetPos);
            state.mode = Mode.AZIMUTH;
            state.lastAngle = Float.valueOf(angle);
            craftViewer.connection.send((Packet)ClientboundTrackedWaypointPacket.addWaypointAzimuth((UUID)targetId, (Waypoint.Icon)this.style, (float)angle));
        } else if (this.isChunkLoaded(viewer, chunkPos)) {
            state.mode = Mode.BLOCK;
            state.lastPos = blockPos;
            craftViewer.connection.send((Packet)ClientboundTrackedWaypointPacket.addWaypointPosition((UUID)targetId, (Waypoint.Icon)this.style, (Vec3i)blockPos));
        } else {
            state.mode = Mode.CHUNK;
            state.lastChunk = chunkPos;
            craftViewer.connection.send((Packet)ClientboundTrackedWaypointPacket.addWaypointChunk((UUID)targetId, (Waypoint.Icon)this.style, (ChunkPos)chunkPos));
        }
    }

    void update(Set<Player> viewers) {
        ServerPlayer craftTarget = NMSUtils.handler(this.target);
        for (Player viewer : viewers) {
            ServerPlayer craftViewer = NMSUtils.handler(viewer);
            Vec3 targetPos = this.positionFun != null ? this.positionFun.apply(this.target, viewer) : craftTarget.position();
            BlockPos pos = BlockPos.containing((Position)targetPos);
            ChunkPos chunkPos = new ChunkPos(pos);
            ViewerState state = this.viewerState.get(viewer);
            Mode mode = state.mode == null ? Mode.BLOCK : state.mode;
            UUID targetId = this.target.getUniqueId();
            if (craftViewer.position().distanceTo(targetPos) > 332.0) {
                float old;
                if (mode != Mode.AZIMUTH) {
                    state.mode = Mode.AZIMUTH;
                    craftViewer.connection.send((Packet)ClientboundTrackedWaypointPacket.removeWaypoint((UUID)targetId));
                    float angle = this.calcAzimuth(craftViewer.position(), targetPos);
                    state.lastAngle = Float.valueOf(angle);
                    craftViewer.connection.send((Packet)ClientboundTrackedWaypointPacket.addWaypointAzimuth((UUID)targetId, (Waypoint.Icon)this.style, (float)angle));
                    state.lastPos = null;
                    state.lastChunk = null;
                    continue;
                }
                float f = old = state.lastAngle == null ? 0.0f : state.lastAngle.floatValue();
                float neo = this.calcAzimuth(craftViewer.position(), targetPos);
                if (!(Math.abs(neo - old) > (float)Math.PI / 360)) continue;
                state.lastAngle = Float.valueOf(neo);
                craftViewer.connection.send((Packet)ClientboundTrackedWaypointPacket.updateWaypointAzimuth((UUID)targetId, (Waypoint.Icon)this.style, (float)neo));
                continue;
            }
            if (this.isChunkLoaded(viewer, chunkPos)) {
                if (mode != Mode.BLOCK) {
                    state.mode = Mode.BLOCK;
                    craftViewer.connection.send((Packet)ClientboundTrackedWaypointPacket.removeWaypoint((UUID)targetId));
                    state.lastPos = pos;
                    craftViewer.connection.send((Packet)ClientboundTrackedWaypointPacket.addWaypointPosition((UUID)targetId, (Waypoint.Icon)this.style, (Vec3i)pos));
                    state.lastChunk = null;
                    state.lastAngle = null;
                    continue;
                }
                BlockPos lastPos = state.lastPos;
                if (pos.equals((Object)lastPos)) continue;
                state.lastPos = pos;
                craftViewer.connection.send((Packet)ClientboundTrackedWaypointPacket.updateWaypointPosition((UUID)targetId, (Waypoint.Icon)this.style, (Vec3i)pos));
                continue;
            }
            if (mode != Mode.CHUNK) {
                state.mode = Mode.CHUNK;
                craftViewer.connection.send((Packet)ClientboundTrackedWaypointPacket.removeWaypoint((UUID)targetId));
                state.lastChunk = chunkPos;
                craftViewer.connection.send((Packet)ClientboundTrackedWaypointPacket.addWaypointChunk((UUID)targetId, (Waypoint.Icon)this.style, (ChunkPos)chunkPos));
                state.lastPos = null;
                state.lastAngle = null;
                continue;
            }
            ChunkPos lastChunk = state.lastChunk;
            if (lastChunk != null && chunkPos.getChessboardDistance(lastChunk) <= 0) continue;
            state.lastChunk = chunkPos;
            craftViewer.connection.send((Packet)ClientboundTrackedWaypointPacket.updateWaypointChunk((UUID)targetId, (Waypoint.Icon)this.style, (ChunkPos)chunkPos));
        }
    }

    private float calcAzimuth(Vec3 viewerPos, Vec3 targetPos) {
        Vec3 vector = viewerPos.subtract(targetPos).yRot(-90.0f);
        return (float)Mth.atan2((double)vector.z, (double)vector.x);
    }

    private boolean isChunkLoaded(Player viewer, ChunkPos pos) {
        return WaypointTransmitter.isChunkVisible((ChunkPos)pos, (ServerPlayer)NMSUtils.handler(viewer));
    }

    public void clear() {
        this.viewerState.clear();
    }

    public void clear(Player viewer) {
        this.viewerState.remove(viewer);
    }

    public static enum Mode {
        BLOCK,
        CHUNK,
        AZIMUTH;

    }
}

