/*
 * Decompiled with CFR 0.152.
 */
package me.lukiiy.manneInventory;

import java.util.HashMap;
import java.util.Map;
import me.lukiiy.barrel.Barrel;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Mannequin;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class MannequinInventoryManager {
    private static final NamespacedKey KEY = new NamespacedKey("manneinventory", "data");
    private static final Map<Mannequin, Inventory> cache = new HashMap<Mannequin, Inventory>();

    public static Inventory get(Mannequin mannequin) {
        String data = (String)mannequin.getPersistentDataContainer().get(KEY, PersistentDataType.STRING);
        if (data == null) {
            return null;
        }
        ItemStack[] items = Barrel.deserializeArray(data);
        Inventory inventory = Bukkit.createInventory(null, (int)items.length);
        inventory.setContents(items);
        return inventory;
    }

    public static Inventory create(Mannequin mannequin, int size) {
        Inventory inventory = Bukkit.createInventory(null, (int)size);
        MannequinInventoryManager.set(mannequin, inventory);
        return inventory;
    }

    public static void clear(Mannequin mannequin) {
        mannequin.getPersistentDataContainer().remove(KEY);
    }

    public static void set(Mannequin mannequin, Inventory inventory) {
        if (inventory == null) {
            MannequinInventoryManager.clear(mannequin);
            return;
        }
        String data = Barrel.serializeArray(inventory.getContents());
        if (data != null) {
            mannequin.getPersistentDataContainer().set(KEY, PersistentDataType.STRING, (Object)data);
        }
    }
}

