/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.v1_21_R5;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class VersionUtils {
    public static void saveMetaCustomModelData(ItemMeta meta, ConfigurationSection settings) {
        CustomModelDataComponent component = meta.getCustomModelDataComponent();
        ArrayList<CallSite> parsedColors = new ArrayList<CallSite>();
        for (Color color : component.getColors()) {
            parsedColors.add((CallSite)((Object)(color.getRed() + ";" + color.getGreen() + ";" + color.getBlue())));
        }
        ConfigurationSection cmdSection = settings.createSection("customModelData");
        cmdSection.set("colors", parsedColors);
        cmdSection.set("strings", (Object)component.getStrings());
        cmdSection.set("flags", (Object)component.getFlags());
        cmdSection.set("floats", (Object)component.getFloats());
    }

    public static void loadMetaCustomModelData(ItemMeta meta, ConfigurationSection settings) {
        CustomModelDataComponent component = meta.getCustomModelDataComponent();
        ConfigurationSection cmdSection = settings.getConfigurationSection("customModelData");
        if (cmdSection == null) {
            return;
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        List colorsList = cmdSection.getStringList("colors");
        for (String color : colorsList) {
            String[] colorParts = color.split("\\.");
            colors.add(Color.fromRGB((int)Integer.parseInt(colorParts[0]), (int)Integer.parseInt(colorParts[1]), (int)Integer.parseInt(colorParts[2])));
        }
        component.setColors(colors);
        component.setStrings(cmdSection.getStringList("strings"));
        component.setFlags(cmdSection.getBooleanList("flags"));
        component.setFloats(cmdSection.getFloatList("floats"));
        meta.setCustomModelDataComponent(component);
    }
}

