/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.v1_21_R4;

import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.logging.Level;
import me.lucaaa.advanceddisplays.api.util.ComponentSerializer;
import me.lucaaa.advanceddisplays.nms_common.InternalEntityClickEvent;
import me.lucaaa.advanceddisplays.nms_common.Logger;
import me.lucaaa.advanceddisplays.nms_common.Metadata;
import me.lucaaa.advanceddisplays.nms_common.PacketException;
import me.lucaaa.advanceddisplays.nms_common.PacketInterface;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementDisplay;
import net.minecraft.advancements.AdvancementFrameType;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.critereon.CriterionTriggerImpossible;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.World;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.Art;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Rotation;
import org.bukkit.advancement.AdvancementDisplayType;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R4.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import shaded.net.kyori.adventure.text.Component;

public class Packets
implements PacketInterface {
    private final Logger logger;
    private final Map<ChatColor, ScoreboardTeam> teams = new EnumMap<ChatColor, ScoreboardTeam>(ChatColor.class);

    public Packets(Logger logger) {
        this.logger = logger;
    }

    @Override
    public ChannelPipeline getPlayerPipeline(Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        return craftPlayer.getHandle().f.e.n.pipeline();
    }

    @Override
    public InternalEntityClickEvent getClickEvent(Player player, Object anyPacket) {
        if (!anyPacket.getClass().equals(PacketPlayInUseEntity.class)) {
            return null;
        }
        PacketPlayInUseEntity packet = (PacketPlayInUseEntity)anyPacket;
        try {
            Field actionField = packet.getClass().getDeclaredField("c");
            actionField.setAccessible(true);
            Object action = actionField.get(packet);
            try {
                Field handField = action.getClass().getDeclaredField("a");
                handField.setAccessible(true);
                Enum hand = (Enum)handField.get(action);
                if (hand == EnumHand.b) {
                    return null;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            return new InternalEntityClickEvent(InternalEntityClickEvent.getClickTypeFromPacket(packet.b(), packet.isAttack()), packet.getEntityId());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.logger.logError(Level.SEVERE, "An error occurred while handling a click on a display: ", e);
            return null;
        }
    }

    @Override
    public Entity createEntity(EntityType type, Location location) {
        CraftWorld world;
        WorldServer level;
        Optional optional = BuiltInRegistries.f.c(CraftNamespacedKey.toMinecraft((NamespacedKey)type.getKey()));
        if (optional.isEmpty()) {
            this.logger.logError(Level.SEVERE, "Entity not found for entity type \"" + type.name() + "\". ", new PacketException("Invalid entity type"));
            return null;
        }
        EntityTypes nmsType = (EntityTypes)((Holder.c)optional.get()).a();
        net.minecraft.world.entity.Entity entity = nmsType.a((World)(level = Objects.requireNonNull(world = (CraftWorld)location.getWorld()).getHandle()), EntitySpawnReason.h);
        if (entity == null) {
            this.logger.logError(Level.SEVERE, "Entity couldn't be created for entity type \"" + type.name() + "\". ", new PacketException("Entity not created"));
            return null;
        }
        entity.a_(location.getX(), location.getY(), location.getZ());
        Packet packet = entity.a(new EntityTrackerEntry(level.getMinecraftWorld(), entity, 0, false, consumer -> {}, (packet1, list) -> {}, Set.of()));
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            CraftPlayer cp = (CraftPlayer)onlinePlayer;
            PlayerConnection connection = cp.getHandle().f;
            connection.b(packet);
            this.setMetadata(entity.ao(), onlinePlayer, Metadata.DataInfo.ofBoolean(5), true);
        }
        return entity.getBukkitEntity();
    }

    @Override
    public void spawnEntity(Entity entity, Player player) {
        CraftPlayer cp = (CraftPlayer)player;
        PlayerConnection connection = cp.getHandle().f;
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        Packet packet = nmsEntity.a(new EntityTrackerEntry(((CraftWorld)entity.getWorld()).getHandle(), nmsEntity, 0, false, consumer -> {}, (packet1, list) -> {}, Set.of()));
        connection.b(packet);
        this.setMetadata(nmsEntity.ao(), player, Metadata.DataInfo.ofBoolean(5), true);
    }

    @Override
    public void removeEntity(int entityId, Player player) {
        CraftPlayer cp = (CraftPlayer)player;
        PlayerConnection connection = cp.getHandle().f;
        connection.b((Packet)new PacketPlayOutEntityDestroy(new int[]{entityId}));
    }

    @Override
    public void setLocation(Entity entity, Location location, Player player) {
        CraftPlayer cp = (CraftPlayer)player;
        PlayerConnection connection = cp.getHandle().f;
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        connection.b((Packet)new PacketPlayOutEntityTeleport(nmsEntity.ao(), PositionMoveRotation.a((net.minecraft.world.entity.Entity)nmsEntity), Set.of(), true));
    }

    @Override
    public void setGlowingColor(Entity entity, ChatColor color, Player player) {
        ScoreboardTeam team;
        CraftPlayer cp = (CraftPlayer)player;
        PlayerConnection connection = cp.getHandle().f;
        WorldServer level = ((CraftWorld)cp.getWorld()).getHandle();
        if (!this.teams.containsKey(color)) {
            team = new ScoreboardTeam((Scoreboard)level.g(), String.valueOf(entity.getEntityId()));
            team.a(EnumChatFormat.valueOf((String)color.name()));
            team.a(ScoreboardTeamBase.EnumTeamPush.b);
            this.teams.put(color, team);
        } else {
            team = this.teams.get(color);
        }
        connection.b((Packet)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team, (boolean)true));
        connection.b((Packet)PacketPlayOutScoreboardTeam.a((ScoreboardTeam)team, (String)String.valueOf(entity.getUniqueId()), (PacketPlayOutScoreboardTeam.a)PacketPlayOutScoreboardTeam.a.a));
    }

    @Override
    public void setMetadata(int displayId, Player player, Metadata.DataPair<?> ... data) {
        CraftPlayer cp = (CraftPlayer)player;
        PlayerConnection connection = cp.getHandle().f;
        ArrayList allMetadata = new ArrayList();
        for (Metadata.DataPair<?> metadata : data) {
            allMetadata.add(this.createDataValue(cp, metadata));
        }
        connection.b((Packet)new PacketPlayOutEntityMetadata(displayId, allMetadata));
    }

    private DataWatcher.c<?> createDataValue(CraftPlayer cp, Metadata.DataPair<?> metadata) {
        Object value = metadata.value();
        int id = metadata.data().id();
        return switch (metadata.data().type()) {
            default -> throw new MatchException(null, null);
            case Metadata.DataType.BOOLEAN -> DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.k), (Object)((Boolean)value));
            case Metadata.DataType.INT -> DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.b), (Object)((Integer)value));
            case Metadata.DataType.FLOAT -> DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.d), (Object)Float.valueOf(((Float)value).floatValue()));
            case Metadata.DataType.BYTE -> DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.a), (Object)((Byte)value));
            case Metadata.DataType.COMPONENT -> DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.f), (Object)((IChatBaseComponent)Objects.requireNonNull(IChatBaseComponent.ChatSerializer.a((String)ComponentSerializer.toJSONString((Component)value), (HolderLookup.a)cp.getHandle().dX()))));
            case Metadata.DataType.OPTIONAL_COMPONENT -> {
                Optional optional = (Optional)value;
                Optional<IChatBaseComponent> component = optional.map(component1 -> IChatBaseComponent.ChatSerializer.a((String)ComponentSerializer.toJSONString(component1), (HolderLookup.a)cp.getHandle().dX()));
                yield DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.g), component);
            }
            case Metadata.DataType.ITEM_STACK -> DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.h), (Object)CraftItemStack.asNMSCopy((ItemStack)((ItemStack)value)));
            case Metadata.DataType.BLOCK_STATE -> DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.i), (Object)((CraftBlockData)value).getState());
            case Metadata.DataType.VECTOR3 -> DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.H), (Object)((Vector3f)value));
            case Metadata.DataType.QUATERNION -> DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.I), (Object)((Quaternionf)value));
            case Metadata.DataType.BLOCK_FACE -> {
                BlockFace blockFace = (BlockFace)value;
                EnumDirection direction = blockFace.isCartesian() ? EnumDirection.valueOf((String)blockFace.name()) : EnumDirection.d;
                yield DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.q), (Object)direction);
            }
            case Metadata.DataType.ROTATION -> DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.b), (Object)((Rotation)value).ordinal());
            case Metadata.DataType.ART -> DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.E), (Object)Holder.a((Object)((PaintingVariant)CraftRegistry.bukkitToMinecraft((Keyed)((Art)value)))));
            case Metadata.DataType.DYE_COLOR -> DataWatcher.c.a((DataWatcherObject)new DataWatcherObject(id, DataWatcherRegistry.b), (Object)EnumColor.valueOf((String)((DyeColor)value).name()).ordinal());
        };
    }

    @Override
    public void sendToast(Consumer<Runnable> taskRunner, Player player, ItemStack item, String titleJSON, String descriptionJSON, AdvancementDisplayType type) {
        CraftPlayer cp = (CraftPlayer)player;
        PlayerConnection connection = cp.getHandle().f;
        MinecraftKey resourceLocation = MinecraftKey.a((String)"advanceddisplays", (String)UUID.randomUUID().toString());
        AdvancementDisplay info = new AdvancementDisplay(CraftItemStack.asNMSCopy((ItemStack)item), (IChatBaseComponent)Objects.requireNonNull(IChatBaseComponent.ChatSerializer.a((String)titleJSON, (HolderLookup.a)cp.getHandle().dX())), (IChatBaseComponent)Objects.requireNonNull(IChatBaseComponent.ChatSerializer.a((String)descriptionJSON, (HolderLookup.a)cp.getHandle().dX())), Optional.empty(), AdvancementFrameType.valueOf((String)type.name()), true, false, true);
        Map<String, Criterion> criteria = Map.of("impossible", new Criterion((CriterionTrigger)new CriterionTriggerImpossible(), (CriterionInstance)new CriterionTriggerImpossible.a()));
        AdvancementRequirements requirements = new AdvancementRequirements(List.of(List.of("impossible")));
        Advancement advancement = new Advancement(Optional.empty(), Optional.of(info), AdvancementRewards.b, criteria, requirements, false);
        AdvancementProgress progress = new AdvancementProgress();
        progress.a(requirements);
        Objects.requireNonNull(progress.c("impossible")).b();
        connection.b((Packet)new PacketPlayOutAdvancements(false, List.of(new AdvancementHolder(resourceLocation, advancement)), Set.of(), Map.of(resourceLocation, progress), true));
        taskRunner.accept(() -> connection.b((Packet)new PacketPlayOutAdvancements(false, List.of(), Set.of(resourceLocation), Map.of(), true)));
    }
}

