/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.nms_common;

import java.util.List;

public enum Version {
    UNKNOWN(List.of("unknown")),
    v1_19_R3(List.of("1.19.4")),
    v1_20_R1(List.of("1.20", "1.20.1")),
    v1_20_R2(List.of("1.20.2")),
    v1_20_R3(List.of("1.20.3", "1.20.4")),
    v1_20_R4(List.of("1.20.5", "1.20.6")),
    v1_21_R1(List.of("1.21", "1.21.1")),
    v1_21_R2(List.of("1.21.2", "1.21.3")),
    v1_21_R3(List.of("1.21.4")),
    v1_21_R4(List.of("1.21.5")),
    v1_21_R5(List.of("1.21.6", "1.21.7", "1.21.8")),
    v1_21_R6(List.of("1.21.9", "1.21.10")),
    v1_21_R7(List.of("1.21.11"));

    private final List<String> mcVersions;

    private Version(List<String> mcVersions) {
        this.mcVersions = mcVersions;
    }

    public static Version getNMSVersion(String mcVersion) {
        for (Version version : Version.values()) {
            if (!version.mcVersions.contains(mcVersion)) continue;
            return version;
        }
        return UNKNOWN;
    }

    public boolean isEqualOrNewerThan(Version version) {
        return this.ordinal() >= version.ordinal();
    }
}

