/*
 * Decompiled with CFR 0.152.
 */
package me.lucaaa.advanceddisplays.nms_common;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import me.lucaaa.advanceddisplays.api.displays.enums.Property;
import me.lucaaa.advanceddisplays.nms_common.Version;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Display;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import shaded.net.kyori.adventure.text.Component;

public class Metadata {
    public final Map<Property<?>, DataInfo<?>> propertyData = new HashMap();
    public final DataInfo<Byte> PROPERTIES = DataInfo.ofByte(0);
    public final DataInfo<Optional<Component>> CUSTOM_NAME = new DataInfo(2, DataType.OPTIONAL_COMPONENT);
    public final DataInfo<Boolean> CUSTOM_NAME_VISIBLE = DataInfo.ofBoolean(3);
    public final DataInfo<Float> HITBOX_WIDTH = DataInfo.ofFloat(8);
    public final DataInfo<Float> HITBOX_HEIGHT = DataInfo.ofFloat(9);
    public final DataInfo<Vector3f> TRANSLATION;
    public final DataInfo<Vector3f> SCALE;
    public final DataInfo<Quaternionf> LEFT_ROTATION;
    public final DataInfo<Quaternionf> RIGHT_ROTATION;
    public final DataInfo<Byte> BILLBOARD;
    public final DataInfo<Integer> BRIGHTNESS;
    public final DataInfo<Float> SHADOW_RADIUS;
    public final DataInfo<Float> SHADOW_STRENGTH;
    public final DataInfo<Integer> GLOW_COLOR;
    public final DataInfo<Component> TEXT;
    public final DataInfo<Integer> LINE_WIDTH;
    public final DataInfo<Integer> BG_COLOR;
    public final DataInfo<Byte> TEXT_OPACITY;
    public final DataInfo<Byte> TEXT_PROPERTIES;
    public final DataInfo<BlockData> BLOCK;
    public final DataInfo<ItemStack> ITEM;
    public final DataInfo<Byte> ITEM_TRANSFORM;

    public Metadata(Version version) {
        if (version.isEqualOrNewerThan(Version.v1_20_R2)) {
            this.TRANSLATION = DataInfo.ofVector3f(11);
            this.SCALE = DataInfo.ofVector3f(12);
            this.LEFT_ROTATION = DataInfo.ofQuaternionf(13);
            this.RIGHT_ROTATION = DataInfo.ofQuaternionf(14);
            this.BILLBOARD = DataInfo.ofByte(15);
            this.BRIGHTNESS = DataInfo.ofInt(16);
            this.SHADOW_RADIUS = DataInfo.ofFloat(18);
            this.SHADOW_STRENGTH = DataInfo.ofFloat(19);
            this.GLOW_COLOR = DataInfo.ofInt(22);
            this.TEXT = DataInfo.ofComponent(23);
            this.LINE_WIDTH = DataInfo.ofInt(24);
            this.BG_COLOR = DataInfo.ofInt(25);
            this.TEXT_OPACITY = DataInfo.ofByte(26);
            this.TEXT_PROPERTIES = DataInfo.ofByte(27);
            this.ITEM = DataInfo.ofItemStack(23);
            this.ITEM_TRANSFORM = DataInfo.ofByte(24);
            this.BLOCK = DataInfo.ofBlockData(23);
        } else {
            this.TRANSLATION = DataInfo.ofVector3f(10);
            this.SCALE = DataInfo.ofVector3f(11);
            this.LEFT_ROTATION = DataInfo.ofQuaternionf(12);
            this.RIGHT_ROTATION = DataInfo.ofQuaternionf(13);
            this.BILLBOARD = DataInfo.ofByte(14);
            this.BRIGHTNESS = DataInfo.ofInt(15);
            this.SHADOW_RADIUS = DataInfo.ofFloat(17);
            this.SHADOW_STRENGTH = DataInfo.ofFloat(18);
            this.GLOW_COLOR = DataInfo.ofInt(21);
            this.TEXT = DataInfo.ofComponent(22);
            this.LINE_WIDTH = DataInfo.ofInt(23);
            this.BG_COLOR = DataInfo.ofInt(24);
            this.TEXT_OPACITY = DataInfo.ofByte(25);
            this.TEXT_PROPERTIES = DataInfo.ofByte(26);
            this.ITEM = DataInfo.ofItemStack(22);
            this.ITEM_TRANSFORM = DataInfo.ofByte(23);
            this.BLOCK = DataInfo.ofBlockData(22);
        }
    }

    public <T> DataPair<T> createDataPair(Map<Property<?>, Object> properties, Property<T> property, T value) {
        if (!this.propertyData.containsKey(property)) {
            return null;
        }
        DataInfo<?> dataInfo = this.propertyData.get(property);
        if (property.hasBytePack()) {
            return new DataPair<Byte>(dataInfo, property.getByteFlags(properties));
        }
        return new DataPair(dataInfo, value);
    }

    public static byte getProperties(boolean onFire, boolean sprinting, boolean glowing) {
        byte options = 0;
        if (onFire) {
            options = (byte)(options | 1);
        }
        if (sprinting) {
            options = (byte)(options | 8);
        }
        if (glowing) {
            options = (byte)(options | 0x40);
        }
        return options;
    }

    public static byte getBillboardByte(Display.Billboard billboard) {
        return switch (billboard) {
            default -> throw new IncompatibleClassChangeError();
            case Display.Billboard.FIXED -> 0;
            case Display.Billboard.VERTICAL -> 1;
            case Display.Billboard.HORIZONTAL -> 2;
            case Display.Billboard.CENTER -> 3;
        };
    }

    public static byte getTextProperties(boolean isShadowed, boolean isSeeThrough, boolean defaultBackground, TextDisplay.TextAlignment alignment) {
        byte options = 0;
        if (isShadowed) {
            options = (byte)(options | 1);
        }
        if (isSeeThrough) {
            options = (byte)(options | 2);
        }
        if (defaultBackground) {
            options = (byte)(options | 4);
        }
        switch (alignment) {
            case CENTER: {
                break;
            }
            case LEFT: {
                options = (byte)(options | 8);
                break;
            }
            case RIGHT: {
                options = (byte)(options | 0x10);
            }
        }
        return options;
    }

    public record DataInfo<T>(int id, DataType type) {
        public static DataInfo<Boolean> ofBoolean(int id) {
            return new DataInfo<Boolean>(id, DataType.BOOLEAN);
        }

        public static DataInfo<Integer> ofInt(int id) {
            return new DataInfo<Integer>(id, DataType.INT);
        }

        public static DataInfo<Float> ofFloat(int id) {
            return new DataInfo<Float>(id, DataType.FLOAT);
        }

        public static DataInfo<Byte> ofByte(int id) {
            return new DataInfo<Byte>(id, DataType.BYTE);
        }

        public static DataInfo<Component> ofComponent(int id) {
            return new DataInfo<Component>(id, DataType.COMPONENT);
        }

        public static DataInfo<ItemStack> ofItemStack(int id) {
            return new DataInfo<ItemStack>(id, DataType.ITEM_STACK);
        }

        public static DataInfo<BlockData> ofBlockData(int id) {
            return new DataInfo<BlockData>(id, DataType.BLOCK_STATE);
        }

        public static DataInfo<Vector3f> ofVector3f(int id) {
            return new DataInfo<Vector3f>(id, DataType.VECTOR3);
        }

        public static DataInfo<Quaternionf> ofQuaternionf(int id) {
            return new DataInfo<Quaternionf>(id, DataType.QUATERNION);
        }
    }

    public static enum DataType {
        BOOLEAN,
        INT,
        FLOAT,
        BYTE,
        COMPONENT,
        OPTIONAL_COMPONENT,
        ITEM_STACK,
        BLOCK_STATE,
        VECTOR3,
        QUATERNION,
        BLOCK_FACE,
        ROTATION,
        ART,
        DYE_COLOR;

    }

    public record DataPair<T>(DataInfo<T> data, T value) {
    }
}

